/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.appliedenergistics;

import appeng.api.AEApi;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import java.util.HashMap;
import java.util.Map;
import org.squiddev.plethora.api.meta.TypedMeta;
import org.squiddev.plethora.api.method.ContextHelpers;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.LuaList;
import org.squiddev.plethora.api.method.TypedLuaObject;
import org.squiddev.plethora.api.method.wrapper.FromTarget;
import org.squiddev.plethora.api.method.wrapper.Optional;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.integration.ItemFingerprint;
import org.squiddev.plethora.integration.appliedenergistics.MetaAppliedEnergistics;

public final class MethodsGrid {
    private MethodsGrid() {
    }

    @PlethoraMethod(modId="appliedenergistics2", doc="-- Get the energy usage of this AE node")
    public static double getNodeEnergyUsage(@FromTarget IGridBlock grid) {
        return grid.getIdlePowerUsage();
    }

    @PlethoraMethod(modId="appliedenergistics2", doc="-- Get the energy usage of this AE network")
    public static double getNetworkEnergyUsage(@FromTarget IGrid grid) {
        IEnergyGrid energy = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
        return energy.getAvgPowerUsage();
    }

    @PlethoraMethod(modId="appliedenergistics2", doc="function():int -- Get the energy stored usage in this AE network")
    public static double getNetworkEnergyStored(@FromTarget IGrid grid) {
        IEnergyGrid energy = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
        return energy.getStoredPower();
    }

    @PlethoraMethod(modId="appliedenergistics2", doc="-- List all items which are stored in the network")
    public static Map<Integer, ?> listAvailableItems(IContext<IGrid> context) {
        IGrid grid = (IGrid)context.getTarget();
        IStorageGrid storageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class);
        IItemStorageChannel channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        IItemList items = storageGrid.getInventory((IStorageChannel)channel).getStorageList();
        LuaList<HashMap<String, Object>> output = new LuaList<HashMap<String, Object>>(items.size());
        for (IAEItemStack stack : items) {
            output.add(MetaAppliedEnergistics.getItemStackProperties(stack));
        }
        return output.asMap();
    }

    @Optional
    @PlethoraMethod(modId="appliedenergistics2", doc="function(item:string|table):table -- Search for an item in the network. You can specify the item as a string, with or without the damage value ('minecraft:stone' or 'minecraft:stone@0') or as a table with 'name', 'damage' and 'nbthash' fields. You must specify the 'name', but you can leave the other fields empty.")
    public static TypedLuaObject<IAEItemStack> findItem(IContext<IGrid> baked, ItemFingerprint fingerprint) {
        IAEItemStack stack = MethodsGrid.findStack((IGrid)baked.getTarget(), fingerprint);
        return stack == null ? null : baked.makeChildId(stack).getObject();
    }

    @PlethoraMethod(modId="appliedenergistics2", doc="-- Search all items in the network. You can specify the item as a string, with or without the damage value ('minecraft:stone' or 'minecraft:stone@0') or as a table with 'name', 'damage' and 'nbthash' fields. You must specify the 'name', but you can leave the other fields empty.")
    public static Map<Integer, TypedLuaObject<IAEItemStack>> findItems(IContext<IGrid> context, ItemFingerprint item) {
        IItemStorageChannel channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        IStorageGrid grid = (IStorageGrid)((IGrid)context.getTarget()).getCache(IStorageGrid.class);
        int i = 0;
        HashMap<Integer, TypedLuaObject<IAEItemStack>> out = new HashMap<Integer, TypedLuaObject<IAEItemStack>>();
        for (IAEItemStack aeStack : grid.getInventory((IStorageChannel)channel).getStorageList()) {
            if (!item.matches(aeStack.getDefinition())) continue;
            out.put(++i, context.makeChildId(aeStack).getObject());
        }
        return out;
    }

    @PlethoraMethod(modId="appliedenergistics2", doc="-- List all crafting cpus in the network")
    public static Map<Integer, TypedMeta<ICraftingCPU, ?>> getCraftingCPUs(IContext<IGrid> context) {
        ICraftingGrid crafting = (ICraftingGrid)((IGrid)context.getTarget()).getCache(ICraftingGrid.class);
        return ContextHelpers.getMetaList(context, crafting.getCpus());
    }

    private static IAEItemStack findStack(IGrid network, ItemFingerprint fingerprint) {
        IItemStorageChannel channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        IStorageGrid grid = (IStorageGrid)network.getCache(IStorageGrid.class);
        for (IAEItemStack aeStack : grid.getInventory((IStorageChannel)channel).getStorageList()) {
            if (!fingerprint.matches(aeStack.getDefinition())) continue;
            return aeStack;
        }
        return null;
    }
}

