/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.redstone;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralTile;
import dan200.computercraft.core.apis.ArgumentHelper;
import dan200.computercraft.shared.BundledRedstone;
import dan200.computercraft.shared.common.TileGeneric;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import org.squiddev.plethora.gameplay.Plethora;
import org.squiddev.plethora.gameplay.redstone.BlockRedstoneIntegrator;

public class TileRedstoneIntegrator
extends TileGeneric
implements IPeripheral,
IPeripheralTile {
    private final byte[] inputs = new byte[6];
    private final byte[] outputs = new byte[6];
    private final int[] bundledInputs = new int[6];
    private final int[] bundledOutputs = new int[6];
    private boolean outputDirty = false;
    private boolean inputDirty = false;
    private final Set<IComputerAccess> computers = Collections.newSetFromMap(new ConcurrentHashMap());

    private void updateInput() {
        World world = this.func_145831_w();
        if (world == null || world.field_72995_K || this.func_145837_r() || !world.func_175667_e(this.field_174879_c)) {
            return;
        }
        boolean changed = false;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            short newBundled;
            BlockPos offset = this.field_174879_c.func_177972_a(dir);
            EnumFacing offsetSide = dir.func_176734_d();
            int dirIdx = dir.ordinal();
            byte newInput = (byte)TileRedstoneIntegrator.getRedstoneInput(world, offset, offsetSide);
            if (newInput != this.inputs[dirIdx]) {
                this.inputs[dirIdx] = newInput;
                changed = true;
            }
            if (this.bundledInputs[dirIdx] == (newBundled = (short)BundledRedstone.getOutput((World)world, (BlockPos)offset, (EnumFacing)offsetSide))) continue;
            this.bundledInputs[dirIdx] = newBundled;
            changed = true;
        }
        if (changed) {
            this.enqueueInputTick();
        }
    }

    private void enqueueInputTick() {
        if (!this.inputDirty) {
            this.inputDirty = true;
            BlockRedstoneIntegrator.enqueueTick(this);
        }
    }

    private void enqueueOutputTick() {
        if (!this.outputDirty) {
            this.outputDirty = true;
            BlockRedstoneIntegrator.enqueueTick(this);
        }
    }

    void updateOnce() {
        World world = this.func_145831_w();
        if (world == null || world.field_72995_K || this.func_145837_r() || !world.func_175667_e(this.field_174879_c)) {
            return;
        }
        if (this.outputDirty) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                TileRedstoneIntegrator.propagateRedstoneOutput(world, this.field_174879_c, dir);
            }
            this.outputDirty = false;
        }
        if (this.inputDirty) {
            Iterator<IComputerAccess> computers = this.computers.iterator();
            while (computers.hasNext()) {
                IComputerAccess computer = computers.next();
                try {
                    computer.queueEvent("redstone", new Object[]{computer.getAttachmentName()});
                }
                catch (RuntimeException e) {
                    Plethora.LOG.error("Could not queue redstone event", (Throwable)e);
                    computers.remove();
                }
            }
            this.inputDirty = false;
        }
    }

    private static int getRedstoneInput(World world, BlockPos pos, EnumFacing side) {
        int power = world.func_175651_c(pos, side);
        if (power >= 15) {
            return power;
        }
        IBlockState neighbour = world.func_180495_p(pos);
        return neighbour.func_177230_c() == Blocks.field_150488_af ? Math.max(power, (Integer)neighbour.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O)) : power;
    }

    private static void propagateRedstoneOutput(World world, BlockPos pos, EnumFacing side) {
        IBlockState block = world.func_180495_p(pos);
        if (ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)pos, (IBlockState)block, EnumSet.of(side), (boolean)false).isCanceled()) {
            return;
        }
        BlockPos neighbourPos = pos.func_177972_a(side);
        world.func_190524_a(neighbourPos, block.func_177230_c(), pos);
        world.func_175695_a(neighbourPos, block.func_177230_c(), side.func_176734_d());
    }

    public void onLoad() {
        super.onLoad();
        this.enqueueOutputTick();
    }

    public void onNeighbourChange(@Nonnull BlockPos pos) {
        this.updateInput();
    }

    public boolean getRedstoneConnectivity(EnumFacing side) {
        return true;
    }

    public int getRedstoneOutput(EnumFacing side) {
        return this.outputs[side.ordinal()];
    }

    public boolean getBundledRedstoneConnectivity(@Nonnull EnumFacing side) {
        return true;
    }

    public int getBundledRedstoneOutput(@Nonnull EnumFacing side) {
        return this.bundledOutputs[side.ordinal()];
    }

    @Nonnull
    public String getType() {
        return "redstone_integrator";
    }

    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"getSides", "setOutput", "getOutput", "getInput", "setBundledOutput", "getBundledOutput", "getBundledInput", "testBundledInput", "setAnalogOutput", "setAnalogueOutput", "getAnalogOutput", "getAnalogueOutput", "getAnalogInput", "getAnalogueInput"};
    }

    public Object[] callMethod(@Nonnull IComputerAccess computer, @Nonnull ILuaContext context, int method, @Nonnull Object[] args) throws LuaException {
        switch (method) {
            case 0: {
                HashMap<Integer, String> result = new HashMap<Integer, String>();
                for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
                    result.put(i + 1, EnumFacing.field_82609_l[i].func_176610_l());
                }
                return new Object[]{result};
            }
            case 1: {
                int power;
                int side = TileRedstoneIntegrator.getFacing(args, 0).ordinal();
                this.outputs[side] = power = ArgumentHelper.getBoolean((Object[])args, (int)1) ? 15 : 0;
                this.enqueueOutputTick();
                return null;
            }
            case 2: {
                int side = TileRedstoneIntegrator.getFacing(args, 0).ordinal();
                return new Object[]{this.outputs[side] > 0};
            }
            case 3: {
                int side = TileRedstoneIntegrator.getFacing(args, 0).ordinal();
                return new Object[]{this.inputs[side] > 0};
            }
            case 4: {
                int power;
                int side = TileRedstoneIntegrator.getFacing(args, 0).ordinal();
                this.bundledOutputs[side] = power = ArgumentHelper.getInt((Object[])args, (int)1);
                this.enqueueOutputTick();
                return null;
            }
            case 5: {
                int side = TileRedstoneIntegrator.getFacing(args, 0).ordinal();
                return new Object[]{this.bundledOutputs[side]};
            }
            case 6: {
                int side = TileRedstoneIntegrator.getFacing(args, 0).ordinal();
                return new Object[]{this.bundledInputs[side]};
            }
            case 7: {
                int side = TileRedstoneIntegrator.getFacing(args, 0).ordinal();
                int power = ArgumentHelper.getInt((Object[])args, (int)1);
                return new Object[]{(this.bundledInputs[side] & power) == power};
            }
            case 8: 
            case 9: {
                int side = TileRedstoneIntegrator.getFacing(args, 0).ordinal();
                int power = ArgumentHelper.getInt((Object[])args, (int)1);
                org.squiddev.plethora.api.method.ArgumentHelper.assertBetween(power, 0, 15, "Power out of range (%s)");
                this.outputs[side] = (byte)power;
                this.enqueueOutputTick();
                return null;
            }
            case 10: 
            case 11: {
                int side = TileRedstoneIntegrator.getFacing(args, 0).ordinal();
                return new Object[]{this.outputs[side]};
            }
            case 12: 
            case 13: {
                int side = TileRedstoneIntegrator.getFacing(args, 0).ordinal();
                return new Object[]{this.inputs[side]};
            }
        }
        return null;
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.computers.add(computer);
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    private static EnumFacing getFacing(Object[] args, int index) throws LuaException {
        String value = ArgumentHelper.getString((Object[])args, (int)index);
        if (value.equalsIgnoreCase("bottom")) {
            return EnumFacing.DOWN;
        }
        if (value.equalsIgnoreCase("top")) {
            return EnumFacing.UP;
        }
        EnumFacing facing = EnumFacing.func_176739_a((String)value);
        if (facing == null) {
            throw new LuaException("Bad name '" + value.toLowerCase(Locale.ENGLISH) + "' for argument " + (index + 1));
        }
        return facing;
    }

    @Nullable
    public IPeripheral getPeripheral(@Nonnull EnumFacing facing) {
        return this;
    }
}

