/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.redstone;

import dan200.computercraft.shared.common.BlockGeneric;
import dan200.computercraft.shared.common.TileGeneric;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.squiddev.plethora.gameplay.Plethora;
import org.squiddev.plethora.gameplay.redstone.TileRedstoneIntegrator;

@Mod.EventBusSubscriber(modid="plethora")
public class BlockRedstoneIntegrator
extends BlockGeneric {
    private static final Set<TileRedstoneIntegrator> toTick = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final String NAME = "redstone_integrator";

    public BlockRedstoneIntegrator() {
        super(Material.field_151576_e);
        this.setRegistryName(new ResourceLocation("plethora", NAME));
        this.func_149711_c(2.0f);
        this.func_149663_c("plethora.redstone_integrator");
        this.func_149647_a(Plethora.getCreativeTab());
    }

    protected IBlockState getDefaultBlockState(int meta, EnumFacing direction) {
        return this.field_176227_L.func_177621_b();
    }

    protected TileGeneric createTile(IBlockState blockState) {
        return new TileRedstoneIntegrator();
    }

    protected TileGeneric createTile(int meta) {
        return new TileRedstoneIntegrator();
    }

    @Nonnull
    @Deprecated
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public static void enqueueTick(TileRedstoneIntegrator tile) {
        toTick.add(tile);
    }

    @SubscribeEvent
    public static void handleTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            Iterator<TileRedstoneIntegrator> iterator = toTick.iterator();
            while (iterator.hasNext()) {
                TileRedstoneIntegrator tile = iterator.next();
                tile.updateOnce();
                iterator.remove();
            }
        }
    }

    @SubscribeEvent
    public static void handleUnload(WorldEvent.Unload e) {
        World eventWorld = e.getWorld();
        if (!eventWorld.field_72995_K) {
            Iterator<TileRedstoneIntegrator> iterator = toTick.iterator();
            while (iterator.hasNext()) {
                World world = iterator.next().func_145831_w();
                if (world != null && world != eventWorld) continue;
                iterator.remove();
            }
        }
    }
}

