/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.neural;

import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.squiddev.plethora.api.Constants;
import org.squiddev.plethora.api.IPeripheralHandler;
import org.squiddev.plethora.core.executor.TaskRunner;
import org.squiddev.plethora.gameplay.neural.NeuralHelpers;
import org.squiddev.plethora.utils.Helpers;

public class NeuralComputer
extends ServerComputer {
    private WeakReference<EntityLivingBase> entity;
    private final NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);
    private int moduleHash;
    private final Map<ResourceLocation, NBTTagCompound> moduleData = new HashMap<ResourceLocation, NBTTagCompound>();
    private boolean moduleDataDirty = false;
    private final TaskRunner runner = new TaskRunner();

    public NeuralComputer(World world, int computerID, String label, int instanceID) {
        super(world, computerID, label, instanceID, ComputerFamily.Advanced, 39, 13);
    }

    public TaskRunner getExecutor() {
        return this.runner;
    }

    public void readModuleData(NBTTagCompound tag) {
        for (String key : tag.func_150296_c()) {
            this.moduleData.put(new ResourceLocation(key), tag.func_74775_l(key));
        }
    }

    public NBTTagCompound getModuleData(ResourceLocation location) {
        NBTTagCompound tag = this.moduleData.get(location);
        if (tag == null) {
            tag = new NBTTagCompound();
            this.moduleData.put(location, tag);
        }
        return tag;
    }

    public void markModuleDataDirty() {
        this.moduleDataDirty = true;
    }

    public int getModuleHash() {
        return this.moduleHash;
    }

    public boolean update(@Nonnull EntityLivingBase owner, @Nonnull ItemStack stack, int dirtyStatus) {
        int slot;
        EntityLivingBase existing;
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        EntityLivingBase entityLivingBase = existing = this.entity == null ? null : (EntityLivingBase)this.entity.get();
        if (existing != owner) {
            dirtyStatus = -1;
            this.entity = owner.func_70089_S() ? new WeakReference<EntityLivingBase>(owner) : null;
        }
        this.setWorld(owner.func_130014_f_());
        this.setPosition(owner.func_180425_c());
        if (dirtyStatus != 0) {
            for (slot = 0; slot < 10; ++slot) {
                if ((dirtyStatus & 1 << slot) != 1 << slot) continue;
                this.stacks.set(slot, (Object)handler.getStackInSlot(slot));
            }
            this.moduleHash = Helpers.hashStacks(this.stacks.subList(5, 10));
        }
        for (slot = 0; slot < 5; ++slot) {
            IPeripheralHandler peripheralHandler;
            ItemStack peripheral = (ItemStack)this.stacks.get(slot);
            if (peripheral.func_190926_b() || (peripheralHandler = (IPeripheralHandler)peripheral.getCapability(Constants.PERIPHERAL_HANDLER_CAPABILITY, null)) == null) continue;
            peripheralHandler.update(owner.func_130014_f_(), new Vec3d(owner.field_70165_t, owner.field_70163_u + (double)owner.func_70047_e(), owner.field_70161_v), owner);
        }
        if (dirtyStatus != 0) {
            for (slot = 0; slot < 5; ++slot) {
                if ((dirtyStatus & 1 << slot) != 1 << slot) continue;
                this.setPeripheral(ComputerSide.valueOf((int)(slot < 2 ? slot : slot + 1)), NeuralHelpers.buildPeripheral((ItemStack)this.stacks.get(slot)));
            }
            if (dirtyStatus >> 5 != 0) {
                this.setPeripheral(ComputerSide.BACK, NeuralHelpers.buildModules(this, this.stacks, (Entity)owner));
            }
        }
        this.runner.func_73660_a();
        if (this.moduleDataDirty) {
            this.moduleDataDirty = false;
            NBTTagCompound tag = new NBTTagCompound();
            for (Map.Entry<ResourceLocation, NBTTagCompound> entry : this.moduleData.entrySet()) {
                tag.func_74782_a(entry.getKey().toString(), (NBTBase)entry.getValue());
            }
            stack.func_77978_p().func_74782_a("module_data", (NBTBase)tag);
            return true;
        }
        return false;
    }
}

