/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses.objects.object2d;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.ArgumentHelper;
import javax.annotation.Nonnull;
import org.squiddev.plethora.api.method.wrapper.FromTarget;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object2d.MultiPoint2D;
import org.squiddev.plethora.utils.Vec2d;

public interface MultiPointResizable2D
extends MultiPoint2D {
    public static final int MAX_SIZE = 255;

    public void removePoint(int var1);

    public void addPoint(int var1, @Nonnull Vec2d var2);

    @PlethoraMethod(doc="-- Get the number of verticies on this object.", worldThread=false)
    public static int getPointCount(@FromTarget MultiPointResizable2D object) {
        return object.getVertices();
    }

    @PlethoraMethod(doc="function(idx:int) -- Remove the specified vertex of this object.", worldThread=false)
    public static void removePoint(@FromTarget MultiPointResizable2D object, int idx) throws LuaException {
        org.squiddev.plethora.api.method.ArgumentHelper.assertBetween(idx, 1, object.getVertices(), "Index out of range (%s)");
        object.removePoint(idx - 1);
    }

    @PlethoraMethod(doc="function([idx:int, ]x:number, y:number) -- Add a specified vertex to this object.", worldThread=false)
    public static void insertPoint(@FromTarget MultiPointResizable2D object, Object[] args) throws LuaException {
        float y;
        float x;
        int idx;
        if (object.getVertices() > 255) {
            throw new LuaException("To many vertices");
        }
        if (args.length >= 3) {
            idx = ArgumentHelper.getInt((Object[])args, (int)0);
            x = org.squiddev.plethora.api.method.ArgumentHelper.getFloat(args, 1);
            y = org.squiddev.plethora.api.method.ArgumentHelper.getFloat(args, 2);
            org.squiddev.plethora.api.method.ArgumentHelper.assertBetween(idx, 1, object.getVertices() + 1, "Index out of range (%s)");
        } else {
            idx = object.getVertices();
            x = org.squiddev.plethora.api.method.ArgumentHelper.getFloat(args, 0);
            y = org.squiddev.plethora.api.method.ArgumentHelper.getFloat(args, 1);
        }
        object.addPoint(idx - 1, new Vec2d(x, y));
    }
}

