/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.squiddev.plethora.api.Constants;
import org.squiddev.plethora.api.IPlayerOwnable;
import org.squiddev.plethora.core.executor.TaskRunner;
import org.squiddev.plethora.gameplay.TileBase;
import org.squiddev.plethora.gameplay.modules.BlockManipulator;
import org.squiddev.plethora.gameplay.modules.ManipulatorType;
import org.squiddev.plethora.gameplay.registry.Registration;
import org.squiddev.plethora.utils.Helpers;

public final class TileManipulator
extends TileBase
implements ITickable,
IPlayerOwnable {
    private ManipulatorType type;
    private NonNullList<ItemStack> stacks;
    private GameProfile profile;
    private int stackHash;
    private final Map<ResourceLocation, NBTTagCompound> moduleData = new HashMap<ResourceLocation, NBTTagCompound>();
    private final TaskRunner runner = new TaskRunner();
    private double offset = -1.0;
    private long tick;

    public TileManipulator() {
    }

    public TileManipulator(ManipulatorType type) {
        this.setType(type);
    }

    private void setType(ManipulatorType type) {
        if (this.type != null) {
            return;
        }
        this.type = type;
        this.stacks = NonNullList.func_191197_a((int)type.size(), (Object)ItemStack.field_190927_a);
    }

    public ManipulatorType getType() {
        return this.type;
    }

    public EnumFacing getFacing() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        return state.func_177230_c() == Registration.blockManipulator ? (EnumFacing)state.func_177229_b((IProperty)BlockManipulator.FACING) : EnumFacing.DOWN;
    }

    @Nonnull
    public ItemStack getStack(int slot) {
        return (ItemStack)this.stacks.get(slot);
    }

    public int getStackHash() {
        return this.stackHash;
    }

    public NBTTagCompound getModuleData(ResourceLocation location) {
        NBTTagCompound tag = this.moduleData.get(location);
        if (tag == null) {
            tag = new NBTTagCompound();
            this.moduleData.put(location, tag);
        }
        return tag;
    }

    public void markModuleDataDirty() {
        this.func_70296_d();
        BlockPos pos = this.func_174877_v();
        World world = this.func_145831_w();
        IBlockState state = world.func_180495_p(pos);
        world.func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readDescription(tag);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        this.writeDescription(tag);
        return tag;
    }

    @Override
    protected void writeDescription(NBTTagCompound tag) {
        tag.func_74768_a("type", this.type.ordinal());
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (!stack.func_190926_b()) {
                tag.func_74782_a("stack" + i, (NBTBase)stack.serializeNBT());
                continue;
            }
            tag.func_82580_o("stack" + i);
        }
        if (this.moduleData.isEmpty()) {
            tag.func_82580_o("data");
        } else {
            NBTTagCompound data = tag.func_74775_l("data");
            for (Map.Entry<ResourceLocation, NBTTagCompound> entry : this.moduleData.entrySet()) {
                data.func_74782_a(entry.getKey().toString(), (NBTBase)entry.getValue());
            }
        }
    }

    @Override
    protected void readDescription(NBTTagCompound tag) {
        if (tag.func_74764_b("type") && this.type == null) {
            int meta = tag.func_74762_e("type");
            this.setType(ManipulatorType.VALUES[meta & 1]);
        }
        if (this.type == null) {
            return;
        }
        for (int i = 0; i < this.stacks.size(); ++i) {
            this.stacks.set(i, (Object)(tag.func_74764_b("stack" + i) ? new ItemStack(tag.func_74775_l("stack" + i)) : ItemStack.field_190927_a));
        }
        this.stackHash = Helpers.hashStacks(this.stacks);
        NBTTagCompound data = tag.func_74775_l("data");
        for (String key : data.func_150296_c()) {
            this.moduleData.put(new ResourceLocation(key), data.func_74775_l(key));
        }
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, Vec3d hit) {
        if (player.func_130014_f_().field_72995_K) {
            return true;
        }
        if (this.type == null) {
            int meta = this.func_145832_p();
            this.setType(ManipulatorType.VALUES[meta & 1]);
        }
        ItemStack heldStack = player.func_184586_b(hand);
        AxisAlignedBB[] boxes = this.type.boxesFor(this.getFacing());
        for (int i = 0; i < this.type.size(); ++i) {
            AxisAlignedBB box = boxes[i];
            if (!box.func_72314_b(0.002, 0.002, 0.002).func_72318_a(hit)) continue;
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (heldStack.func_190926_b() && !stack.func_190926_b()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    Vec3d offsetPos = new Vec3d((Vec3i)this.field_174879_c).func_178787_e(new Vec3d(this.getFacing().func_176734_d().func_176730_m()).func_186678_a(0.625));
                    Helpers.spawnItemStack(this.func_145831_w(), offsetPos.field_72450_a, offsetPos.field_72448_b, offsetPos.field_72449_c, stack);
                }
                this.stacks.set(i, (Object)ItemStack.field_190927_a);
                this.stackHash = Helpers.hashStacks(this.stacks);
                this.markForUpdate();
                break;
            }
            if (!stack.func_190926_b() || heldStack.func_190926_b() || !heldStack.hasCapability(Constants.MODULE_HANDLER_CAPABILITY, null)) continue;
            this.stacks.set(i, (Object)heldStack.func_77946_l());
            ((ItemStack)this.stacks.get(i)).func_190920_e(1);
            this.stackHash = Helpers.hashStacks(this.stacks);
            if (!player.field_71075_bZ.field_75098_d) {
                heldStack.func_190917_f(-1);
                if (heldStack.func_190916_E() <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                }
            }
            this.markForUpdate();
            break;
        }
        return true;
    }

    @Override
    public void broken() {
        if (this.stacks == null) {
            return;
        }
        Vec3d offsetPos = new Vec3d((Vec3i)this.field_174879_c).func_178787_e(new Vec3d(this.getFacing().func_176734_d().func_176730_m()).func_186678_a(0.625));
        for (ItemStack stack : this.stacks) {
            if (stack == null) continue;
            Helpers.spawnItemStack(this.func_145831_w(), offsetPos.field_72450_a, offsetPos.field_72448_b, offsetPos.field_72449_c, stack);
        }
        this.stacks.clear();
        this.stackHash = 0;
    }

    public double incrementRotation() {
        long tick = ++this.tick;
        double offset = this.offset;
        if (offset < 0.0) {
            offset = this.offset = Helpers.RANDOM.nextDouble() * (Math.PI * 2);
        }
        return (double)tick / 100.0 + offset;
    }

    public void func_73660_a() {
        this.runner.func_73660_a();
    }

    @Nonnull
    public TaskRunner getRunner() {
        return this.runner;
    }

    @Override
    public void removed() {
        this.runner.reset();
    }

    public void setOwningProfile(GameProfile profile) {
        this.profile = profile;
    }

    @Override
    @Nullable
    public GameProfile getOwningProfile() {
        return this.profile;
    }
}

