/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.client;

import java.nio.FloatBuffer;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class OpenGlHelper
extends net.minecraft.client.renderer.OpenGlHelper {
    private static FboMode mode;
    private static int GL_DRAW_FRAMEBUFFER_BINDING;
    private static final FloatBuffer projection;
    private static final FloatBuffer modelView;

    public static int getCurrentBuffer() {
        OpenGlHelper.setup();
        return GL_DRAW_FRAMEBUFFER_BINDING == -1 ? 0 : GlStateManager.func_187397_v((int)36006);
    }

    public static FloatBuffer getProjectionMatrix() {
        GL11.glGetFloat((int)2983, (FloatBuffer)projection);
        return projection;
    }

    public static FloatBuffer getModelViewMatrix() {
        GL11.glGetFloat((int)2982, (FloatBuffer)modelView);
        return modelView;
    }

    private static void setup() {
        if (mode != null) {
            return;
        }
        ContextCapabilities contextcapabilities = GLContext.getCapabilities();
        if (contextcapabilities.OpenGL30) {
            mode = FboMode.GL3;
            GL_DRAW_FRAMEBUFFER_BINDING = 36006;
        } else if (contextcapabilities.GL_ARB_framebuffer_object) {
            mode = FboMode.ARB;
            GL_DRAW_FRAMEBUFFER_BINDING = 36006;
        } else {
            mode = contextcapabilities.GL_EXT_framebuffer_object ? FboMode.EXT : FboMode.NONE;
        }
    }

    static {
        GL_DRAW_FRAMEBUFFER_BINDING = -1;
        projection = BufferUtils.createFloatBuffer((int)16);
        modelView = BufferUtils.createFloatBuffer((int)16);
    }

    public static enum FboMode {
        NONE,
        GL3,
        ARB,
        EXT;

    }
}

