/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay;

import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import org.apache.commons.lang3.tuple.Pair;
import org.squiddev.plethora.api.Constants;
import org.squiddev.plethora.utils.FakeNetHandler;

public class PlethoraFakePlayer
extends FakePlayer {
    public static final GameProfile PROFILE = new GameProfile(Constants.FAKEPLAYER_UUID, "[plethora]");
    private final WeakReference<Entity> owner;
    private BlockPos digPosition;
    private Block digBlock;
    private int currentDamage = -1;
    private int currentDamageState = -1;

    public PlethoraFakePlayer(WorldServer world, Entity owner, GameProfile profile) {
        super(world, profile != null && profile.isComplete() ? profile : PROFILE);
        this.field_71135_a = new FakeNetHandler(this);
        this.func_70105_a(0.0f, 0.0f);
        if (owner != null) {
            this.func_96094_a(owner.func_70005_c_());
            this.owner = new WeakReference<Entity>(owner);
        } else {
            this.owner = null;
        }
    }

    @Deprecated
    public PlethoraFakePlayer(World world) {
        super((WorldServer)world, PROFILE);
        this.owner = null;
    }

    @Nonnull
    protected HoverEvent func_174823_aP() {
        NBTTagCompound tag = new NBTTagCompound();
        Entity owner = this.getOwner();
        if (owner != null) {
            tag.func_74778_a("id", owner.func_189512_bd());
            tag.func_74778_a("name", owner.func_70005_c_());
            ResourceLocation type = EntityList.func_191301_a((Entity)owner);
            if (type != null) {
                tag.func_74778_a("type", type.toString());
            }
        } else {
            tag.func_74778_a("id", this.func_189512_bd());
            tag.func_74778_a("name", this.func_70005_c_());
        }
        return new HoverEvent(HoverEvent.Action.SHOW_ENTITY, (ITextComponent)new TextComponentString(tag.toString()));
    }

    public Entity getOwner() {
        return this.owner == null ? null : (Entity)this.owner.get();
    }

    public void func_71064_a(StatBase stat, int count) {
        EntityPlayerMP player;
        MinecraftServer server = this.field_70170_p.func_73046_m();
        if (server != null && this.func_146103_bH() != PROFILE && (player = server.func_184103_al().func_177451_a(this.func_110124_au())) != null) {
            player.func_71064_a(stat, count);
        }
    }

    public Vec3d func_174791_d() {
        return new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void func_70105_a(float width, float height) {
        super.func_70105_a(width, height);
    }

    public boolean func_96122_a(EntityPlayer player) {
        return true;
    }

    public float getDefaultEyeHeight() {
        return 0.0f;
    }

    public void func_110145_l(Entity entity) {
    }

    public void func_175141_a(TileEntitySign sign) {
    }

    public boolean func_174814_R() {
        return true;
    }

    public void func_184185_a(@Nonnull SoundEvent soundIn, float volume, float pitch) {
    }

    public void updateCooldown() {
        this.field_184617_aD = 20;
    }

    private void setState(Block block, BlockPos pos) {
        this.field_71134_c.func_180238_e();
        this.field_71134_c.field_73094_o = -1;
        this.digPosition = pos;
        this.digBlock = block;
        this.currentDamage = -1;
        this.currentDamageState = -1;
    }

    public Pair<Boolean, String> dig(BlockPos pos, EnumFacing direction) {
        World world = this.func_130014_f_();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block != this.digBlock || !pos.equals((Object)this.digPosition)) {
            this.setState(block, pos);
        }
        if (!world.func_175623_d(pos) && !state.func_185904_a().func_76224_d()) {
            if (block == Blocks.field_150357_h || state.func_185887_b(world, pos) <= -1.0f) {
                return Pair.of((Object)false, (Object)"Unbreakable block detected");
            }
            PlayerInteractionManager manager = this.field_71134_c;
            for (int i = 0; i < 10; ++i) {
                if (this.currentDamageState == -1) {
                    manager.func_180784_a(pos, direction.func_176734_d());
                    this.currentDamageState = manager.field_73094_o;
                    continue;
                }
                ++this.currentDamage;
                float hardness = state.func_185903_a((EntityPlayer)this, world, pos) * (float)(this.currentDamage + 1);
                int hardnessState = (int)(hardness * 10.0f);
                if (hardnessState != this.currentDamageState) {
                    world.func_175715_c(this.func_145782_y(), pos, hardnessState);
                    this.currentDamageState = hardnessState;
                }
                if (!(hardness >= 1.0f)) continue;
                manager.func_180237_b(pos);
                this.setState(null, null);
                break;
            }
            return Pair.of((Object)true, (Object)"block");
        }
        return Pair.of((Object)false, (Object)"Nothing to dig here");
    }
}

