/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.computer.core.ServerComputer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.gameplay.Plethora;
import org.squiddev.plethora.gameplay.client.gui.GuiKeyboard;
import org.squiddev.plethora.gameplay.client.gui.GuiMinecartComputer;
import org.squiddev.plethora.gameplay.client.gui.GuiNeuralInterface;
import org.squiddev.plethora.gameplay.keyboard.ContainerKeyboard;
import org.squiddev.plethora.gameplay.minecart.ContainerMinecartComputer;
import org.squiddev.plethora.gameplay.minecart.EntityMinecartComputer;
import org.squiddev.plethora.gameplay.neural.ContainerNeuralInterface;
import org.squiddev.plethora.gameplay.neural.NeuralHelpers;

public class GuiHandler
implements IGuiHandler {
    private static final int GUI_NEURAL = 101;
    private static final int GUI_KEYBOARD = 102;
    private static final int GUI_MINECART = 103;
    private static final int GUI_FLAG_PLAYER = 0;
    private static final int GUI_FLAG_ENTITY = 1;

    @SideOnly(value=Side.CLIENT)
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        switch (id) {
            case 101: {
                ContainerNeuralInterface container = GuiHandler.getNeuralContainer(player, world, x, y);
                return container == null ? null : new GuiNeuralInterface(container);
            }
            case 102: {
                ClientComputer computer = (ClientComputer)ComputerCraft.clientComputerRegistry.get(x);
                return computer == null ? null : new GuiKeyboard((IComputer)computer);
            }
            case 103: {
                EntityMinecartComputer minecart;
                ClientComputer computer;
                Entity entity = world.func_73045_a(x);
                if (entity instanceof EntityMinecartComputer && (computer = (minecart = (EntityMinecartComputer)entity).getClientComputer()) != null) {
                    return new GuiMinecartComputer(minecart, computer);
                }
                return null;
            }
        }
        return null;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        switch (id) {
            case 101: {
                return GuiHandler.getNeuralContainer(player, world, x, y);
            }
            case 102: {
                ServerComputer computer = (ServerComputer)ComputerCraft.serverComputerRegistry.get(x);
                return computer == null ? null : new ContainerKeyboard((IComputer)computer);
            }
            case 103: {
                Entity entity = world.func_73045_a(x);
                return entity instanceof EntityMinecartComputer ? new ContainerMinecartComputer((EntityMinecartComputer)entity) : null;
            }
        }
        return null;
    }

    private static EntityLivingBase getEntity(EntityPlayer player, World world, int flag, int id) {
        switch (flag) {
            case 0: {
                return player;
            }
            case 1: {
                Entity entity = world.func_73045_a(id);
                return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
            }
        }
        Plethora.LOG.error("Unknown flag " + flag);
        return null;
    }

    private static ContainerNeuralInterface getNeuralContainer(EntityPlayer player, World world, int flag, int id) {
        EntityLivingBase entity = GuiHandler.getEntity(player, world, flag, id);
        if (entity == null) {
            return null;
        }
        ItemStack stack = NeuralHelpers.getStack(entity);
        if (stack.func_190926_b()) {
            return null;
        }
        return new ContainerNeuralInterface((IInventory)player.field_71071_by, entity, stack);
    }

    public static void openKeyboard(EntityPlayer player, World world, ServerComputer computer) {
        player.openGui((Object)Plethora.instance, 102, world, computer.getInstanceID(), 0, 0);
    }

    public static void openNeuralPlayer(EntityPlayer player, World world) {
        player.openGui((Object)Plethora.instance, 101, world, 0, 0, 0);
    }

    public static void openNeuralEntity(EntityPlayer player, World world, EntityLivingBase entity) {
        player.openGui((Object)Plethora.instance, 101, world, 1, entity.func_145782_y(), 0);
    }

    public static void openMinecart(EntityPlayer player, World world, EntityMinecartComputer computer) {
        player.openGui((Object)Plethora.instance, 103, world, computer.func_145782_y(), 0, 0);
    }
}

