/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core.docdump;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import org.squiddev.plethora.api.method.IMethod;
import org.squiddev.plethora.api.method.ISubTargetedMethod;
import org.squiddev.plethora.api.module.IModuleMethod;
import org.squiddev.plethora.core.docdump.DocumentedItem;

public class DocumentedMethod
extends DocumentedItem<IMethod<?>> {
    private static final Pattern docString = Pattern.compile("^function(\\([^)]*\\).*?)--(.*)$");
    private final String args;
    private final Class<?> target;
    private final Class<?> subtarget;
    private final List<String> modules;

    public DocumentedMethod(@Nonnull Class<?> target, @Nonnull IMethod<?> method) {
        super(method, method.getId(), method.getName(), DocumentedMethod.getDescription(method.getDocString()));
        this.args = DocumentedMethod.getArgs(method.getDocString());
        this.target = target;
        Class<Object> clazz = this.subtarget = method instanceof ISubTargetedMethod ? ((ISubTargetedMethod)method).getSubTarget() : null;
        if (method instanceof IModuleMethod) {
            Collection<ResourceLocation> modules = ((IModuleMethod)method).getModules();
            ArrayList<String> moduleList = new ArrayList<String>(modules.size());
            for (ResourceLocation module : modules) {
                moduleList.add(module.toString());
            }
            moduleList.sort(Comparator.naturalOrder());
            this.modules = Collections.unmodifiableList(moduleList);
        } else {
            this.modules = Collections.emptyList();
        }
    }

    @Nonnull
    public String getArgs() {
        return this.args == null ? "()" : this.args;
    }

    @Nonnull
    public Class<?> getTarget() {
        return this.target;
    }

    @Nullable
    public Class<?> getSubtarget() {
        return this.subtarget;
    }

    @Nonnull
    public List<String> getModules() {
        return this.modules;
    }

    private static String getArgs(String doc) {
        if (doc == null) {
            return null;
        }
        Matcher match = docString.matcher(doc);
        return match.find() ? match.group(1).trim() : null;
    }

    private static String getDescription(String doc) {
        if (doc == null) {
            return null;
        }
        Matcher match = docString.matcher(doc);
        return match.find() ? match.group(2).trim() : null;
    }
}

