/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.TypedLuaObject;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.api.reference.IReference;
import org.squiddev.plethora.api.reference.Reference;
import org.squiddev.plethora.core.ConverterRegistry;
import org.squiddev.plethora.core.MethodRegistry;
import org.squiddev.plethora.core.MethodWrapperLuaObject;
import org.squiddev.plethora.core.PartialContext;
import org.squiddev.plethora.core.UnbakedContext;

public final class Context<T>
extends PartialContext<T>
implements IContext<T> {
    private final UnbakedContext<T> parent;

    Context(@Nonnull UnbakedContext<T> parent, @Nonnull Object[] context, @Nonnull IModuleContainer modules) {
        super(parent.target, parent.keys, context, parent.handler, modules);
        this.parent = parent;
    }

    @Override
    Context<?> withIndex(int index) {
        return index == this.target ? this : new Context(this.parent.withIndex(index), this.values, this.modules);
    }

    @Override
    @Nonnull
    public <U> Context<U> makeChild(U target, @Nonnull IReference<U> targetReference) {
        Objects.requireNonNull(target, "target cannot be null");
        Objects.requireNonNull(targetReference, "targetReference cannot be null");
        ArrayList<String> keys = new ArrayList<String>(this.keys.length + 1);
        ArrayList<Object> references = new ArrayList<Object>(this.parent.references.length + 1);
        ArrayList<Object> values = new ArrayList<Object>(this.values.length + 1);
        Collections.addAll(keys, this.keys);
        Collections.addAll(references, this.parent.references);
        Collections.addAll(values, this.values);
        for (int i = keys.size() - 1; i >= 0; --i) {
            if (!"target".equals(keys.get(i))) continue;
            keys.set(i, "generic");
        }
        keys.add("target");
        references.add(targetReference);
        values.add(target);
        ConverterRegistry.instance.extendConverted(keys, values, references, this.values.length);
        return new Context(new UnbakedContext(this.keys.length, keys.toArray(new String[0]), references.toArray(), this.handler, this.parent.modules, this.parent.executor), values.toArray(), this.modules);
    }

    @Override
    @Nonnull
    public <U extends IReference<U>> Context<U> makeChild(@Nonnull U target) {
        return this.makeChild((Object)target, (IReference)target);
    }

    @Override
    @Nonnull
    public <U> Context<U> makeChildId(@Nonnull U target) {
        return this.makeChild((Object)target, (IReference)Reference.id(target));
    }

    @Override
    @Nonnull
    public UnbakedContext<T> unbake() {
        return this.parent;
    }

    @Override
    @Nonnull
    public TypedLuaObject<T> getObject() {
        return new MethodWrapperLuaObject(MethodRegistry.instance.getMethodsPaired(this));
    }
}

