/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.api.reference;

import dan200.computercraft.api.lua.LuaException;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.squiddev.plethora.api.reference.ConstantReference;

public class TileReference<T extends TileEntity>
implements ConstantReference<T> {
    private final WeakReference<T> tile;
    private final BlockPos pos;
    private final World world;
    private boolean valid = true;

    TileReference(@Nonnull T tile) {
        this.tile = new WeakReference<T>(tile);
        this.pos = tile.func_174877_v();
        this.world = tile.func_145831_w();
    }

    @Override
    @Nonnull
    public T get() throws LuaException {
        TileEntity value = (TileEntity)this.tile.get();
        if (value == null || this.world.func_175625_s(this.pos) != value) {
            this.valid = false;
            throw new LuaException("The block is no longer there");
        }
        this.valid = true;
        return (T)value;
    }

    @Override
    @Nonnull
    public T safeGet() throws LuaException {
        if (!this.valid) {
            throw new LuaException("The block is no longer there");
        }
        TileEntity value = (TileEntity)this.tile.get();
        if (value == null) {
            throw new LuaException("The block is no longer there");
        }
        if (value.func_145837_r()) {
            throw new LuaException("The block is no longer there");
        }
        return (T)value;
    }
}

