/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.packets;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public class PacketCompleteChannelsUpdate
implements BasePacket {
    private List<Channel> channels;

    public PacketCompleteChannelsUpdate(boolean server) {
        if (!server) {
            throw new IllegalStateException();
        }
        List[] lists = new List[EnumChannelType.values().length];
        int index = 0;
        int size = 0;
        for (EnumChannelType enumChannelType : EnumChannelType.values()) {
            lists[index] = TesseractChannelManager.SERVER.getChannels(enumChannelType);
            size += lists[index].size();
            ++index;
        }
        this.channels = new ArrayList<Channel>(size);
        for (List list : lists) {
            this.channels.addAll(list);
        }
    }

    public PacketCompleteChannelsUpdate() {
    }

    public void write(PacketBuffer buffer) {
        NBTTagCompound compound = new NBTTagCompound();
        Iterator<Channel> iterator = this.channels.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            compound.func_74782_a(Integer.toString(index), (NBTBase)iterator.next().writeClientChannel());
            ++index;
        }
        buffer.func_150786_a(compound);
    }

    public void read(PacketBuffer buffer) {
        NBTTagCompound compound = null;
        try {
            compound = buffer.func_150793_b();
        }
        catch (IOException ignore) {
            return;
        }
        this.channels = new ArrayList<Channel>();
        for (String key : compound.func_150296_c()) {
            this.channels.add(Channel.readClientChannel(compound.func_74775_l(key)));
        }
    }

    public boolean verify(PacketContext context) {
        return this.channels != null;
    }

    public void handle(PacketContext buffer) {
        TesseractChannelManager.CLIENT.clear();
        HashSet types = new HashSet(3);
        this.channels.forEach(channel -> {
            TesseractChannelManager.CLIENT.addChannel((Channel)channel);
            types.add(channel.type);
        });
        types.forEach(type -> TesseractChannelManager.CLIENT.sortChannels(ClientUtils.getPlayer(), (EnumChannelType)((Object)type)));
    }
}

