/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.manager.Channel;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class ChannelList {
    private int channelId = 0;
    public final EnumChannelType type;
    private final ArrayList<Channel> channels = new ArrayList();
    private final ArrayList<Channel> publicChannels = new ArrayList();
    private final HashMap<Integer, Channel> channelsById = new HashMap();
    private final HashMap<UUID, List<Channel>> channelsByCreator = new HashMap();
    private final List<Integer> removedIds = new ArrayList<Integer>();

    public ChannelList(EnumChannelType type) {
        this.type = type;
    }

    public Channel add(UUID creator, boolean isPrivate, String name) {
        Channel channel = new Channel(this.channelId++, this.type, creator, isPrivate, name);
        this.add(channel);
        return channel;
    }

    void add(Channel channel) {
        this.channels.add(channel);
        if (!channel.isPrivate) {
            this.publicChannels.add(channel);
        }
        this.channelsById.put(channel.id, channel);
        this.channelsByCreator.putIfAbsent(channel.creator, new ArrayList());
        this.channelsByCreator.get(channel.creator).add(channel);
    }

    public void remove(int id) {
        this.remove(this.getById(id));
    }

    public void remove(Channel channel) {
        if (channel == null) {
            return;
        }
        this.channels.remove(channel);
        this.publicChannels.remove(channel);
        this.channelsById.remove(channel.id);
        this.channelsByCreator.get(channel.creator).remove(channel);
        channel.delete();
        this.removedIds.add(channel.id);
    }

    public List<Channel> sortForPlayer(EntityPlayer player) {
        UUID uuid = player.func_110124_au();
        this.channels.removeIf(channel -> channel.isPrivate && !channel.creator.equals(uuid));
        this.channels.sort((a, b) -> {
            boolean bUuid;
            boolean aUuid = a.creator.equals(uuid);
            if (aUuid ^ (bUuid = b.creator.equals(uuid))) {
                return aUuid ? -1 : 1;
            }
            return a.name.compareTo(b.name);
        });
        return this.channels;
    }

    public Channel getById(int id) {
        return this.channelsById.get(id);
    }

    public List<Channel> getChannels() {
        return Collections.unmodifiableList(this.channels);
    }

    public List<Channel> getChannelsCreatedBy(UUID creator) {
        return this.channelsByCreator.getOrDefault(creator, Collections.emptyList());
    }

    public void write(Path folder) {
        Path file;
        for (Channel channel : this.channels) {
            file = folder.resolve("channel" + channel.id + ".nbt");
            try {
                DataOutputStream output = new DataOutputStream(Files.newOutputStream(file, new OpenOption[0]));
                Throwable throwable = null;
                try {
                    CompressedStreamTools.func_74800_a((NBTTagCompound)channel.write(), (DataOutput)output);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (output == null) continue;
                    if (throwable != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    output.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Iterator<Object> iterator = this.removedIds.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            file = folder.resolve("channel" + id + ".nbt");
            try {
                Files.deleteIfExists(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.removedIds.clear();
    }

    public void read(Path folder) {
        this.channelId = 0;
        if (!Files.exists(folder, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> files = Files.list(folder);){
            files.forEach(file -> {
                String name = file.getFileName().toString();
                if (name.startsWith("channel") && name.endsWith(".nbt")) {
                    try {
                        NBTTagCompound compound;
                        int id = Integer.parseInt(name.substring("channel".length(), name.length() - ".nbt".length()));
                        try (DataInputStream input = new DataInputStream(Files.newInputStream(file, new OpenOption[0]));){
                            compound = CompressedStreamTools.func_74794_a((DataInputStream)input);
                        }
                        Channel channel = new Channel(id, this.type, compound);
                        if (channel.id >= this.channelId) {
                            this.channelId = channel.id + 1;
                        }
                        this.add(channel);
                    }
                    catch (Exception e) {
                        Tesseract.LOGGER.error("Failed to read channel from file '" + file + "'!", (Throwable)e);
                    }
                }
            });
        }
        catch (IOException e) {
            Tesseract.LOGGER.error("Failed to list files from '" + folder + "'!", (Throwable)e);
        }
    }

    public void clear() {
        this.channels.clear();
        this.publicChannels.clear();
        this.channelsById.clear();
        this.channelsByCreator.clear();
    }
}

