/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.integration;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import java.util.function.Function;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class TesseractTheOneProbePlugin {
    public static void interModEnqueue() {
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"com.supermartijn642.tesseract.integration.TesseractTheOneProbePlugin$ProbeInfoProvider");
    }

    public static class ProbeInfoProvider
    implements IProbeInfoProvider,
    IProbeConfigProvider,
    Function<ITheOneProbe, Void> {
        @Override
        public Void apply(ITheOneProbe theOneProbe) {
            theOneProbe.registerProvider((IProbeInfoProvider)this);
            theOneProbe.registerProbeConfigProvider((IProbeConfigProvider)this);
            return null;
        }

        public String getID() {
            return "tesseract";
        }

        public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, EntityPlayer player, World level, IBlockState state, IProbeHitData probeHitData) {
            TileEntity entity = level.func_175625_s(probeHitData.getPos());
            if (entity instanceof TesseractBlockEntity) {
                TesseractBlockEntity tesseract = (TesseractBlockEntity)entity;
                probeInfo.text(TextComponents.translation((String)"tesseract.tesseract.highlight.channels").format());
                probeInfo.text(ProbeInfoProvider.formatChannelInfo(EnumChannelType.ITEMS, tesseract.getChannelId(EnumChannelType.ITEMS)));
                probeInfo.text(ProbeInfoProvider.formatChannelInfo(EnumChannelType.ENERGY, tesseract.getChannelId(EnumChannelType.ENERGY)));
                probeInfo.text(ProbeInfoProvider.formatChannelInfo(EnumChannelType.FLUID, tesseract.getChannelId(EnumChannelType.FLUID)));
                if (tesseract.isBlockedByRedstone()) {
                    probeInfo.text(TextStyleClass.ERROR + TextComponents.translation((String)"tesseract.tesseract.highlight.redstone_blocked").format());
                }
            }
        }

        private static String formatChannelInfo(EnumChannelType type, int channelId) {
            Channel channel = TesseractChannelManager.CLIENT.getChannelById(type, channelId);
            String channelType = TextStyleClass.WARNING + TextComponents.fromTextComponent((ITextComponent)type.getTranslation()).format();
            String separator = TextStyleClass.INFO + TextComponents.translation((String)"tesseract.tesseract.highlight.channel_info.separator").format();
            String channelName = channel == null ? TextStyleClass.LABEL + TextComponents.translation((String)"tesseract.tesseract.highlight.channel_info.inactive").format() : TextStyleClass.INFO + channel.name;
            return TextComponents.translation((String)"tesseract.tesseract.highlight.channel_info", (Object[])new Object[]{channelType, separator, channelName}).format();
        }

        public void getProbeConfig(IProbeConfig probeConfig, EntityPlayer player, World level, Entity entity, IProbeHitEntityData probeHitEntityData) {
        }

        public void getProbeConfig(IProbeConfig probeConfig, EntityPlayer player, World level, IBlockState state, IProbeHitData probeHitData) {
            if (state.func_177230_c() == Tesseract.tesseract) {
                probeConfig.setRFMode(0);
                probeConfig.setTankMode(0);
            }
        }
    }
}

