/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.mixinbooter.decorator;

import com.google.common.base.Strings;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.MixinContextQuery;

public final class FMLContextQuery
extends MixinContextQuery {
    private final ASMDataTable asmDataTable;

    public FMLContextQuery(ASMDataTable asmDataTable) {
        this.asmDataTable = asmDataTable;
    }

    private static String getResourceName(IMixinConfig config) {
        String filePath;
        String[] parts;
        String resource = Launch.classLoader.getResource(config.getName()).getPath();
        if (resource.contains("!/") && (parts = (filePath = resource.split("!/")[0]).split("/")).length != 0) {
            return parts[parts.length - 1];
        }
        return null;
    }

    @Override
    public String getOwner(IMixinConfig config) {
        if (this.asmDataTable == null) {
            return this.getSanitizedModIdFromResource(config);
        }
        return this.getCandidates(config).stream().map(ModCandidate::getContainedMods).flatMap(Collection::stream).map(ModContainer::getModId).filter(modId -> !Strings.isNullOrEmpty((String)modId)).findFirst().orElseGet(() -> this.getSanitizedModIdFromResource(config));
    }

    @Override
    public String getLocation(IMixinConfig config) {
        if (this.asmDataTable == null) {
            return this.getSanitizedModIdFromResource(config);
        }
        return this.getCandidates(config).stream().map(ModCandidate::getClassPathRoot).map(File::getName).findFirst().orElse(null);
    }

    private Set<ModCandidate> getCandidates(IMixinConfig config) {
        String pkg = config.getMixinPackage();
        pkg = pkg.charAt(pkg.length() - 1) == '.' ? pkg.substring(0, pkg.length() - 1) : pkg;
        return this.asmDataTable.getCandidatesFor(pkg);
    }

    private String getSanitizedModIdFromResource(IMixinConfig config) {
        String baseModId = FMLContextQuery.getResourceName(config);
        if (baseModId == null) {
            return null;
        }
        if (baseModId.endsWith(".jar") || baseModId.endsWith(".zip")) {
            baseModId = baseModId.substring(0, baseModId.length() - 4);
        }
        baseModId = baseModId.replaceAll("1\\.12(\\.2)?", "");
        StringBuilder sanitizedModId = new StringBuilder();
        for (int i = 0; i < baseModId.length(); ++i) {
            char character = baseModId.charAt(i);
            if (character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z' || i > 0 && character >= '0' && character <= '9') {
                sanitizedModId.append(character);
                continue;
            }
            sanitizedModId.append('_');
        }
        return sanitizedModId.toString();
    }
}

