/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.mixinbooter;

import com.google.common.eventbus.EventBus;
import com.llamalad7.mixinextras.MixinExtrasBootstrap;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.InvalidVersionSpecificationException;
import net.minecraftforge.fml.common.versioning.VersionRange;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.GlobalProperties;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.Mixins;
import zone.rong.mixinbooter.IEarlyMixinLoader;
import zone.rong.mixinbooter.IMixinConfigHijacker;
import zone.rong.mixinbooter.fix.MixinFixer;

@IFMLLoadingPlugin.Name(value="MixinBooter")
@IFMLLoadingPlugin.SortingIndex(value=-2147483647)
public final class MixinBooterPlugin
implements IFMLLoadingPlugin {
    public static final Logger LOGGER = LogManager.getLogger((String)"MixinBooter");

    static String getMinecraftVersion() {
        return (String)FMLInjectionData.data()[4];
    }

    public MixinBooterPlugin() {
        this.addTransformationExclusions();
        this.initialize();
        LOGGER.info("Initializing Mixins...");
        MixinBootstrap.init();
        Mixins.addConfiguration("mixin.mixinbooter.init.json");
        LOGGER.info("Initializing MixinExtras...");
        MixinExtrasBootstrap.init();
        MixinFixer.patchAncientModMixinsLoadingMethod();
    }

    public String[] getASMTransformerClass() {
        return new String[0];
    }

    public String getModContainerClass() {
        return "zone.rong.mixinbooter.MixinBooterPlugin$Container";
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        Object coremodList = data.get("coremodList");
        if (coremodList instanceof List) {
            Field fmlPluginWrapper$coreModInstance = null;
            HashMap<String, IMixinConfigHijacker> hijackers = new HashMap<String, IMixinConfigHijacker>();
            LinkedHashSet<IEarlyMixinLoader> queuedLoaders = new LinkedHashSet<IEarlyMixinLoader>();
            for (Object coremod : (List)coremodList) {
                try {
                    Object theMod;
                    if (fmlPluginWrapper$coreModInstance == null) {
                        fmlPluginWrapper$coreModInstance = coremod.getClass().getField("coreModInstance");
                        fmlPluginWrapper$coreModInstance.setAccessible(true);
                    }
                    if ((theMod = fmlPluginWrapper$coreModInstance.get(coremod)) instanceof IMixinConfigHijacker) {
                        IMixinConfigHijacker interceptor = (IMixinConfigHijacker)theMod;
                        for (String hijacked : interceptor.getHijackedMixinConfigs()) {
                            hijackers.put(hijacked, interceptor);
                        }
                    }
                    if (theMod instanceof IEarlyMixinLoader) {
                        IEarlyMixinLoader loader = (IEarlyMixinLoader)theMod;
                        LOGGER.info("Grabbing {} for its mixins.", loader.getClass());
                        queuedLoaders.add(loader);
                        continue;
                    }
                    if (!"org.spongepowered.mod.SpongeCoremod".equals(theMod.getClass().getName())) continue;
                    Launch.classLoader.registerTransformer("zone.rong.mixinbooter.fix.spongeforge.SpongeForgeFixer");
                }
                catch (Throwable t) {
                    LOGGER.error("Unexpected error", t);
                }
            }
            for (IEarlyMixinLoader queuedLoader : queuedLoaders) {
                for (String mixinConfig : queuedLoader.getMixinConfigs()) {
                    if (!queuedLoader.shouldMixinConfigQueue(mixinConfig)) continue;
                    IMixinConfigHijacker hijacker = (IMixinConfigHijacker)hijackers.get(mixinConfig);
                    if (hijacker != null) {
                        LOGGER.info("Mixin configuration [{}] intercepted by [{}].", (Object)mixinConfig, (Object)hijacker.getClass().getName());
                        continue;
                    }
                    LOGGER.info("Adding {} mixin configuration.", (Object)mixinConfig);
                    Mixins.addConfiguration(mixinConfig);
                    queuedLoader.onMixinConfigQueued(mixinConfig);
                }
            }
        }
    }

    public String getAccessTransformerClass() {
        return null;
    }

    private void addTransformationExclusions() {
        Launch.classLoader.addTransformerExclusion("scala.");
        Launch.classLoader.addTransformerExclusion("com.llamalad7.mixinextras.");
    }

    private void initialize() {
        GlobalProperties.put(GlobalProperties.Keys.CLEANROOM_DISABLE_MIXIN_CONFIGS, new HashSet());
    }

    public static class Container
    extends DummyModContainer {
        public Container() {
            super(new ModMetadata());
            LOGGER.info("Initializing MixinBooter's Mod Container.");
            ModMetadata meta = this.getMetadata();
            meta.modId = "mixinbooter";
            meta.name = "MixinBooter";
            meta.description = "A mod that provides the Sponge Mixin library, a standard API for mods to load mixins targeting Minecraft and other mods, and associated useful utilities on 1.8 - 1.12.2";
            meta.credits = "Thanks to LegacyModdingMC + Fabric for providing the initial mixin fork.";
            meta.version = "9.3";
            meta.logoFile = "/icon.png";
            meta.authorList.add("Rongmario");
        }

        public boolean registerBus(EventBus bus, LoadController controller) {
            bus.register((Object)this);
            return true;
        }

        public Set<ArtifactVersion> getRequirements() {
            try {
                if ("1.12.2".equals(MixinBooterPlugin.getMinecraftVersion())) {
                    try {
                        return Collections.singleton(new SpongeForgeArtifactVersion());
                    }
                    catch (InvalidVersionSpecificationException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return Collections.emptySet();
        }

        private static class SpongeForgeArtifactVersion
        extends DefaultArtifactVersion {
            public SpongeForgeArtifactVersion() throws InvalidVersionSpecificationException {
                super("spongeforge", VersionRange.createFromVersionSpec((String)"[7.4.8,)"));
            }

            public boolean containsVersion(ArtifactVersion source) {
                if (source == this) {
                    return true;
                }
                String version = source.getVersionString();
                String[] hyphenSplits = version.split("-");
                if (hyphenSplits.length > 1) {
                    version = hyphenSplits[hyphenSplits.length - 1].startsWith("RC") ? hyphenSplits[hyphenSplits.length - 2] : hyphenSplits[hyphenSplits.length - 1];
                }
                source = new DefaultArtifactVersion(source.getLabel(), version);
                return super.containsVersion(source);
            }
        }
    }
}

