/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.utilities;

import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;

@ParametersAreNonnullByDefault
public class PotionUtils {
    private PotionUtils() {
    }

    public static boolean arePotionsSame(ItemStack first, ItemStack second) {
        if (first.func_77973_b() != second.func_77973_b()) {
            return false;
        }
        if (!first.func_77942_o() || !second.func_77942_o()) {
            return false;
        }
        return PotionUtils.arePotionsSame(first.func_77978_p(), second.func_77978_p());
    }

    public static boolean arePotionsSame(ItemStack item, PotionType potion) {
        if (!item.func_77942_o()) {
            return false;
        }
        return PotionUtils.arePotionsSame(item.func_77978_p(), potion);
    }

    public static boolean arePotionsSame(ItemStack item, Potion potion) {
        if (!item.func_77942_o()) {
            return false;
        }
        return PotionUtils.arePotionsSame(item.func_77978_p(), potion);
    }

    public static boolean arePotionsSame(NBTTagCompound first, NBTTagCompound second) {
        if (!first.func_74764_b("Potion") || !second.func_74764_b("Potion")) {
            return false;
        }
        return PotionType.func_185168_a((String)first.func_74779_i("Potion")) == PotionType.func_185168_a((String)second.func_74779_i("Potion"));
    }

    public static boolean arePotionsSame(NBTTagCompound item, PotionType potion) {
        if (!item.func_74764_b("Potion")) {
            return false;
        }
        return PotionType.func_185168_a((String)item.func_74779_i("Potion")) == potion;
    }

    public static boolean arePotionsSame(NBTTagCompound item, Potion potion) {
        if (!item.func_74764_b("Potion")) {
            return false;
        }
        List itemPotions = net.minecraft.potion.PotionUtils.func_185185_a((NBTTagCompound)item);
        if (itemPotions.size() != 1) {
            return false;
        }
        return ((PotionEffect)itemPotions.get(0)).func_188419_a() == potion;
    }

    public static boolean isPotionAnyOf(ItemStack item, Potion ... potions) {
        if (!item.func_77942_o()) {
            return false;
        }
        return PotionUtils.isPotionAnyOf(item.func_77978_p(), potions);
    }

    public static boolean isPotionAnyOf(NBTTagCompound item, Potion ... potions) {
        if (!item.func_74764_b("Potion")) {
            return false;
        }
        List itemPotions = net.minecraft.potion.PotionUtils.func_185185_a((NBTTagCompound)item);
        if (itemPotions.size() != 1) {
            return false;
        }
        Potion itemPotion = ((PotionEffect)itemPotions.get(0)).func_188419_a();
        return Arrays.asList(potions).contains(itemPotion);
    }
}

