/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.proxy;

import com.gildedgames.the_aether.api.freezables.AetherFreezableFuel;
import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.block.decorative.BlockPackedPaper;
import com.github.sokyranthedragon.mia.capabilities.MusicPlayerCapabilityProvider;
import com.github.sokyranthedragon.mia.config.GenericAdditionsConfig;
import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.core.MiaBlocks;
import com.github.sokyranthedragon.mia.core.MiaItems;
import com.github.sokyranthedragon.mia.events.Size_BaseEvents;
import com.github.sokyranthedragon.mia.events.Size_ExtendedEvents;
import com.github.sokyranthedragon.mia.events.Size_ItemEvents;
import com.github.sokyranthedragon.mia.events.WorldEvents;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.base.LootTableIntegrator;
import com.github.sokyranthedragon.mia.integrations.base.ModIntegrator;
import com.github.sokyranthedragon.mia.integrations.chisel.Chisel;
import com.github.sokyranthedragon.mia.integrations.harvestcraft.CraftTweakerHarvestcraftIntegration;
import com.github.sokyranthedragon.mia.network.MessageExtendedReachAttack;
import com.github.sokyranthedragon.mia.network.MessageSyncMusicPlayer;
import com.github.sokyranthedragon.mia.utilities.size.SizeOreDictionaryUtils;
import com.github.sokyranthedragon.mia.utilities.size.SizeUtils;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.aspects.AspectRegistryEvent;

public class CommonProxy {
    protected static ModIntegrator modIntegrator;
    protected static LootTableIntegrator lootTableIntegrator;

    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        boolean bl = SizeUtils.isSizeComponentEnabled = GenericAdditionsConfig.enableSizeComponent && ModIds.ARTEMISLIB.isLoaded;
        if (SizeUtils.isSizeComponentEnabled) {
            SizeOreDictionaryUtils.setupOreDictUtils();
            MinecraftForge.EVENT_BUS.register(Size_BaseEvents.class);
            MinecraftForge.EVENT_BUS.register(Size_ExtendedEvents.class);
            MinecraftForge.EVENT_BUS.register(Size_ItemEvents.class);
        }
        if (GenericAdditionsConfig.enableSizeComponent && !ModIds.ARTEMISLIB.isLoaded) {
            Mia.LOGGER.warn("Size component is enabled, but ArtemisLib is not installed! It won't work!");
        }
        if (GenericAdditionsConfig.enableEvtp && GenericAdditionsConfig.evtp.deadFlowerEnabled) {
            MinecraftForge.TERRAIN_GEN_BUS.register(WorldEvents.class);
        }
        MusicPlayerCapabilityProvider.register();
        modIntegrator = new ModIntegrator();
        modIntegrator.registerMods();
        lootTableIntegrator = new LootTableIntegrator();
        lootTableIntegrator.registerLootTableIntegration(modIntegrator, event.getSide());
        modIntegrator.preInit(event);
    }

    public void init(FMLInitializationEvent event) {
        Mia.network = NetworkRegistry.INSTANCE.newSimpleChannel("mia_NETWORK");
        Mia.network.registerMessage(MessageSyncMusicPlayer.Handler.class, MessageSyncMusicPlayer.class, 0, Side.SERVER);
        Mia.network.registerMessage(MessageExtendedReachAttack.Handler.class, MessageExtendedReachAttack.class, 1, Side.SERVER);
        if (!MiaConfig.disableOreDict) {
            OreDictionary.registerOre((String)"buttonWood", (Block)Blocks.field_150471_bO);
            OreDictionary.registerOre((String)"trapdoorWood", (Block)Blocks.field_150415_aT);
            OreDictionary.registerOre((String)"listAllsugar", (Item)Items.field_151102_aT);
            OreDictionary.registerOre((String)"listAllmilk", (Item)Items.field_151117_aB);
        }
        if (GenericAdditionsConfig.enableEvtp) {
            if (GenericAdditionsConfig.evtp.deadFlowerEnabled) {
                assert (MiaBlocks.flowerDead != null);
                OreDictionary.registerOre((String)"dyeBlack", (Block)MiaBlocks.flowerDead);
            }
            if (GenericAdditionsConfig.evtp.packedPaperEnabled) {
                assert (MiaBlocks.packedPaper != null);
                OreDictionary.registerOre((String)"blockPaper", (ItemStack)new ItemStack(MiaBlocks.packedPaper, 1, Short.MAX_VALUE));
                if (ModIds.CHISEL.isLoaded) {
                    for (int meta = 0; meta <= ((BlockPackedPaper)MiaBlocks.packedPaper).getMaxMeta(); ++meta) {
                        Chisel.sendChiselMessage("block_paper", MiaBlocks.packedPaper, meta);
                    }
                }
            }
        }
        modIntegrator.registerDispenserBehaviors(event.getSide());
        modIntegrator.init(event);
        if (ModIds.HARVESTCRAFT.isLoaded && ModIds.CRAFT_TWEAKER.isLoaded) {
            CraftTweakerHarvestcraftIntegration.applyRemovals();
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        modIntegrator.postInit(event);
    }

    public void loadCompleted(FMLLoadCompleteEvent event) {
        modIntegrator.loadCompleted(event);
        modIntegrator = null;
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        MiaBlocks.initMiaBlocks();
        modIntegrator.registerBlocks(event, this.getSide());
        MiaBlocks.registerMiaBlocks(event);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        MiaItems.registerMiaItems(event);
        MiaBlocks.registerMiaItemblocks(event);
        modIntegrator.registerItems(event, this.getSide());
    }

    @SubscribeEvent
    public void lootTableLoad(LootTableLoadEvent event) {
        lootTableIntegrator.lootTableLoad(event);
    }

    @SubscribeEvent
    @Optional.Method(modid="thaumcraft")
    public void aspectRegistrationEvent(AspectRegistryEvent event) {
        modIntegrator.registerAspects(event, this.getSide());
    }

    @SubscribeEvent
    @Optional.Method(modid="aether_legacy")
    public void registerFreezableFuel(RegistryEvent.Register<AetherFreezableFuel> event) {
        modIntegrator.registerFreezableFuel(event, this.getSide());
    }

    protected Side getSide() {
        return Side.SERVER;
    }
}

