/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.proxy;

import com.artemis.artemislib.compatibilities.sizeCap.ISizeCap;
import com.artemis.artemislib.compatibilities.sizeCap.SizeCapPro;
import com.github.sokyranthedragon.mia.client.input.MiaKeyBindings;
import com.github.sokyranthedragon.mia.config.GenericAdditionsConfig;
import com.github.sokyranthedragon.mia.core.MiaBlocks;
import com.github.sokyranthedragon.mia.core.MiaItems;
import com.github.sokyranthedragon.mia.proxy.CommonProxy;
import com.github.sokyranthedragon.mia.utilities.size.SizeUtils;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="mia")
public class ClientProxy
extends CommonProxy {
    private static boolean renderingStarted = false;
    private static boolean renderingSpecialStarted = false;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerRenders(ModelRegistryEvent event) {
        MiaItems.registerMiaItemRenderers();
        MiaBlocks.registerMiaItemblockRenderers();
        modIntegrator.registerRenders(event);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        MiaKeyBindings.register();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onEntityRenderPre(RenderLivingEvent.Pre<?> event) {
        ISizeCap cap;
        if (!SizeUtils.isSizeComponentEnabled) {
            return;
        }
        EntityLivingBase entity = event.getEntity();
        if ((GenericAdditionsConfig.sizeModule.fixRendering || GenericAdditionsConfig.sizeModule.fixInventoryRendering) && entity.hasCapability(SizeCapPro.sizeCapability, null) && (cap = (ISizeCap)entity.getCapability(SizeCapPro.sizeCapability, null)).getTrans()) {
            float scale = entity.field_70131_O / cap.getDefaultHeight();
            boolean resizeInventoryPlayer = false;
            if (entity instanceof EntityPlayerSP && scale != 1.0f) {
                for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                    if (!element.getClassName().equals(GuiInventory.class.getName())) continue;
                    resizeInventoryPlayer = true;
                    break;
                }
            }
            if (GenericAdditionsConfig.sizeModule.fixRendering && scale < 0.4f || GenericAdditionsConfig.sizeModule.fixInventoryRendering && resizeInventoryPlayer) {
                renderingStarted = true;
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)event.getX(), (double)event.getY(), (double)event.getZ());
                if (resizeInventoryPlayer) {
                    GlStateManager.func_179152_a((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
                }
                if (GenericAdditionsConfig.sizeModule.fixRendering && scale < 0.4f) {
                    GlStateManager.func_179152_a((float)(scale * 2.5f), (float)1.0f, (float)(scale * 2.5f));
                }
                GlStateManager.func_179137_b((double)(-event.getX()), (double)(-event.getY()), (double)(-event.getZ()));
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onLivingRenderPost(RenderLivingEvent.Post<?> event) {
        if (renderingStarted) {
            renderingStarted = false;
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onLivingRenderSpecialPre(RenderLivingEvent.Specials.Pre<?> event) {
        ISizeCap cap;
        if (!SizeUtils.isSizeComponentEnabled) {
            return;
        }
        EntityLivingBase entity = event.getEntity();
        if (entity.hasCapability(SizeCapPro.sizeCapability, null) && (cap = (ISizeCap)entity.getCapability(SizeCapPro.sizeCapability, null)).getTrans()) {
            renderingSpecialStarted = true;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)(cap.getDefaultHeight() - entity.field_70131_O), (float)0.0f);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onLivingRenderSpecialPre(RenderLivingEvent.Specials.Post<?> event) {
        if (renderingSpecialStarted) {
            renderingSpecialStarted = false;
            GlStateManager.func_179121_F();
        }
    }

    @Override
    protected Side getSide() {
        return Side.CLIENT;
    }
}

