/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.potions;

import com.github.sokyranthedragon.mia.integrations.thermalexpansion.ThermalExpansion;
import com.github.sokyranthedragon.mia.potions.GrowthPotion;
import com.github.sokyranthedragon.mia.potions.GrowthVenom;
import com.github.sokyranthedragon.mia.potions.ShrinkingPotion;
import com.github.sokyranthedragon.mia.potions.ShrinkingVenom;
import com.github.sokyranthedragon.mia.potions.SizeStabilizationPotion;
import com.github.sokyranthedragon.mia.utilities.PotionUtils;
import com.github.sokyranthedragon.mia.utilities.size.SizeUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="mia")
public class ModPotions {
    public static final Potion shrinkingPotion = new ShrinkingPotion();
    public static final Potion growthPotion = new GrowthPotion();
    public static final Potion shrinkingVenom = new ShrinkingVenom();
    public static final Potion growthVenom = new GrowthVenom();
    public static final Potion sizeStabilizationPotion = new SizeStabilizationPotion();

    @SubscribeEvent
    public static void registerPotions(RegistryEvent.Register<Potion> event) {
        if (!SizeUtils.isSizeComponentEnabled) {
            return;
        }
        event.getRegistry().register((IForgeRegistryEntry)shrinkingPotion);
        event.getRegistry().register((IForgeRegistryEntry)growthPotion);
        event.getRegistry().register((IForgeRegistryEntry)shrinkingVenom);
        event.getRegistry().register((IForgeRegistryEntry)growthVenom);
        event.getRegistry().register((IForgeRegistryEntry)sizeStabilizationPotion);
    }

    @SubscribeEvent
    public static void registerPotionEffects(RegistryEvent.Register<PotionType> event) {
        if (!SizeUtils.isSizeComponentEnabled) {
            return;
        }
        PotionType shrinking_potion1 = ModPotions.registerPotionType(event, shrinkingPotion, "shrinking_potion1", 100, 0);
        PotionType shrinking_potion1_long = ModPotions.registerPotionType(event, shrinkingPotion, "shrinking_potion1_long", 200, 0);
        PotionType shrinking_potion1_longer = ModPotions.registerPotionType(event, shrinkingPotion, "shrinking_potion1_longer", 300, 0);
        PotionType shrinking_potion2 = ModPotions.registerPotionType(event, shrinkingPotion, "shrinking_potion2", 100, 1);
        PotionType shrinking_potion2_long = ModPotions.registerPotionType(event, shrinkingPotion, "shrinking_potion2_long", 200, 1);
        PotionType shrinking_potion2_longer = ModPotions.registerPotionType(event, shrinkingPotion, "shrinking_potion2_longer", 300, 1);
        PotionType shrinking_potion3 = ModPotions.registerPotionType(event, shrinkingPotion, "shrinking_potion3", 100, 2);
        PotionType shrinking_potion3_long = ModPotions.registerPotionType(event, shrinkingPotion, "shrinking_potion3_long", 200, 2);
        PotionType growth_potion1 = ModPotions.registerPotionType(event, growthPotion, "growth_potion1", 100, 0);
        PotionType growth_potion1_long = ModPotions.registerPotionType(event, growthPotion, "growth_potion1_long", 200, 0);
        PotionType growth_potion1_longer = ModPotions.registerPotionType(event, growthPotion, "growth_potion1_longer", 300, 0);
        PotionType growth_potion2 = ModPotions.registerPotionType(event, growthPotion, "growth_potion2", 100, 1);
        PotionType growth_potion2_long = ModPotions.registerPotionType(event, growthPotion, "growth_potion2_long", 200, 1);
        PotionType growth_potion2_longer = ModPotions.registerPotionType(event, growthPotion, "growth_potion2_longer", 300, 1);
        PotionType growth_potion3 = ModPotions.registerPotionType(event, growthPotion, "growth_potion3", 100, 2);
        PotionType growth_potion3_long = ModPotions.registerPotionType(event, growthPotion, "growth_potion3_long", 200, 2);
        PotionType shrinking_venom = ModPotions.registerPotionType(event, shrinkingVenom, "shrinking_venom", 100, 0);
        PotionType growth_venom = ModPotions.registerPotionType(event, growthVenom, "growth_venom", 100, 0);
        PotionType size_stabilization_potion = ModPotions.registerPotionType(event, sizeStabilizationPotion, "size_stabilization_potion", Integer.MAX_VALUE, 0);
        ModPotions.registerBrewing(shrinking_potion1, PotionTypes.field_185232_d, new ItemStack(Items.field_185161_cS));
        ModPotions.registerBrewing(shrinking_potion2, shrinking_potion1, new ItemStack(Items.field_151114_aO));
        ModPotions.registerBrewing(shrinking_potion3, shrinking_potion2, new ItemStack(Items.field_151114_aO));
        ModPotions.registerBrewing(shrinking_potion1_long, shrinking_potion1, new ItemStack(Items.field_151137_ax));
        ModPotions.registerBrewing(shrinking_potion2_long, shrinking_potion2, new ItemStack(Items.field_151137_ax));
        ModPotions.registerBrewing(shrinking_potion3_long, shrinking_potion3, new ItemStack(Items.field_151137_ax));
        ModPotions.registerBrewing(shrinking_potion1_longer, shrinking_potion1_long, new ItemStack(Items.field_151137_ax));
        ModPotions.registerBrewing(shrinking_potion2_longer, shrinking_potion2_long, new ItemStack(Items.field_151137_ax));
        ModPotions.registerBrewing(shrinking_potion2_long, shrinking_potion1_long, new ItemStack(Items.field_151114_aO));
        ModPotions.registerBrewing(shrinking_potion3_long, shrinking_potion2_long, new ItemStack(Items.field_151114_aO));
        ModPotions.registerBrewing(shrinking_potion2_longer, shrinking_potion1_longer, new ItemStack(Items.field_151114_aO));
        ModPotions.registerBrewing(growth_potion1, PotionTypes.field_185233_e, new ItemStack(Items.field_185161_cS));
        ModPotions.registerBrewing(growth_potion2, growth_potion1, new ItemStack(Items.field_151114_aO));
        ModPotions.registerBrewing(growth_potion3, growth_potion2, new ItemStack(Items.field_151114_aO));
        ModPotions.registerBrewing(growth_potion1_long, growth_potion1, new ItemStack(Items.field_151137_ax));
        ModPotions.registerBrewing(growth_potion2_long, growth_potion2, new ItemStack(Items.field_151137_ax));
        ModPotions.registerBrewing(growth_potion3_long, growth_potion3, new ItemStack(Items.field_151137_ax));
        ModPotions.registerBrewing(growth_potion1_longer, growth_potion1_long, new ItemStack(Items.field_151137_ax));
        ModPotions.registerBrewing(growth_potion2_longer, growth_potion2_long, new ItemStack(Items.field_151137_ax));
        ModPotions.registerBrewing(growth_potion2_long, growth_potion1_long, new ItemStack(Items.field_151114_aO));
        ModPotions.registerBrewing(growth_potion3_long, growth_potion2_long, new ItemStack(Items.field_151114_aO));
        ModPotions.registerBrewing(growth_potion2_longer, growth_potion1_longer, new ItemStack(Items.field_151114_aO));
        ModPotions.registerBrewing(shrinking_potion1, growth_potion1, new ItemStack(Items.field_151071_bq));
        ModPotions.registerBrewing(shrinking_potion2, growth_potion2, new ItemStack(Items.field_151071_bq));
        ModPotions.registerBrewing(shrinking_potion3, growth_potion3, new ItemStack(Items.field_151071_bq));
        ModPotions.registerBrewing(shrinking_potion1_long, growth_potion1_long, new ItemStack(Items.field_151071_bq));
        ModPotions.registerBrewing(shrinking_potion2_long, growth_potion2_long, new ItemStack(Items.field_151071_bq));
        ModPotions.registerBrewing(shrinking_potion3_long, growth_potion3_long, new ItemStack(Items.field_151071_bq));
        ModPotions.registerBrewing(shrinking_potion1_longer, growth_potion1_longer, new ItemStack(Items.field_151071_bq));
        ModPotions.registerBrewing(shrinking_potion2_longer, growth_potion2_longer, new ItemStack(Items.field_151071_bq));
        ModPotions.registerBrewing(growth_potion1, shrinking_potion1, new ItemStack(Items.field_151071_bq));
        ModPotions.registerBrewing(growth_potion2, shrinking_potion2, new ItemStack(Items.field_151071_bq));
        ModPotions.registerBrewing(growth_potion3, shrinking_potion3, new ItemStack(Items.field_151071_bq));
        ModPotions.registerBrewing(growth_potion1_long, shrinking_potion1_long, new ItemStack(Items.field_151071_bq));
        ModPotions.registerBrewing(growth_potion2_long, shrinking_potion2_long, new ItemStack(Items.field_151071_bq));
        ModPotions.registerBrewing(growth_potion3_long, shrinking_potion3_long, new ItemStack(Items.field_151071_bq));
        ModPotions.registerBrewing(growth_potion1_longer, shrinking_potion1_longer, new ItemStack(Items.field_151071_bq));
        ModPotions.registerBrewing(growth_potion2_longer, shrinking_potion2_longer, new ItemStack(Items.field_151071_bq));
        ModPotions.registerBrewing(growth_venom, null, ItemStack.field_190927_a);
        ModPotions.registerBrewing(shrinking_venom, null, ItemStack.field_190927_a);
    }

    private static PotionType registerPotionType(RegistryEvent.Register<PotionType> event, Potion potion, String resourcePath, int duration, int amplifier) {
        PotionEffect effect = new PotionEffect(potion, duration, amplifier);
        PotionType type = new PotionType(new PotionEffect[]{effect});
        type.setRegistryName(new ResourceLocation("mia", resourcePath));
        event.getRegistry().register((IForgeRegistryEntry)type);
        return type;
    }

    private static void registerBrewing(@Nonnull PotionType result, @Nullable PotionType previousLevel, @Nonnull ItemStack ingredient) {
        ThermalExpansion.addBrewingRecipe(result, previousLevel, ingredient);
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new StrictBrewingRecipe(net.minecraft.potion.PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)result), new ItemStack(Items.field_151016_H), net.minecraft.potion.PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)result)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new StrictBrewingRecipe(net.minecraft.potion.PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)result), new ItemStack(Items.field_185157_bK), net.minecraft.potion.PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185156_bI), (PotionType)result)));
        if (previousLevel == null || ingredient.func_190926_b()) {
            return;
        }
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new StrictBrewingRecipe(net.minecraft.potion.PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)previousLevel), ingredient, net.minecraft.potion.PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)result)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new StrictBrewingRecipe(net.minecraft.potion.PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)previousLevel), ingredient, net.minecraft.potion.PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)result)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new StrictBrewingRecipe(net.minecraft.potion.PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185156_bI), (PotionType)previousLevel), ingredient, net.minecraft.potion.PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185156_bI), (PotionType)result)));
    }

    private static class StrictBrewingRecipe
    extends BrewingRecipe {
        private StrictBrewingRecipe(@Nonnull ItemStack input, @Nonnull ItemStack ingredient, @Nonnull ItemStack output) {
            super(input, ingredient, output);
        }

        public boolean isInput(@Nonnull ItemStack stack) {
            return PotionUtils.arePotionsSame(stack, this.getInput());
        }
    }
}

