/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.xu2;

import cofh.thermalfoundation.item.ItemMaterial;
import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.config.Xu2Configuration;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.base.IBaseMod;
import com.github.sokyranthedragon.mia.integrations.base.IModIntegration;
import com.github.sokyranthedragon.mia.integrations.thaumcraft.ThaumcraftHelpers;
import com.github.sokyranthedragon.mia.integrations.xu2.ChiselExtraUtilsIntegration;
import com.github.sokyranthedragon.mia.integrations.xu2.FutureMcExtraUtilsIntegration;
import com.github.sokyranthedragon.mia.integrations.xu2.HatcheryExtraUtilsIntegration;
import com.github.sokyranthedragon.mia.integrations.xu2.IExtraUtilsIntegration;
import com.github.sokyranthedragon.mia.integrations.xu2.JerExtraUtilsIntegration;
import com.github.sokyranthedragon.mia.integrations.xu2.QuarkExtraUtilsIntegration;
import com.github.sokyranthedragon.mia.integrations.xu2.ThermalExpansionExtraUtilsIntegration;
import com.rwtema.extrautils2.api.machine.IMachineRecipe;
import com.rwtema.extrautils2.api.machine.Machine;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import com.rwtema.extrautils2.api.machine.RecipeBuilder;
import com.rwtema.extrautils2.api.machine.XUMachineCrusher;
import com.rwtema.extrautils2.api.machine.XUMachineGenerators;
import com.rwtema.extrautils2.backend.entries.Entry;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.items.itemmatching.IMatcherMaker;
import com.rwtema.extrautils2.machine.EnergyBaseRecipe;
import com.rwtema.extrautils2.machine.MachineInit;
import com.rwtema.extrautils2.utils.datastructures.ItemRef;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectEventProxy;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.AspectRegistryEvent;

public class ExtraUtilities2
implements IBaseMod {
    private final List<IExtraUtilsIntegration> modIntegrations = new LinkedList<IExtraUtilsIntegration>();

    @Override
    public void register(BiConsumer<ModIds, IModIntegration> modIntegration) {
        if (Xu2Configuration.enableTeIntegration && ModIds.THERMAL_EXPANSION.isLoaded) {
            modIntegration.accept(ModIds.THERMAL_EXPANSION, new ThermalExpansionExtraUtilsIntegration());
        }
        if (ModIds.HATCHERY.isLoaded) {
            modIntegration.accept(ModIds.HATCHERY, new HatcheryExtraUtilsIntegration(Xu2Configuration.enableHatcheryIntegration));
        }
        if (Xu2Configuration.enableQuarkIntegration && ModIds.QUARK.isLoaded) {
            modIntegration.accept(ModIds.QUARK, new QuarkExtraUtilsIntegration());
        }
        if (Xu2Configuration.enableJerIntegration && ModIds.JER.isLoaded) {
            modIntegration.accept(ModIds.JER, new JerExtraUtilsIntegration());
        }
        if (Xu2Configuration.enableFutureMcIntegration && ModIds.FUTURE_MC.isLoaded) {
            modIntegration.accept(ModIds.FUTURE_MC, new FutureMcExtraUtilsIntegration());
        }
        if (Xu2Configuration.enableChiselIntegration && ModIds.CHISEL.isLoaded) {
            modIntegration.accept(ModIds.CHISEL, new ChiselExtraUtilsIntegration());
        }
    }

    @Override
    public void addIntegration(IModIntegration integration) {
        if (!Xu2Configuration.externalIntegrationsEnabled) {
            return;
        }
        if (integration instanceof IExtraUtilsIntegration) {
            this.modIntegrations.add((IExtraUtilsIntegration)integration);
            return;
        }
        Mia.LOGGER.warn("Incorrect XU2 integration with id of " + (Object)((Object)integration.getModId()) + ": " + integration.toString());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (Xu2Configuration.xu2AdditionsEnabled && !MiaConfig.disableAllRecipes) {
            XUMachineGenerators.DEATH_GENERATOR.recipes_registry.addRecipe((IMachineRecipe)new EnergyBaseRecipe.EnergyBaseItem((IMatcherMaker)ItemRef.wrap((ItemStack)new ItemStack(Items.field_151144_bL, 1, 0)), 30000, 40));
            XUMachineGenerators.DEATH_GENERATOR.recipes_registry.addRecipe((IMachineRecipe)new EnergyBaseRecipe.EnergyBaseItem((IMatcherMaker)ItemRef.wrap((ItemStack)new ItemStack(Items.field_151144_bL, 1, 2)), 30000, 40));
            XUMachineGenerators.DEATH_GENERATOR.recipes_registry.addRecipe((IMachineRecipe)new EnergyBaseRecipe.EnergyBaseItem((IMatcherMaker)new IMatcherMaker.MatcherMakerOreDic("boneWithered"), 32000));
            XUMachineGenerators.PINK_GENERATOR.recipes_registry.addRecipe((IMachineRecipe)new EnergyBaseRecipe.EnergyBaseItem((IMatcherMaker)ItemRef.wrap((Block)Blocks.field_192433_dH), 400, 40));
            XUMachineGenerators.PINK_GENERATOR.recipes_registry.addRecipe((IMachineRecipe)new EnergyBaseRecipe.EnergyBaseItem((IMatcherMaker)ItemRef.wrap((Block)Blocks.field_190983_dr), 400, 40));
            if (ModIds.THERMAL_FOUNDATION.isLoaded) {
                XUMachineCrusher.addRecipe((ItemStack)new ItemStack(Blocks.field_150424_aL), (ItemStack)new ItemStack(Blocks.field_150351_n), (ItemStack)ItemMaterial.dustSulfur, (float)0.1f);
            } else {
                XUMachineCrusher.addRecipe((ItemStack)new ItemStack(Blocks.field_150424_aL), (ItemStack)new ItemStack(Blocks.field_150351_n));
            }
        }
        if (Xu2Configuration.xu2AdditionsEnabled && !MiaConfig.disableOreDict) {
            for (int meta = 0; meta <= 5; ++meta) {
                if (meta <= 2) {
                    OreDictionary.registerOre((String)"blockGlassColorless", (ItemStack)XU2Entries.decorativeGlass.newStackMeta(meta));
                }
                if (meta == 0 || meta == 3) continue;
                OreDictionary.registerOre((String)"blockGlass", (ItemStack)XU2Entries.decorativeGlass.newStackMeta(meta));
            }
            OreDictionary.registerOre((String)"blockGlassBlack", (ItemStack)XU2Entries.decorativeGlass.newStackMeta(3));
            OreDictionary.registerOre((String)"blockGlassYellow", (ItemStack)XU2Entries.decorativeGlass.newStackMeta(4));
            OreDictionary.registerOre((String)"blockGlassRed", (ItemStack)XU2Entries.decorativeGlass.newStackMeta(5));
        }
        if (!this.modIntegrations.isEmpty() && !MiaConfig.disableAllRecipes) {
            MachineSlotItem slimeSecondary;
            ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"ExtraUtilities2 addRecipes", (int)(this.modIntegrations.size() + 1));
            progressBar.step("setting up");
            try {
                Field secondInputField = MachineInit.class.getDeclaredField("SLOT_SLIME_SECONDARY");
                secondInputField.setAccessible(true);
                slimeSecondary = (MachineSlotItem)secondInputField.get(null);
                XUMachineGenerators.SLIME_GENERATOR.recipes_registry.addRecipe(RecipeBuilder.newbuilder((Machine)XUMachineGenerators.SLIME_GENERATOR).setRFRate(432000, 400.0f).setItemInput(XUMachineGenerators.INPUT_ITEM, new ItemStack(Blocks.field_180399_cE), 1).setItemInput(slimeSecondary, new ItemStack(Items.field_151117_aB, 1)).build());
            }
            catch (Exception e) {
                slimeSecondary = null;
            }
            for (IExtraUtilsIntegration integration : this.modIntegrations) {
                progressBar.step(integration.getModId().modId);
                integration.addRecipes(slimeSecondary);
            }
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        }
    }

    @Override
    @Optional.Method(modid="thaumcraft")
    public void registerAspects(AspectRegistryEvent event) {
        AspectEventProxy register = event.register;
        this.registerAspects(register, (Entry)XU2Entries.miniChest, new AspectList().add(Aspect.PLANT, 2));
        this.registerAspects(register, (Entry)XU2Entries.blockEnderLilly, new AspectList().add(Aspect.MOTION, 5).add(Aspect.ELDRITCH, 3).add(Aspect.PLANT, 5).add(Aspect.SENSES, 5).add(Aspect.LIFE, 1));
        this.registerAspects(register, (Entry)XU2Entries.blockRedOrchid, new AspectList().add(Aspect.PLANT, 5).add(Aspect.SENSES, 5).add(Aspect.ENERGY, 5).add(Aspect.LIFE, 1));
        this.registerAspects(register, (Entry)XU2Entries.wateringCan, Short.MAX_VALUE, new AspectList().add(Aspect.TOOL, 16).add(Aspect.VOID, 3).add(Aspect.EARTH, 15));
        this.registerAspects(register, (Entry)XU2Entries.goldenLasso, new AspectList().add(Aspect.BEAST, 15).add(Aspect.CRAFT, 3).add(Aspect.METAL, 3).add(Aspect.DESIRE, 3));
        this.registerAspects(register, (Entry)XU2Entries.cursedEarth, new AspectList().add(Aspect.EARTH, 4).add(Aspect.PLANT, 1).add(Aspect.METAL, 2).add(Aspect.FIRE, 2));
        this.registerAspects(register, (Entry)XU2Entries.pipe, new AspectList().add(Aspect.EARTH, 4).add(Aspect.CRYSTAL, 7).add(Aspect.ENERGY, 7));
        this.registerAspects(register, (Entry)XU2Entries.sunCrystal, new AspectList().add(Aspect.LIGHT, 100).add(Aspect.SENSES, 25).add(Aspect.CRYSTAL, 25).add(Aspect.DESIRE, 25));
        this.registerAspects(register, (Entry)XU2Entries.itemIngredients, 3, new AspectList().add(Aspect.SENSES, 5).add(Aspect.EARTH, 2).add(Aspect.DESIRE, 2).add(Aspect.DARKNESS, 2));
        this.registerAspects(register, (Entry)XU2Entries.itemIngredients, 4, new AspectList().add(Aspect.ENERGY, 13).add(Aspect.FIRE, 13));
        this.registerAspects(register, (Entry)XU2Entries.itemIngredients, 9, new AspectList().add(AspectHelper.getObjectAspects((ItemStack)new ItemStack(Blocks.field_150445_bS))).add(Aspect.FIRE, 3));
        this.registerAspects(register, (Entry)XU2Entries.itemIngredients, 10, new AspectList().add(Aspect.METAL, 3).add(Aspect.FIRE, 3));
        this.registerAspects(register, (Entry)XU2Entries.itemIngredients, 11, new AspectList().add(Aspect.METAL, 10).add(Aspect.DESIRE, 10).add(Aspect.FIRE, 10));
        this.registerAspects(register, (Entry)XU2Entries.itemIngredients, 12, new AspectList().add(Aspect.METAL, 10).add(Aspect.DESIRE, 10).add(Aspect.MAGIC, 5));
        this.registerAspects(register, (Entry)XU2Entries.itemIngredients, 13, new AspectList().add(Aspect.METAL, 3).add(Aspect.ENERGY, 5).add(Aspect.FIRE, 1));
        this.registerAspects(register, (Entry)XU2Entries.itemIngredients, 17, new AspectList().add(Aspect.MAGIC, 2).add(Aspect.ORDER, 2).add(Aspect.ELDRITCH, 1).add(Aspect.AURA, 1).add(Aspect.METAL, 10).add(Aspect.DARKNESS, 2));
        this.registerAspects(register, (Entry)XU2Entries.unstableIngots, 0, new AspectList().add(Aspect.ENTROPY, 250).add(Aspect.CRYSTAL, 150).add(Aspect.DESIRE, 150).add(Aspect.METAL, 100));
        this.registerAspects(register, (Entry)XU2Entries.unstableIngots, 1, new AspectList().add(Aspect.ENTROPY, 10).add(Aspect.CRYSTAL, 5).add(Aspect.DESIRE, 5).add(Aspect.METAL, 3));
        this.registerAspects(register, (Entry)XU2Entries.unstableIngots, 2, new AspectList().add(Aspect.ENTROPY, 90).add(Aspect.CRYSTAL, 45).add(Aspect.DESIRE, 45).add(Aspect.METAL, 27));
        this.registerAspects(register, (Entry)XU2Entries.decorativeSolidWood, 0, 1, new AspectList().add(Aspect.MAGIC, 20).add(Aspect.PLANT, 20).add(Aspect.MIND, 8));
        this.registerAspects(register, (Entry)XU2Entries.decorativeGlass, 0, 2, new AspectList().add(Aspect.CRYSTAL, 6));
        this.registerAspects(register, (Entry)XU2Entries.decorativeGlass, 3, new AspectList().add(Aspect.CRYSTAL, 6).add(Aspect.SENSES, 1));
        this.registerAspects(register, (Entry)XU2Entries.decorativeGlass, 4, new AspectList().add(Aspect.CRYSTAL, 6).add(Aspect.LIGHT, 3).add(Aspect.SENSES, 1));
        this.registerAspects(register, (Entry)XU2Entries.decorativeGlass, 5, new AspectList().add(Aspect.CRYSTAL, 6).add(Aspect.ENERGY, 3));
        this.registerAspects(register, (Entry)XU2Entries.decorativeSolid, 0, 2, new AspectList().add(Aspect.EARTH, 3));
        this.registerAspects(register, (Entry)XU2Entries.decorativeSolid, 3, new AspectList().add(Aspect.EARTH, 3).add(Aspect.FIRE, 2));
        this.registerAspects(register, (Entry)XU2Entries.decorativeSolid, 5, new AspectList().add(Aspect.EARTH, 3));
        this.registerAspects(register, (Entry)XU2Entries.decorativeSolid, 7, new AspectList().add(Aspect.CRYSTAL, 15).add(Aspect.FIRE, 2));
        this.registerAspects(register, (Entry)XU2Entries.decorativeSolid, 8, new AspectList().add(Aspect.CRYSTAL, 15).add(Aspect.MAGIC, 15).add(Aspect.ENERGY, 1).add(Aspect.ELDRITCH, 15));
        if (XU2Entries.compressedCobblestone.enabled && XU2Entries.compressedNetherack.enabled && XU2Entries.compressedDirt.enabled && XU2Entries.compressedGravel.enabled && XU2Entries.compressedSand.enabled) {
            AspectList cobblestone = AspectHelper.getObjectAspects((ItemStack)new ItemStack(Blocks.field_150347_e));
            AspectList netherrack = AspectHelper.getObjectAspects((ItemStack)new ItemStack(Blocks.field_150424_aL));
            AspectList dirt = AspectHelper.getObjectAspects((ItemStack)new ItemStack(Blocks.field_150346_d));
            AspectList sand = AspectHelper.getObjectAspects((ItemStack)new ItemStack((Block)Blocks.field_150354_m));
            AspectList gravel = AspectHelper.getObjectAspects((ItemStack)new ItemStack(Blocks.field_150351_n));
            int power = MathHelper.func_76123_f((float)33.75f);
            for (int meta = 0; meta <= 7; ++meta) {
                if (XU2Entries.compressedCobblestone.enabled) {
                    ThaumcraftHelpers.transferAspects(XU2Entries.compressedCobblestone.newStack(meta), cobblestone, register, (float)power, false);
                }
                if (XU2Entries.compressedNetherack.enabled && meta <= 5) {
                    ThaumcraftHelpers.transferAspects(XU2Entries.compressedNetherack.newStackMeta(meta), netherrack, register, (float)power, false);
                }
                if (XU2Entries.compressedDirt.enabled && meta <= 3) {
                    ThaumcraftHelpers.transferAspects(XU2Entries.compressedDirt.newStackMeta(meta), dirt, register, (float)power, false);
                }
                if (meta <= 2) {
                    if (XU2Entries.compressedGravel.enabled) {
                        ThaumcraftHelpers.transferAspects(XU2Entries.compressedGravel.newStackMeta(meta), gravel, register, (float)power, false);
                    }
                    if (XU2Entries.compressedSand.enabled) {
                        ThaumcraftHelpers.transferAspects(XU2Entries.compressedSand.newStackMeta(meta), sand, register, (float)power, false);
                    }
                }
                power = MathHelper.func_76123_f((float)((float)(power * 9) * 0.75f));
            }
        }
        this.registerAspects(register, (Entry)XU2Entries.decorativeBedrock, 0, 2, AspectHelper.getObjectAspects((ItemStack)new ItemStack(Blocks.field_150357_h)));
        if (XU2Entries.itemGlassCutter.enabled) {
            this.appendToolAspect(register, XU2Entries.itemGlassCutter.newWildcardStack());
        }
        if (XU2Entries.trowel.enabled) {
            this.appendToolAspect(register, XU2Entries.trowel.newWildcardStack());
        }
        if (XU2Entries.wrench.enabled) {
            this.appendToolAspect(register, XU2Entries.wrench.newWildcardStack());
        }
        if (XU2Entries.angelRing.enabled && XU2Entries.chickenRing.enabled) {
            List angelRingStacks = XU2Entries.angelRing.getCreativeStacks();
            AspectList squidRingAspects = AspectHelper.getObjectAspects((ItemStack)XU2Entries.chickenRing.newStackMeta(1));
            for (ItemStack angelRing : angelRingStacks) {
                AspectList angelAspects = AspectHelper.getObjectAspects((ItemStack)angelRing);
                for (Map.Entry aspects : squidRingAspects.aspects.entrySet()) {
                    angelAspects.merge((Aspect)aspects.getKey(), (int)((float)((Integer)aspects.getValue()).intValue() * 0.75f));
                }
                register.registerObjectTag(angelRing, angelAspects);
            }
        }
        if (XU2Entries.snowGlobe.enabled) {
            ThaumcraftHelpers.transferAspects(XU2Entries.snowGlobe.newStackMeta(1), XU2Entries.snowGlobe.newStackMeta(0), register, new AspectList().add(Aspect.MAGIC, 25).add(Aspect.PLANT, 50));
        }
    }

    private <T> void registerAspects(AspectEventProxy register, Entry<T> entry, AspectList aspects) {
        if (entry.enabled) {
            register.registerObjectTag(entry.newStack(), aspects);
        }
    }

    private <T> void registerAspects(AspectEventProxy register, Entry<T> entry, int meta, AspectList aspects) {
        if (entry.enabled) {
            register.registerObjectTag(entry.newStackMeta(meta), aspects);
        }
    }

    private <T> void registerAspects(AspectEventProxy register, Entry<T> entry, int metaStart, int metaEnd, AspectList aspects) {
        if (entry.enabled) {
            for (int meta = metaStart; meta <= metaEnd; ++meta) {
                register.registerObjectTag(entry.newStackMeta(meta), aspects);
            }
        }
    }

    @Optional.Method(modid="thaumcraft")
    private void appendToolAspect(AspectEventProxy register, ItemStack item) {
        register.registerObjectTag(item, AspectHelper.getObjectAspects((ItemStack)item).merge(Aspect.TOOL, 12));
    }
}

