/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.thaumcraft;

import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectEventProxy;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;

@ParametersAreNonnullByDefault
public class ThaumcraftHelpers {
    public static void addAspects(ItemStack target, @Nullable AspectList origin, AspectEventProxy register) {
        ThaumcraftHelpers.transferAspects(target, origin, register, 1.0f, false);
    }

    public static void transferAspects(ItemStack target, @Nullable AspectList origin, AspectEventProxy register) {
        ThaumcraftHelpers.transferAspects(target, origin, register, 1.0f, true);
    }

    public static void transferAspects(ItemStack target, @Nullable AspectList origin, AspectEventProxy register, boolean lossFromCrafting) {
        ThaumcraftHelpers.transferAspects(target, origin, register, 1.0f, lossFromCrafting);
    }

    public static void transferAspects(ItemStack target, @Nullable AspectList origin, AspectEventProxy register, boolean lossFromCrafting, @Nullable AspectList additionalAspects) {
        ThaumcraftHelpers.transferAspects(target, origin, register, 1.0f, lossFromCrafting, additionalAspects);
    }

    public static void transferAspects(ItemStack target, @Nullable AspectList origin, AspectEventProxy register, float multiplier) {
        ThaumcraftHelpers.transferAspects(target, origin, register, multiplier, true);
    }

    public static void transferAspects(ItemStack target, @Nullable AspectList origin, AspectEventProxy register, float multiplier, @Nullable AspectList additionalAspects) {
        ThaumcraftHelpers.transferAspects(target, origin, register, multiplier, true, additionalAspects);
    }

    public static void transferAspects(ItemStack target, @Nullable AspectList origin, AspectEventProxy register, @Nullable AspectList additionalAspects) {
        ThaumcraftHelpers.transferAspects(target, origin, register, 1.0f, true, additionalAspects);
    }

    public static void transferAspects(ItemStack target, @Nullable AspectList origin, AspectEventProxy register, float multiplier, boolean lossFromCrafting) {
        ThaumcraftHelpers.transferAspects(target, origin, register, multiplier, lossFromCrafting, null);
    }

    public static void transferAspects(ItemStack target, ItemStack origin, AspectEventProxy register) {
        ThaumcraftHelpers.transferAspects(target, origin, register, 1.0f, true);
    }

    public static void transferAspects(ItemStack target, ItemStack origin, AspectEventProxy register, boolean lossFromCrafting) {
        ThaumcraftHelpers.transferAspects(target, origin, register, 1.0f, lossFromCrafting);
    }

    public static void transferAspects(ItemStack target, ItemStack origin, AspectEventProxy register, boolean lossFromCrafting, @Nullable AspectList additionalAspects) {
        ThaumcraftHelpers.transferAspects(target, origin, register, 1.0f, lossFromCrafting, additionalAspects);
    }

    public static void transferAspects(ItemStack target, ItemStack origin, AspectEventProxy register, float multiplier) {
        ThaumcraftHelpers.transferAspects(target, origin, register, multiplier, true);
    }

    public static void transferAspects(ItemStack target, ItemStack origin, AspectEventProxy register, float multiplier, @Nullable AspectList additionalAspects) {
        ThaumcraftHelpers.transferAspects(target, origin, register, multiplier, true, additionalAspects);
    }

    public static void transferAspects(ItemStack target, ItemStack origin, AspectEventProxy register, @Nullable AspectList additionalAspects) {
        ThaumcraftHelpers.transferAspects(target, origin, register, 1.0f, true, additionalAspects);
    }

    public static void transferAspects(ItemStack target, ItemStack origin, AspectEventProxy register, float multiplier, boolean lossFromCrafting) {
        ThaumcraftHelpers.transferAspects(target, origin, register, multiplier, lossFromCrafting, null);
    }

    public static void transferAspects(ItemStack target, ItemStack origin, AspectEventProxy register, float multiplier, boolean lossFromCrafting, @Nullable AspectList additionalAspects) {
        ThaumcraftHelpers.transferAspects(target, AspectHelper.getObjectAspects((ItemStack)origin), register, multiplier, lossFromCrafting, additionalAspects);
    }

    public static void transferAspects(ItemStack target, @Nullable AspectList origin, AspectEventProxy register, float multiplier, boolean lossFromCrafting, @Nullable AspectList additionalAspects) {
        AspectList targetAspects = AspectHelper.getObjectAspects((ItemStack)target);
        if (targetAspects == null) {
            targetAspects = new AspectList();
        }
        if (additionalAspects != null && additionalAspects.size() > 0) {
            targetAspects.merge(additionalAspects);
        }
        if (origin == null || origin.size() <= 0 || multiplier == 0.0f) {
            if (additionalAspects != null && additionalAspects.size() > 0) {
                register.registerObjectTag(target, targetAspects);
            }
            return;
        }
        if (lossFromCrafting) {
            multiplier *= 0.75f;
        }
        if (multiplier == 1.0f) {
            targetAspects.merge(origin);
        } else {
            for (Map.Entry aspects : origin.aspects.entrySet()) {
                int value = (int)((float)((Integer)aspects.getValue()).intValue() * multiplier);
                if (value <= 0) continue;
                targetAspects.merge((Aspect)aspects.getKey(), Math.min(value, 500));
            }
        }
        register.registerObjectTag(target, targetAspects);
    }

    public static void addAspect(NonNullList<ItemStack> stacks, AspectEventProxy register, Aspect aspect) {
        ThaumcraftHelpers.addAspect(stacks, register, aspect, 1);
    }

    public static void addAspect(NonNullList<ItemStack> stacks, AspectEventProxy register, Aspect aspect, int amount) {
        for (ItemStack stack : stacks) {
            AspectList aspects = AspectHelper.getObjectAspects((ItemStack)stack);
            if (aspects == null) {
                register.registerObjectTag(stack, new AspectList().add(aspect, amount));
                continue;
            }
            register.registerObjectTag(stack, aspects.merge(aspect, amount));
        }
    }
}

