/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.thaumcraft;

import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.jer.ExtraConditional;
import com.github.sokyranthedragon.mia.integrations.jer.IJerIntegration;
import com.github.sokyranthedragon.mia.integrations.jer.JustEnoughResources;
import com.github.sokyranthedragon.mia.integrations.jer.ResourceLocationWrapper;
import com.github.sokyranthedragon.mia.utilities.LootTableUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import jeresources.api.IMobRegistry;
import jeresources.api.conditionals.Conditional;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.drop.LootDrop;
import jeresources.entry.MobEntry;
import jeresources.util.LootTableHelper;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.entities.monster.EntityBrainyZombie;
import thaumcraft.common.entities.monster.EntityFireBat;
import thaumcraft.common.entities.monster.EntityMindSpider;
import thaumcraft.common.entities.monster.EntityPech;
import thaumcraft.common.entities.monster.EntityThaumicSlime;
import thaumcraft.common.entities.monster.EntityWisp;
import thaumcraft.common.entities.monster.boss.EntityCultistLeader;
import thaumcraft.common.entities.monster.boss.EntityEldritchGolem;
import thaumcraft.common.entities.monster.boss.EntityEldritchWarden;
import thaumcraft.common.entities.monster.boss.EntityTaintacleGiant;
import thaumcraft.common.entities.monster.boss.EntityThaumcraftBoss;
import thaumcraft.common.entities.monster.cult.EntityCultist;
import thaumcraft.common.entities.monster.cult.EntityCultistCleric;
import thaumcraft.common.entities.monster.cult.EntityCultistKnight;
import thaumcraft.common.entities.monster.tainted.EntityTaintCrawler;
import thaumcraft.common.entities.monster.tainted.EntityTaintSeed;
import thaumcraft.common.entities.monster.tainted.EntityTaintSeedPrime;
import thaumcraft.common.entities.monster.tainted.EntityTaintSwarm;
import thaumcraft.common.entities.monster.tainted.EntityTaintacle;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
class JerThaumcraftIntegration
implements IJerIntegration {
    JerThaumcraftIntegration() {
    }

    @Override
    public void addMobs(JustEnoughResources.CustomMobTableBuilder builder) {
        builder.add(LootTableUtils.loadUniqueLootTable(LootTableList.field_186383_ah), EntityBrainyZombie.class);
        builder.add(EntityPech.LOOT, EntityPech.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), EntityFireBat.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), EntityMindSpider.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), EntityWisp.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), EntityEldritchGolem.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), EntityEldritchWarden.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), EntityTaintacle.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), EntityTaintacleGiant.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), EntityTaintCrawler.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), EntityTaintSwarm.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), EntityTaintSeed.class);
        builder.add(LootTableUtils.loadUniqueEmptyLootTable(), EntityTaintSeedPrime.class);
        builder.add(new ResourceLocationWrapper(EntityCultist.LOOT, 0), EntityCultistCleric.class);
        builder.add(new ResourceLocationWrapper(EntityCultist.LOOT, 1), EntityCultistKnight.class);
        builder.add(new ResourceLocationWrapper(EntityCultist.LOOT, 2), EntityCultistLeader.class);
    }

    @Override
    public void configureMob(ResourceLocation resource, EntityLivingBase entity, @Nullable LootTableManager manager, IMobRegistry mobRegistry) {
        LightLevel lightLevel = LightLevel.hostile;
        Set<Object> validBiomes = new HashSet();
        List loot = null;
        if (manager != null) {
            loot = LootTableHelper.toDrops((LootTable)manager.func_186521_a(resource));
        }
        int minExp = 0;
        int maxExp = 0;
        if (entity instanceof EntityBrainyZombie) {
            if (loot != null) {
                loot.add(new LootDrop(new ItemStack(ItemsTC.brain), 0, 1, 0.5f, new Conditional[]{Conditional.affectedByLooting}));
            }
            validBiomes = Stream.of(Objects.requireNonNull(BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM)).stream(), Objects.requireNonNull(BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL)).stream(), Objects.requireNonNull(BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY)).stream(), Objects.requireNonNull(BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT)).stream()).reduce(Stream::concat).orElseGet(Stream::empty).map(biomeEntry -> biomeEntry.biome).distinct().filter(biome -> biome.func_76747_a(EnumCreatureType.MONSTER) != null && biome.func_76747_a(EnumCreatureType.MONSTER).size() > 0).collect(Collectors.toSet());
            minExp = 5;
        } else if (entity instanceof EntityCultist) {
            if (loot != null) {
                loot.add(new LootDrop(new ItemStack(ItemsTC.curio, 1, 6), 0, 1, 0.25f, new Conditional[]{Conditional.playerKill, Conditional.affectedByLooting, ExtraConditional.affectedByResearch, ExtraConditional.lessChanceIfHeld}));
                if (entity instanceof EntityCultistCleric) {
                    loot.add(new LootDrop(new ItemStack(ItemsTC.crimsonRobeHelm), 0, 1, 0.05f, new Conditional[]{Conditional.equipmentDrop}));
                    loot.add(new LootDrop(new ItemStack(ItemsTC.crimsonRobeChest), 0, 1, 0.05f, new Conditional[]{Conditional.equipmentDrop}));
                    loot.add(new LootDrop(new ItemStack(ItemsTC.crimsonRobeLegs), 0, 1, 0.05f, new Conditional[]{Conditional.equipmentDrop}));
                    loot.add(new LootDrop(new ItemStack(ItemsTC.crimsonBoots), 0, 1, 0.05f, new Conditional[]{Conditional.equipmentDrop}));
                } else if (entity instanceof EntityCultistKnight) {
                    loot.add(new LootDrop(new ItemStack(ItemsTC.crimsonPlateHelm), 0, 1, 0.05f, new Conditional[]{Conditional.equipmentDrop}));
                    loot.add(new LootDrop(new ItemStack(ItemsTC.crimsonRobeHelm), 0, 1, 0.05f, new Conditional[]{Conditional.equipmentDrop}));
                    loot.add(new LootDrop(new ItemStack(ItemsTC.crimsonPlateChest), 0, 1, 0.05f, new Conditional[]{Conditional.equipmentDrop}));
                    loot.add(new LootDrop(new ItemStack(ItemsTC.crimsonPlateLegs), 0, 1, 0.05f, new Conditional[]{Conditional.equipmentDrop}));
                    loot.add(new LootDrop(new ItemStack(ItemsTC.crimsonBoots), 0, 1, 0.05f, new Conditional[]{Conditional.equipmentDrop}));
                }
            }
            minExp = 10;
        } else if (entity instanceof EntityPech) {
            minExp = 8;
        } else if (entity instanceof EntityMindSpider) {
            minExp = 1;
        } else if (entity instanceof EntityWisp) {
            minExp = 5;
        } else if (entity instanceof EntityFireBat) {
            if (loot != null) {
                loot.add(new LootDrop(new ItemStack(Items.field_151016_H), 0, 2, new Conditional[]{Conditional.affectedByLooting}));
            }
            validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
        } else if (entity instanceof EntityTaintacleGiant) {
            if (loot != null) {
                loot.add(new LootDrop(new ItemStack(ItemsTC.primordialPearl), 0, 1, new Conditional[]{ExtraConditional.ifLastOneKilled}));
            }
            minExp = 20;
        } else if (entity instanceof EntityTaintacle) {
            if (loot != null) {
                loot.add(new LootDrop(ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FLUX)));
            }
            minExp = 8;
        } else if (entity instanceof EntityCultistLeader) {
            minExp = 40;
        } else if (entity instanceof EntityThaumcraftBoss) {
            if (loot != null) {
                loot.add(new LootDrop(new ItemStack(ItemsTC.primordialPearl, 1, 2), 1, 1, new Conditional[0]));
                loot.add(new LootDrop(new ItemStack(ItemsTC.lootBag, 1, 2), 1, 1, new Conditional[0]));
            }
            minExp = 50;
        } else if (entity instanceof EntityTaintCrawler) {
            if (loot != null) {
                loot.add(new LootDrop(ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FLUX), 0, 1, 0.125f, new Conditional[0]));
            }
            minExp = 3;
        } else if (entity instanceof EntityTaintSwarm) {
            if (loot != null) {
                loot.add(new LootDrop(ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FLUX), 0, 1, 0.5f, new Conditional[0]));
            }
            minExp = 5;
        } else if (entity instanceof EntityTaintSeedPrime) {
            if (loot != null) {
                loot.add(new LootDrop(ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FLUX), 1, 3, new Conditional[0]));
            }
            minExp = 12;
        } else if (entity instanceof EntityTaintSeed) {
            if (loot != null) {
                loot.add(new LootDrop(ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FLUX)));
            }
            minExp = 8;
        } else if (entity instanceof EntityThaumicSlime) {
            minExp = 3;
            maxExp = 10;
        }
        if (minExp > maxExp) {
            maxExp = minExp;
        }
        if (loot == null) {
            if (validBiomes.isEmpty()) {
                mobRegistry.register(entity, lightLevel, minExp, maxExp, resource);
            } else {
                mobRegistry.register(entity, lightLevel, minExp, maxExp, (String[])validBiomes.stream().map(Biome::func_185359_l).toArray(String[]::new), resource);
            }
        } else {
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            if (validBiomes.isEmpty()) {
                mobRegistry.register(entity, lightLevel, minExp, maxExp, drops);
            } else {
                mobRegistry.register(entity, lightLevel, minExp, maxExp, (String[])validBiomes.stream().map(Biome::func_185359_l).toArray(String[]::new), drops);
            }
        }
    }

    @Override
    public void overrideExistingMobDrops(MobEntry mobEntry) {
        if (mobEntry.getEntity() instanceof EntityZombie && !(mobEntry.getEntity() instanceof EntityBrainyZombie)) {
            mobEntry.addDrop(new LootDrop(new ItemStack(ItemsTC.brain), 0, 1, 0.1f, new Conditional[]{Conditional.affectedByLooting}));
        }
    }

    @Override
    @Nonnull
    public ModIds getModId() {
        return ModIds.THAUMCRAFT;
    }
}

