/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.quark;

import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.tconstruct.ITConstructIntegration;
import com.github.sokyranthedragon.mia.utilities.QuarkUtils;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.shared.TinkerFluids;
import vazkii.quark.automation.feature.MetalButtons;
import vazkii.quark.automation.feature.ObsidianPressurePlate;
import vazkii.quark.automation.feature.PistonSpikes;
import vazkii.quark.building.feature.IronPlates;
import vazkii.quark.decoration.feature.GlassItemFrame;
import vazkii.quark.decoration.feature.Grate;
import vazkii.quark.tweaks.feature.GlassShards;
import vazkii.quark.world.entity.EntityArchaeologist;
import vazkii.quark.world.feature.Archaeologist;

@MethodsReturnNonnullByDefault
class TConstructQuarkIntegration
implements ITConstructIntegration {
    TConstructQuarkIntegration() {
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (QuarkUtils.isFeatureEnabled(GlassShards.class)) {
            TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipe(RecipeMatch.of((ItemStack)new ItemStack(GlassShards.glass_shard, 1, Short.MAX_VALUE), (int)250), (Fluid)TinkerFluids.glass));
        }
        if (QuarkUtils.isFeatureEnabled(GlassItemFrame.class)) {
            TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipe(RecipeMatch.of((Item)GlassItemFrame.glass_item_frame, (int)1500), (Fluid)TinkerFluids.glass));
        }
        if (QuarkUtils.isFeatureEnabled(IronPlates.class)) {
            TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipe(RecipeMatch.of((ItemStack)new ItemStack(IronPlates.iron_plate, 1, 1), (int)48), (Fluid)TinkerFluids.iron));
        }
        if (QuarkUtils.isFeatureEnabled(PistonSpikes.class)) {
            TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipe(RecipeMatch.of((Block)PistonSpikes.iron_rod, (int)288), (Fluid)TinkerFluids.iron));
        }
        if (QuarkUtils.isFeatureEnabled(Grate.class)) {
            TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipe(RecipeMatch.of((Block)Grate.grate, (int)216), (Fluid)TinkerFluids.iron));
        }
        if (QuarkUtils.isFeatureEnabled(MetalButtons.class)) {
            if (MetalButtons.enableIron) {
                TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipe(RecipeMatch.of((Block)MetalButtons.iron_button, (int)144), (Fluid)TinkerFluids.iron));
            }
            if (MetalButtons.enableGold) {
                TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipe(RecipeMatch.of((Block)MetalButtons.gold_button, (int)144), (Fluid)TinkerFluids.gold));
            }
        }
        if (QuarkUtils.isFeatureEnabled(ObsidianPressurePlate.class)) {
            TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipe(RecipeMatch.of((Block)ObsidianPressurePlate.obsidian_pressure_plate, (int)576), (Fluid)TinkerFluids.obsidian));
        }
        if (QuarkUtils.isFeatureEnabled(Archaeologist.class)) {
            TinkerRegistry.registerEntityMelting(EntityArchaeologist.class, (FluidStack)new FluidStack((Fluid)TinkerFluids.emerald, 6));
        }
    }

    @Override
    public ModIds getModId() {
        return ModIds.QUARK;
    }
}

