/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.quark;

import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.dungeontactics.DungeonTactics;
import com.github.sokyranthedragon.mia.integrations.dungeontactics.IDungeonTacticsIntegration;
import com.github.sokyranthedragon.mia.utilities.LootUtils;
import com.github.sokyranthedragon.mia.utilities.QuarkUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.world.storage.loot.functions.LootFunction;
import vazkii.quark.misc.feature.AncientTomes;
import vazkii.quark.misc.feature.ExtraArrows;
import vazkii.quark.world.block.BlockVariantLeaves;
import vazkii.quark.world.feature.Biotite;
import vazkii.quark.world.feature.Crabs;
import vazkii.quark.world.feature.Frogs;
import vazkii.quark.world.feature.TreeVariants;

class DungeonTacticsQuarkIntegration
implements IDungeonTacticsIntegration {
    DungeonTacticsQuarkIntegration() {
    }

    @Override
    public DungeonTactics.ILootBagListener registerLootBagListener() {
        return (type, loot) -> {
            switch (type) {
                case ARBOUR: {
                    if (!QuarkUtils.isFeatureEnabled(TreeVariants.class)) break;
                    if (TreeVariants.enableSakura && TreeVariants.enableSwamp) {
                        LootUtils.addDtLoot(loot, TreeVariants.variant_sapling, LootUtils.setMetadataFunction(0, 1));
                        break;
                    }
                    if (TreeVariants.enableSwamp) {
                        LootUtils.addDtLoot(loot, TreeVariants.variant_sapling, LootUtils.setMetadataFunction(BlockVariantLeaves.Variant.SWAMP_LEAVES.ordinal()));
                        break;
                    }
                    if (!TreeVariants.enableSakura) break;
                    LootUtils.addDtLoot(loot, TreeVariants.variant_sapling, LootUtils.setMetadataFunction(BlockVariantLeaves.Variant.SAKURA_LEAVES.ordinal()));
                    break;
                }
                case BOOK: {
                    if (!QuarkUtils.isFeatureEnabled(AncientTomes.class)) break;
                    try {
                        Constructor constructor = AncientTomes.EnchantTomeFunction.class.getDeclaredConstructor(new Class[0]);
                        constructor.setAccessible(true);
                        LootUtils.addDtLoot(loot, AncientTomes.ancient_tome, 1, (LootFunction)constructor.newInstance(new Object[0]));
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        Mia.LOGGER.error("Could not access Quark AncientTomes.EnchantTomeFunction constructor, it won't be added to loot bags.");
                    }
                    break;
                }
                case QUIVER: {
                    if (!QuarkUtils.isFeatureEnabled(ExtraArrows.class)) break;
                    if (ExtraArrows.enableEnder) {
                        LootUtils.addDtLoot(loot, ExtraArrows.arrow_ender, 7, LootUtils.setCountFunction(1, 16));
                    }
                    if (ExtraArrows.enableExplosive) {
                        LootUtils.addDtLoot(loot, ExtraArrows.arrow_explosive, 7, LootUtils.setCountFunction(1, 16));
                    }
                    if (!ExtraArrows.enableTorch) break;
                    LootUtils.addDtLoot(loot, ExtraArrows.arrow_torch, 7, LootUtils.setCountFunction(1, 16));
                    break;
                }
                case FOOD: {
                    if (QuarkUtils.isFeatureEnabled(Crabs.class)) {
                        LootUtils.addDtLoot(loot, (Item)Crabs.crabLeg, new LootFunction[0]);
                        LootUtils.addDtLoot(loot, (Item)Crabs.cookedCrabLeg, new LootFunction[0]);
                    }
                    if (!QuarkUtils.isFeatureEnabled(Frogs.class)) break;
                    LootUtils.addDtLoot(loot, (Item)Frogs.frogLeg, new LootFunction[0]);
                    LootUtils.addDtLoot(loot, (Item)Frogs.cookedFrogLeg, new LootFunction[0]);
                    break;
                }
                case ORE: {
                    if (!QuarkUtils.isFeatureEnabled(Biotite.class)) break;
                    LootUtils.addDtLoot(loot, Biotite.biotite_ore, new LootFunction[0]);
                }
            }
        };
    }

    @Override
    @Nonnull
    public ModIds getModId() {
        return ModIds.QUARK;
    }
}

