/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.natura;

import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.jer.IJerIntegration;
import com.github.sokyranthedragon.mia.integrations.jer.JustEnoughResources;
import com.github.sokyranthedragon.mia.integrations.jer.custom.CustomPlantEntry;
import com.github.sokyranthedragon.mia.utilities.LootTableUtils;
import com.progwml6.natura.Natura;
import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.entities.entity.monster.EntityHeatscarSpider;
import com.progwml6.natura.entities.entity.monster.EntityNitroCreeper;
import com.progwml6.natura.entities.entity.passive.EntityImp;
import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.shared.NaturaCommons;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import jeresources.api.IMobRegistry;
import jeresources.api.IPlantRegistry;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.drop.PlantDrop;
import jeresources.entry.PlantEntry;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IPlantable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
class JerNaturaIntegration
implements IJerIntegration {
    JerNaturaIntegration() {
    }

    @Override
    public void addMobs(JustEnoughResources.CustomMobTableBuilder builder) {
        if (Natura.pulseManager.isPulseLoaded("NaturaEntities")) {
            builder.add(EntityImp.LOOT_TABLE, EntityImp.class);
            builder.add(LootTableUtils.loadUniqueEmptyLootTable(), EntityNitroCreeper.class);
            if (Config.enableHeatscarSpider) {
                builder.add(EntityHeatscarSpider.LOOT_TABLE, EntityHeatscarSpider.class);
            }
        }
    }

    @Override
    public void configureMob(ResourceLocation resource, EntityLivingBase entity, @Nullable LootTableManager manager, IMobRegistry mobRegistry) {
        HashSet validBiomes = new HashSet(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
        int experienceMin = 5;
        int experienceMax = 5;
        if (entity instanceof EntityImp) {
            experienceMin = 1;
            experienceMax = 3;
        }
        mobRegistry.register(entity, LightLevel.any, experienceMin, experienceMax, (String[])validBiomes.stream().map(Biome::func_185359_l).toArray(String[]::new), resource);
    }

    @Override
    public void addPlantDrops(IPlantRegistry plantRegistry, @Nullable Collection<PlantEntry> registers) {
        if (!Natura.pulseManager.isPulseLoaded("NaturaCommons")) {
            return;
        }
        if (registers != null) {
            LinkedList<CustomPlantEntry> entries = new LinkedList<CustomPlantEntry>();
            if (Natura.pulseManager.isPulseLoaded("NaturaOverworld")) {
                registers.add(new CustomPlantEntry(NaturaOverworld.barley_seeds, NaturaOverworld.barleyCrop.func_176223_P(), new PlantDrop(NaturaCommons.barley, 1, 1), new PlantDrop(NaturaOverworld.barley_seeds, 0, 3)));
                registers.add(new CustomPlantEntry(NaturaOverworld.cotton_seeds, NaturaOverworld.cottonCrop.func_176223_P(), new PlantDrop(NaturaCommons.cotton, 1, 1), new PlantDrop(NaturaOverworld.cotton_seeds, 0, 3)));
                entries.add(new CustomPlantEntry(new ItemStack((Block)NaturaOverworld.overworldBerryBushRaspberry), NaturaOverworld.overworldBerryBushRaspberry.func_176223_P(), new PlantDrop(NaturaCommons.raspberry, 1, 1)));
                entries.add(new CustomPlantEntry(new ItemStack((Block)NaturaOverworld.overworldBerryBushBlueberry), NaturaOverworld.overworldBerryBushBlueberry.func_176223_P(), new PlantDrop(NaturaCommons.blueberry, 1, 1)));
                entries.add(new CustomPlantEntry(new ItemStack((Block)NaturaOverworld.overworldBerryBushBlackberry), NaturaOverworld.overworldBerryBushBlackberry.func_176223_P(), new PlantDrop(NaturaCommons.blackberry, 1, 1)));
                entries.add(new CustomPlantEntry(new ItemStack((Block)NaturaOverworld.overworldBerryBushMaloberry), NaturaOverworld.overworldBerryBushMaloberry.func_176223_P(), new PlantDrop(NaturaCommons.maloberry, 1, 1)));
            }
            if (Natura.pulseManager.isPulseLoaded("NaturaNether")) {
                entries.add(new CustomPlantEntry(new ItemStack((Block)NaturaNether.netherBerryBushBlightberry), NaturaNether.netherBerryBushBlightberry.func_176223_P(), new PlantDrop(NaturaCommons.blightberry, 1, 1)));
                entries.add(new CustomPlantEntry(new ItemStack((Block)NaturaNether.netherBerryBushDuskberry), NaturaNether.netherBerryBushDuskberry.func_176223_P(), new PlantDrop(NaturaCommons.duskberry, 1, 1)));
                entries.add(new CustomPlantEntry(new ItemStack((Block)NaturaNether.netherBerryBushSkyberry), NaturaNether.netherBerryBushSkyberry.func_176223_P(), new PlantDrop(NaturaCommons.skyberry, 1, 1)));
                entries.add(new CustomPlantEntry(new ItemStack((Block)NaturaNether.netherBerryBushStingberry), NaturaNether.netherBerryBushStingberry.func_176223_P(), new PlantDrop(NaturaCommons.stingberry, 1, 1)));
            }
            for (CustomPlantEntry entry : entries) {
                entry.setSoil(Blocks.field_150349_c.func_176223_P());
                registers.add(entry);
            }
        } else {
            if (Natura.pulseManager.isPulseLoaded("NaturaOverworld")) {
                plantRegistry.register(NaturaOverworld.barley_seeds, (IPlantable)NaturaOverworld.barleyCrop, new PlantDrop[]{new PlantDrop(NaturaCommons.barley, 1, 1), new PlantDrop(NaturaOverworld.barley_seeds, 0, 3)});
                plantRegistry.register(NaturaOverworld.cotton_seeds, (IPlantable)NaturaOverworld.cottonCrop, new PlantDrop[]{new PlantDrop(NaturaCommons.cotton, 1, 1), new PlantDrop(NaturaOverworld.cotton_seeds, 0, 3)});
                plantRegistry.register(new ItemStack((Block)NaturaOverworld.overworldBerryBushRaspberry), new PlantDrop[]{new PlantDrop(NaturaCommons.raspberry, 1, 1)});
                plantRegistry.register(new ItemStack((Block)NaturaOverworld.overworldBerryBushBlueberry), new PlantDrop[]{new PlantDrop(NaturaCommons.blueberry, 1, 1)});
                plantRegistry.register(new ItemStack((Block)NaturaOverworld.overworldBerryBushBlackberry), new PlantDrop[]{new PlantDrop(NaturaCommons.blackberry, 1, 1)});
                plantRegistry.register(new ItemStack((Block)NaturaOverworld.overworldBerryBushMaloberry), new PlantDrop[]{new PlantDrop(NaturaCommons.maloberry, 1, 1)});
            }
            if (Natura.pulseManager.isPulseLoaded("NaturaNether")) {
                plantRegistry.register(new ItemStack((Block)NaturaNether.netherBerryBushBlightberry), new PlantDrop[]{new PlantDrop(NaturaCommons.blightberry, 1, 1)});
                plantRegistry.register(new ItemStack((Block)NaturaNether.netherBerryBushDuskberry), new PlantDrop[]{new PlantDrop(NaturaCommons.duskberry, 1, 1)});
                plantRegistry.register(new ItemStack((Block)NaturaNether.netherBerryBushSkyberry), new PlantDrop[]{new PlantDrop(NaturaCommons.skyberry, 1, 1)});
                plantRegistry.register(new ItemStack((Block)NaturaNether.netherBerryBushStingberry), new PlantDrop[]{new PlantDrop(NaturaCommons.stingberry, 1, 1)});
            }
        }
    }

    @Override
    public ModIds getModId() {
        return ModIds.NATURA;
    }
}

