/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.natura;

import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.dungeontactics.DungeonTactics;
import com.github.sokyranthedragon.mia.integrations.dungeontactics.IDungeonTacticsIntegration;
import com.github.sokyranthedragon.mia.utilities.LootUtils;
import com.progwml6.natura.Natura;
import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.shared.NaturaCommons;
import com.progwml6.natura.tools.NaturaTools;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.world.storage.loot.functions.LootFunction;

@MethodsReturnNonnullByDefault
class DungeonTacticsNaturaIntegration
implements IDungeonTacticsIntegration {
    DungeonTacticsNaturaIntegration() {
    }

    @Override
    @Nullable
    public DungeonTactics.ILootBagListener registerLootBagListener() {
        return (type, loot) -> {
            switch (type) {
                case ARBOUR: {
                    if (Natura.pulseManager.isPulseLoaded("NaturaOverworld")) {
                        LootUtils.addDtLoot(loot, (Block)NaturaOverworld.overworldLog, LootUtils.setMetadataFunction(0, 3));
                        LootUtils.addDtLoot(loot, (Block)NaturaOverworld.overworldLog2, LootUtils.setMetadataFunction(0, 3));
                        LootUtils.addDtLoot(loot, (Block)NaturaOverworld.redwoodLog, LootUtils.setMetadataFunction(0, 2));
                        LootUtils.addDtLoot(loot, (Block)NaturaOverworld.overworldSapling, LootUtils.setMetadataFunction(0, 3));
                        LootUtils.addDtLoot(loot, (Block)NaturaOverworld.overworldSapling2, LootUtils.setMetadataFunction(0, 3));
                        if (Config.generateRedwood) {
                            LootUtils.addDtLoot(loot, (Block)NaturaOverworld.redwoodSapling, 1, new LootFunction[0]);
                        }
                    }
                    if (!Natura.pulseManager.isPulseLoaded("NaturaNether")) break;
                    LootUtils.addDtLoot(loot, (Block)NaturaNether.netherLog, LootUtils.setMetadataFunction(0, 2));
                    LootUtils.addDtLoot(loot, (Block)NaturaNether.netherLog2, new LootFunction[0]);
                    LootUtils.addDtLoot(loot, (Block)NaturaNether.netherSapling, LootUtils.setMetadataFunction(0, 2));
                    LootUtils.addDtLoot(loot, (Block)NaturaNether.netherSapling2, new LootFunction[0]);
                    break;
                }
                case FOOD: {
                    if (!Natura.pulseManager.isPulseLoaded("NaturaCommons")) break;
                    if (Natura.pulseManager.isPulseLoaded("NaturaEntities")) {
                        LootUtils.addDtLoot(loot, (Item)NaturaCommons.edibles, "_imp_meat_raw", 4, LootUtils.setMetadataFunction(0));
                        LootUtils.addDtLoot(loot, (Item)NaturaCommons.edibles, "_imp_meat_cooked", 4, LootUtils.setMetadataFunction(1));
                    }
                    if (Natura.pulseManager.isPulseLoaded("NaturaOverworld")) {
                        LootUtils.addDtLoot(loot, (Item)NaturaOverworld.saguaroFruitItem, new LootFunction[0]);
                        LootUtils.addDtLoot(loot, (Item)NaturaCommons.soups, "_berry_medley", LootUtils.setMetadataFunction(9));
                        LootUtils.addDtLoot(loot, (Item)NaturaCommons.edibles, "_overworld_berries", LootUtils.setMetadataFunction(2, 5));
                    }
                    if (Natura.pulseManager.isPulseLoaded("NaturaNether")) {
                        LootUtils.addDtLoot(loot, (Item)NaturaCommons.edibles, "_nether_berries", 4, LootUtils.setMetadataFunction(6, 9));
                        LootUtils.addDtLoot(loot, (Item)NaturaCommons.edibles, "_potash_apple", 4, LootUtils.setMetadataFunction(10));
                        LootUtils.addDtLoot(loot, (Item)NaturaCommons.soups, "_glowshroom_soup", 4, LootUtils.setMetadataFunction(4, 8));
                    }
                    LootUtils.addDtLoot(loot, (Item)NaturaCommons.edibles, "_cactus_juice", LootUtils.setMetadataFunction(11));
                    break;
                }
                case TOOL: {
                    if (!Natura.pulseManager.isPulseLoaded("NaturaTools") || !Natura.pulseManager.isPulseLoaded("NaturaNether")) break;
                    LootUtils.addDtLoot(loot, NaturaTools.flintAndBlaze, 2, new LootFunction[0]);
                }
            }
        };
    }

    @Override
    public ModIds getModId() {
        return ModIds.NATURA;
    }
}

