/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.jer;

import com.github.sokyranthedragon.mia.integrations.base.IModIntegration;
import com.github.sokyranthedragon.mia.integrations.jer.JustEnoughResources;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import jeresources.api.IDungeonRegistry;
import jeresources.api.IMobRegistry;
import jeresources.api.IPlantRegistry;
import jeresources.api.conditionals.LightLevel;
import jeresources.entry.MobEntry;
import jeresources.entry.PlantEntry;
import jeresources.entry.VillagerEntry;
import jeresources.registry.VillagerRegistry;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableManager;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface IJerIntegration
extends IModIntegration {
    default public void addMobs(JustEnoughResources.CustomMobTableBuilder builder) {
    }

    default public void configureMob(ResourceLocation resource, EntityLivingBase entity, @Nullable LootTableManager manager, IMobRegistry mobRegistry) {
        int min = 1;
        int max = 3;
        if (entity instanceof EntityMob) {
            max = 5;
            min = 5;
        } else if (!(entity instanceof EntityAnimal)) {
            max = 0;
            min = 0;
        }
        mobRegistry.register(entity, LightLevel.any, min, max, resource);
    }

    default public void overrideExistingMobDrops(MobEntry mobEntry) {
    }

    default public void addMobRenderHooks(IMobRegistry mobRegistry) {
    }

    default public void addDungeonLoot(IDungeonRegistry dungeonRegistry, World world) {
    }

    default public void addPlantDrops(IPlantRegistry plantRegistry, @Nullable Collection<PlantEntry> registers) {
    }

    default public void addVillagerTrades(VillagerRegistry villagerRegistry, boolean acceptsCustomEntries) {
    }

    default public void overrideExistingVillagerTrades(VillagerEntry villagerEntry) {
    }
}

