/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.jei.categories.cauldron;

import com.github.sokyranthedragon.mia.integrations.jei.categories.cauldron.CauldronCategory;
import com.github.sokyranthedragon.mia.integrations.jei.categories.cauldron.CauldronEntry;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.config.GuiUtils;

public class CauldronWrapper
implements IRecipeWrapper,
ITooltipCallback<ItemStack> {
    private final CauldronEntry entry;

    public CauldronWrapper(CauldronEntry entry) {
        this.entry = entry;
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setOutputs(VanillaTypes.ITEM, (List)Lists.newArrayList((Object[])new ItemStack[]{this.entry.getOutput(), this.entry.getByproduct()}));
        if (this.entry instanceof CauldronEntry.CauldronFluidEntry) {
            ingredients.setOutput(VanillaTypes.FLUID, (Object)((CauldronEntry.CauldronFluidEntry)this.entry).getTrueOutput());
        }
        ingredients.setInputs(VanillaTypes.ITEM, this.entry.getInputs());
        if (this.entry.getPossibleFluids() == CauldronEntry.PossibleFluids.Water || this.entry.getPossibleFluids() == CauldronEntry.PossibleFluids.Lava) {
            ingredients.setInput(VanillaTypes.FLUID, (Object)this.entry.getFluid());
        }
    }

    public CauldronEntry getEntry() {
        return this.entry;
    }

    @ParametersAreNonnullByDefault
    public void onTooltip(int i, boolean b, ItemStack itemStack, List<String> list) {
        if (i == 0) {
            if (this.entry instanceof CauldronEntry.SimpleCauldronCookingEntry) {
                CauldronEntry.SimpleCauldronCookingEntry entry = (CauldronEntry.SimpleCauldronCookingEntry)this.entry;
                if (entry.getMaxOutput() > entry.getOutput().func_190916_E()) {
                    list.add(I18n.func_135052_a((String)"mia.jei.cauldron_drop_range", (Object[])new Object[]{entry.getOutput().func_190916_E(), entry.getMaxOutput()}));
                } else {
                    list.add(I18n.func_135052_a((String)"mia.jei.cauldron_drop", (Object[])new Object[]{entry.getMaxOutput()}));
                }
            } else if (this.entry instanceof CauldronEntry.CauldronImbuingEntry) {
                list.add(I18n.func_135052_a((String)"mia.jei.cauldron_imbuing", (Object[])new Object[0]));
            }
        } else if (i == 6) {
            list.clear();
            list.add("Cannot contain water!");
        }
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.entry instanceof CauldronEntry.CauldronObsidianEntry) {
            minecraft.func_110434_K().func_110577_a(CauldronCategory.BACKGROUND.getResource());
            GuiUtils.drawTexturedModalRect((int)20, (int)47, (int)0, (int)59, (int)14, (int)14, (float)0.0f);
        }
    }
}

