/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.industrialforegoing;

import com.buuz135.industrial.api.IndustrialForegoingHelper;
import com.buuz135.industrial.api.extractor.ExtractorEntry;
import com.buuz135.industrial.api.recipe.LaserDrillEntry;
import com.buuz135.industrial.api.recipe.ProteinReactorEntry;
import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.tile.misc.FrosterTile;
import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.config.IndustrialForegoingConfiguration;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.base.IBaseMod;
import com.github.sokyranthedragon.mia.integrations.base.IModIntegration;
import com.github.sokyranthedragon.mia.integrations.industrialforegoing.IIndustrialForegoingIntegration;
import com.github.sokyranthedragon.mia.integrations.industrialforegoing.JeiIndustrialForegoingIntegration;
import com.github.sokyranthedragon.mia.integrations.industrialforegoing.JerIndustrialForegoingIntegration;
import jackyy.integrationforegoing.util.Reference;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.util.TriConsumer;

public class IndustrialForegoing
implements IBaseMod {
    private final List<IIndustrialForegoingIntegration> modIntegrations = new LinkedList<IIndustrialForegoingIntegration>();
    final List<ItemStack> registeredFrosterItems = new LinkedList<ItemStack>();

    @Override
    public void register(BiConsumer<ModIds, IModIntegration> modIntegration) {
        if (!Loader.isModLoaded((String)"integrationforegoing")) {
            Mia.LOGGER.warn("Integration Foregoing is not detected - integrations in MIA were created with Integration Foregoing in mind, and therefore they might feel incomplete otherwise. It's highly recommended to install it as well!");
        }
        if (ModIds.JEI.isLoaded) {
            modIntegration.accept(ModIds.JEI, new JeiIndustrialForegoingIntegration(this));
        }
        if (ModIds.JER.isLoaded) {
            modIntegration.accept(ModIds.JER, new JerIndustrialForegoingIntegration());
        }
    }

    @Override
    public void addIntegration(IModIntegration integration) {
        if (integration instanceof IIndustrialForegoingIntegration) {
            this.modIntegrations.add((IIndustrialForegoingIntegration)integration);
        } else {
            Mia.LOGGER.warn("Incorrect Industrial Foregoing integration with id of " + (Object)((Object)integration.getModId()) + ": " + integration.toString());
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (!this.modIntegrations.isEmpty()) {
            ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Industrial Foregoing preInit", (int)this.modIntegrations.size());
            for (IIndustrialForegoingIntegration integration : this.modIntegrations) {
                progressBar.step(integration.getModId().modId);
                if (IndustrialForegoingConfiguration.enableLaserDrillEntries && integration.loadLaserDrillEntries()) {
                    LaserDrillEntry.addOreFile((ResourceLocation)new ResourceLocation(ModIds.MIA.modId, integration.getModId().modId + "_ores.json"));
                    continue;
                }
                IndustrialForegoing.deleteExistingLaserDrillFile(event.getModConfigurationDirectory(), integration.getModId().modId + "_ores.json");
            }
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (!this.modIntegrations.isEmpty()) {
            ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Industrial Foregoing init", (int)this.modIntegrations.size());
            for (IIndustrialForegoingIntegration integration : this.modIntegrations) {
                progressBar.step(integration.getModId().modId);
                if (IndustrialForegoingConfiguration.enableFrosterRecipes && BlockRegistry.frosterBlock.isEnabled()) {
                    integration.addFrosterRecipe((TriConsumer<String, ItemStack, Integer>)((TriConsumer)(name, item, value) -> {
                        if (!item.func_190926_b() && value >= 0 && value <= 8000) {
                            EnumHelper.addEnum(FrosterTile.FrosterResult.class, (String)name, (Class[])new Class[]{ItemStack.class, Integer.TYPE}, (Object[])new Object[]{item, value});
                            this.registeredFrosterItems.add((ItemStack)item);
                        } else {
                            Mia.LOGGER.warn("Incorrect Froster entry, liquid= " + value + ", item=" + item);
                        }
                    }));
                }
                if (IndustrialForegoingConfiguration.enableProteinGeneratorEntries) {
                    for (ItemStack itemStack : integration.getBasicProteinGeneratorEntries()) {
                        IndustrialForegoingHelper.addProteinReactorEntry((ProteinReactorEntry)new ProteinReactorEntry(itemStack));
                    }
                }
                if (IndustrialForegoingConfiguration.enableLogLatexEntries) {
                    for (ItemStack itemStack : integration.getLatexEntries()) {
                        IndustrialForegoingHelper.addWoodToLatex((ExtractorEntry)itemStack);
                    }
                }
                integration.addGenericIntegrations();
            }
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        if (!this.modIntegrations.isEmpty()) {
            ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Industrial Foregoing postInit", (int)this.modIntegrations.size());
            for (IIndustrialForegoingIntegration integration : this.modIntegrations) {
                progressBar.step(integration.getModId().modId);
                integration.addPostInitRecipes();
            }
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        }
    }

    private static void deleteExistingLaserDrillFile(File dir, String fileName) {
        Path path = dir.toPath().resolve("laser_drill_ores");
        if (Files.exists(path, new LinkOption[0])) {
            File file = new File(path.toFile(), fileName + "_ores.json");
            if (!file.exists()) {
                return;
            }
            if (file.delete()) {
                Reference.LOGGER.info("Deleted existing Laser Drill config file " + file.getName());
            }
        }
    }
}

