/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.dungeontactics;

import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.jei.IJeiIntegration;
import com.github.sokyranthedragon.mia.integrations.jei.categories.cauldron.CauldronCategory;
import com.github.sokyranthedragon.mia.integrations.jei.categories.cauldron.CauldronEntry;
import com.github.sokyranthedragon.mia.integrations.jei.categories.cauldron.CauldronRegistry;
import com.github.sokyranthedragon.mia.integrations.jei.categories.cauldron.CauldronWrapper;
import com.github.sokyranthedragon.mia.integrations.jei.categories.lootbag.LootBagCategory;
import com.github.sokyranthedragon.mia.integrations.jei.categories.lootbag.LootBagEntry;
import com.github.sokyranthedragon.mia.integrations.jei.categories.lootbag.LootBagRegistry;
import com.github.sokyranthedragon.mia.integrations.jei.categories.lootbag.LootBagWrapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import pegbeard.dungeontactics.handlers.DTBlocks;
import pegbeard.dungeontactics.handlers.DTEffects;
import pegbeard.dungeontactics.handlers.DTItems;
import pegbeard.dungeontactics.handlers.DTLoots;

class JeiDungeonTacticsIntegration
implements IJeiIntegration {
    JeiDungeonTacticsIntegration() {
    }

    @Override
    @ParametersAreNonnullByDefault
    public void register(IModRegistry registry, Collection<String> registeredCategories) {
        if (registeredCategories.add("mia.alchemical_cauldron")) {
            registry.handleRecipes(CauldronEntry.class, CauldronWrapper::new, "mia.alchemical_cauldron");
            registry.addRecipes(CauldronRegistry.getRecipesOrEmpty(), "mia.alchemical_cauldron");
        }
        if (registeredCategories.add("mia.loot_bag")) {
            registry.handleRecipes(LootBagEntry.class, LootBagWrapper::new, "mia.loot_bag");
            registry.addRecipes(LootBagRegistry.getRecipesOrEmpty(), "mia.loot_bag");
        }
        registry.addRecipeCatalyst((Object)new ItemStack(DTBlocks.ALCHEMYCAULDRON), new String[]{"mia.alchemical_cauldron"});
        registry.addRecipeCatalyst((Object)new ItemStack(DTItems.BAG_ARBOUR), new String[]{"mia.loot_bag"});
        registry.addRecipeCatalyst((Object)new ItemStack(DTItems.BAG_BOOK), new String[]{"mia.loot_bag"});
        registry.addRecipeCatalyst((Object)new ItemStack(DTItems.BAG_FOOD), new String[]{"mia.loot_bag"});
        registry.addRecipeCatalyst((Object)new ItemStack(DTItems.BAG_MAGIC), new String[]{"mia.loot_bag"});
        registry.addRecipeCatalyst((Object)new ItemStack(DTItems.BAG_ORE), new String[]{"mia.loot_bag"});
        registry.addRecipeCatalyst((Object)new ItemStack(DTItems.BAG_POTION), new String[]{"mia.loot_bag"});
        registry.addRecipeCatalyst((Object)new ItemStack(DTItems.BAG_QUIVER), new String[]{"mia.loot_bag"});
        registry.addRecipeCatalyst((Object)new ItemStack(DTItems.BAG_RECORD), new String[]{"mia.loot_bag"});
        registry.addRecipeCatalyst((Object)new ItemStack(DTItems.BAG_SAMHAIN), new String[]{"mia.loot_bag"});
        registry.addRecipeCatalyst((Object)new ItemStack(DTItems.BAG_SOLSTICE), new String[]{"mia.loot_bag"});
        registry.addRecipeCatalyst((Object)new ItemStack(DTItems.BAG_TOOL), new String[]{"mia.loot_bag"});
        registry.addIngredientInfo(Arrays.asList(new ItemStack(DTItems.FISH_MUSCLE), new ItemStack(DTItems.FISH_OBSIDIAN), new ItemStack(DTItems.FISH_LAVA), new ItemStack(DTItems.FISH_TUNNEL), new ItemStack(DTItems.FISH_FLYING), new ItemStack(DTItems.FISH_SWIFT), new ItemStack(DTItems.FISH_LUNG)), VanillaTypes.ITEM, new String[]{"mia.jei.info.dt.fishing"});
        registry.addIngredientInfo(Arrays.asList(new ItemStack(DTItems.SLINGSHOT), new ItemStack(DTItems.IRONRING)), VanillaTypes.ITEM, new String[]{"mia.jei.info.dt.fishing_treasure"});
        registry.addIngredientInfo((Object)new ItemStack(DTItems.REXO_LEGGINGS), VanillaTypes.ITEM, new String[]{"mia.jei.dt.info.leggings"});
        registry.addIngredientInfo((Object)new ItemStack(DTItems.REXO_GOGGLES), VanillaTypes.ITEM, new String[]{"mia.jei.dt.info.goggles"});
        registry.addIngredientInfo((Object)new ItemStack(DTItems.REXO_BOOTS), VanillaTypes.ITEM, new String[]{"mia.jei.dt.info.boots"});
        registry.addIngredientInfo((Object)new ItemStack(DTItems.ESCAPEROPE), VanillaTypes.ITEM, new String[]{"mia.jei.dt.info.rope"});
        registry.addIngredientInfo((Object)new ItemStack(DTItems.PHYLACTERY), VanillaTypes.ITEM, new String[]{"mia.jei.dt.info.phylactery"});
        registry.addIngredientInfo((Object)new ItemStack(DTItems.ENDERBAG), VanillaTypes.ITEM, new String[]{"mia.jei.dt.info.bag_of_hoarding"});
        registry.addIngredientInfo((Object)new ItemStack(DTItems.DUCT_TAPE), VanillaTypes.ITEM, new String[]{"mia.jei.dt.info.duct_tape"});
        registry.addIngredientInfo((Object)new ItemStack(DTItems.HEART_DROP), VanillaTypes.ITEM, new String[]{"mia.jei.dt.info.heart_drop"});
        registry.addIngredientInfo((Object)new ItemStack(DTBlocks.LANTERN_IRON), VanillaTypes.ITEM, new String[]{"mia.jei.dt.info.lantern_iron"});
        registry.addIngredientInfo((Object)new ItemStack(DTBlocks.LANTERN_MAGIC), VanillaTypes.ITEM, new String[]{"mia.jei.dt.info.lantern_magic"});
        registry.addIngredientInfo((Object)new ItemStack(DTItems.ENGINEERS_DUNGAREES), VanillaTypes.ITEM, new String[]{"mia.jei.dt.info.engineer_pants"});
        registry.addIngredientInfo((Object)new ItemStack(DTItems.PEG_HAMMER), VanillaTypes.ITEM, new String[]{"mia.jei.dt.info.peg_hammer"});
    }

    @Override
    @ParametersAreNonnullByDefault
    public void registerCategories(IRecipeCategoryRegistration registry, Collection<String> registeredCategories) {
        if (registeredCategories.add("mia.alchemical_cauldron")) {
            registry.addRecipeCategories(new IRecipeCategory[]{new CauldronCategory(registry.getJeiHelpers().getGuiHelper())});
        }
        if (registeredCategories.add("mia.loot_bag")) {
            registry.addRecipeCategories(new IRecipeCategory[]{new LootBagCategory(registry.getJeiHelpers().getGuiHelper(), DTItems.BAG_ARBOUR)});
        }
    }

    @Override
    public void registerRecipes() {
        CauldronRegistry cauldronRegistry = CauldronRegistry.getInstance();
        if (cauldronRegistry != null) {
            this.registerImbuing(cauldronRegistry, Items.field_151040_l, DTEffects.POISONAILMENT, new ItemStack(DTBlocks.FLOWER_AILMENT));
            this.registerImbuing(cauldronRegistry, Items.field_151040_l, DTEffects.POISONBARK, new ItemStack(DTBlocks.FLOWER_BARK));
            this.registerImbuing(cauldronRegistry, Items.field_151040_l, DTEffects.POISONBRAMBLE, new ItemStack(DTBlocks.FLOWER_BRAMBLE));
            this.registerImbuing(cauldronRegistry, Items.field_151040_l, DTEffects.POISONCINDER, new ItemStack(DTBlocks.FLOWER_CINDER));
            this.registerImbuing(cauldronRegistry, Items.field_151040_l, DTEffects.POISONFADE, new ItemStack(DTBlocks.FLOWER_FADE));
            this.registerImbuing(cauldronRegistry, Items.field_151040_l, DTEffects.POISONFEATHER, new ItemStack(DTBlocks.FLOWER_FEATHER));
            this.registerImbuing(cauldronRegistry, Items.field_151040_l, DTEffects.POISONSANGUINE, new ItemStack(DTBlocks.FLOWER_SANGUINE));
            this.registerImbuing(cauldronRegistry, Items.field_151040_l, DTEffects.POISONTANGLE, new ItemStack(DTBlocks.FLOWER_TANGLE));
            this.registerCooking(cauldronRegistry, Items.field_151037_a, Items.field_151016_H, new ItemStack(DTItems.CHERRYBOMB, 4), new ItemStack(Items.field_151137_ax, 4), new ItemStack(Items.field_151145_ak));
            this.registerCooking(cauldronRegistry, Items.field_151037_a, Items.field_151114_aO, new ItemStack(DTItems.GLOWCURRENT, 4), new ItemStack(Items.field_151137_ax, 4), new ItemStack(Items.field_151065_br));
            this.registerCooking(cauldronRegistry, Items.field_151037_a, Items.field_151065_br, new ItemStack(DTItems.INCINDIBERRY, 4), new ItemStack(Items.field_151137_ax, 4), new ItemStack(Items.field_151044_h));
            this.registerCooking(cauldronRegistry, Items.field_151037_a, DTItems.MAGIC_POWDER, 3, new ItemStack(Items.field_151114_aO), new ItemStack((Block)Blocks.field_150337_Q), new ItemStack((Block)Blocks.field_150338_P));
            this.registerCooking(cauldronRegistry, Items.field_151037_a, new ItemStack(Items.field_151119_aD, 4), new ItemStack(Items.field_151123_aH, 3), new ItemStack((Block)Blocks.field_150354_m));
            this.registerCooking(cauldronRegistry, Items.field_151037_a, Items.field_151116_aA, Items.field_151123_aH, new ItemStack(Items.field_151078_bh, 3), new ItemStack(Items.field_151102_aT, 2));
            this.registerCooking(cauldronRegistry, Items.field_151037_a, new ItemStack(Blocks.field_150346_d), new ItemStack(Items.field_151119_aD), new ItemStack((Block)Blocks.field_150362_t, 2, Short.MAX_VALUE), new ItemStack((Block)Blocks.field_150354_m));
            this.registerCooking(cauldronRegistry, Items.field_151037_a, new ItemStack((Block)Blocks.field_150391_bh), new ItemStack(Blocks.field_150346_d), new ItemStack((Block)Blocks.field_150337_Q, 2), new ItemStack((Block)Blocks.field_150338_P, 2));
            cauldronRegistry.registerCauldronRecipe(new CauldronEntry.CauldronFluidEntry(new ItemStack(Items.field_151037_a), CauldronEntry.PossibleFluids.Any, FluidRegistry.getFluidStack((String)"lava", (int)1000), new ItemStack(DTItems.INCINDIBERRY, 7), new ItemStack(Blocks.field_189877_df)));
            cauldronRegistry.registerCauldronRecipe(new CauldronEntry.CauldronCookingEntry(new ItemStack(Items.field_151037_a), CauldronEntry.PossibleFluids.NoWater, new ItemStack(DTItems.HEART_GOLDEN), ItemStack.field_190927_a, new ItemStack[]{new ItemStack(DTItems.HEART_JAR), new ItemStack(Items.field_151074_bl, 2), new ItemStack(Items.field_151114_aO, 2)}));
            cauldronRegistry.registerCauldronRecipe(new CauldronEntry.CauldronObsidianEntry(false));
            cauldronRegistry.registerCauldronRecipe(new CauldronEntry.CauldronObsidianEntry(true));
        } else {
            Mia.LOGGER.error("Could not access Alchemical Cauldron recipe registry, this shouldn't have happened as Dungeon Tactics is loaded. Something is very wrong.");
        }
        LootBagRegistry lootBagRegistry = LootBagRegistry.getInstance();
        if (lootBagRegistry != null) {
            this.registerLootBag(lootBagRegistry, DTItems.BAG_ARBOUR, DTLoots.ARBOUR_LOOT);
            this.registerLootBag(lootBagRegistry, DTItems.BAG_BOOK, DTLoots.BOOK_LOOT);
            this.registerLootBag(lootBagRegistry, DTItems.BAG_FOOD, DTLoots.FOOD_LOOT);
            this.registerLootBag(lootBagRegistry, DTItems.BAG_MAGIC, DTLoots.MAGIC_LOOT);
            this.registerLootBag(lootBagRegistry, DTItems.BAG_ORE, DTLoots.ORE_LOOT);
            this.registerLootBag(lootBagRegistry, DTItems.BAG_POTION, DTLoots.POTION_LOOT);
            this.registerLootBag(lootBagRegistry, DTItems.BAG_QUIVER, DTLoots.QUIVER_LOOT);
            this.registerLootBag(lootBagRegistry, DTItems.BAG_RECORD, DTLoots.RECORD_LOOT);
            this.registerLootBag(lootBagRegistry, DTItems.BAG_SAMHAIN, DTLoots.SAMHAIN_LOOT);
            this.registerLootBag(lootBagRegistry, DTItems.BAG_SOLSTICE, DTLoots.SOLSTICE_LOOT);
            this.registerLootBag(lootBagRegistry, DTItems.BAG_TOOL, DTLoots.TOOL_LOOT);
        } else if (ModIds.JER.isLoaded) {
            Mia.LOGGER.error("Could not access Loot Bag recipe registry, this shouldn't have happened as Dungeon Tactics and JER are loaded. Something is very wrong.");
        }
    }

    @Override
    @Nonnull
    public ModIds getModId() {
        return ModIds.DUNGEON_TACTICS;
    }

    private void registerImbuing(CauldronRegistry registry, Item weapon, Enchantment enchantment, ItemStack ... input) {
        registry.registerCauldronRecipe(new CauldronEntry.CauldronImbuingEntry(new ItemStack(weapon), enchantment, input));
    }

    private void registerCooking(CauldronRegistry registry, Item spoon, Item output, ItemStack ... input) {
        this.registerCooking(registry, spoon, output, null, 1, input);
    }

    private void registerCooking(CauldronRegistry registry, Item spoon, Item output, int max, ItemStack ... input) {
        this.registerCooking(registry, spoon, output, null, max, input);
    }

    private void registerCooking(CauldronRegistry registry, Item spoon, ItemStack output, ItemStack ... input) {
        this.registerCooking(registry, spoon, output, null, 1, input);
    }

    private void registerCooking(CauldronRegistry registry, Item spoon, ItemStack output, int max, ItemStack ... input) {
        this.registerCooking(registry, spoon, output, null, max, input);
    }

    private void registerCooking(CauldronRegistry registry, Item spoon, Item output, Item byproduct, ItemStack ... input) {
        this.registerCooking(registry, spoon, new ItemStack(output), byproduct, 1, input);
    }

    private void registerCooking(CauldronRegistry registry, Item spoon, Item output, Item byproduct, int max, ItemStack ... input) {
        this.registerCooking(registry, spoon, new ItemStack(output), byproduct, max, input);
    }

    private void registerCooking(CauldronRegistry registry, Item spoon, ItemStack output, Item byproduct, int max, ItemStack ... input) {
        if (byproduct != null) {
            registry.registerCauldronRecipe(new CauldronEntry.SimpleCauldronCookingEntry(new ItemStack(spoon), output, new ItemStack(byproduct), max, input));
        } else {
            registry.registerCauldronRecipe(new CauldronEntry.SimpleCauldronCookingEntry(new ItemStack(spoon), output, max, input));
        }
    }

    private void registerLootBag(LootBagRegistry registry, Item lootBag, ResourceLocation possibleLoot) {
        List<LootBagEntry> entries = LootBagEntry.getEntries(new ItemStack(lootBag), possibleLoot);
        for (LootBagEntry entry : entries) {
            registry.registerLootBagRecipe(entry);
        }
    }
}

