/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.charm;

import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.jer.IJerIntegration;
import com.github.sokyranthedragon.mia.integrations.jer.JerLightHelper;
import com.github.sokyranthedragon.mia.integrations.jer.JustEnoughResources;
import java.util.List;
import javax.annotation.Nullable;
import jeresources.api.IDungeonRegistry;
import jeresources.api.IMobRegistry;
import jeresources.api.conditionals.Conditional;
import jeresources.api.drop.LootDrop;
import jeresources.entry.MobEntry;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.LootTableManager;
import org.jetbrains.annotations.NotNull;
import svenhjol.charm.Charm;
import svenhjol.charm.base.CharmLootTables;
import svenhjol.charm.brewing.potion.DecayPotion;
import svenhjol.charm.crafting.feature.Barrel;
import svenhjol.charm.crafting.feature.BookshelfChest;
import svenhjol.charm.crafting.feature.Composter;
import svenhjol.charm.tweaks.feature.WitchesDropDecay;
import svenhjol.charm.tweaks.feature.WitchesDropLuck;
import svenhjol.charm.world.compat.FutureMcBlocks;
import svenhjol.charm.world.entity.EntitySpectre;
import svenhjol.charm.world.feature.AbandonedCrates;
import svenhjol.charm.world.feature.Spectre;
import svenhjol.charm.world.feature.SwampHutDecorations;
import svenhjol.charm.world.feature.VillageDecorations;
import svenhjol.meson.helper.LootHelper;

class JerCharmIntegration
implements IJerIntegration {
    JerCharmIntegration() {
    }

    @Override
    public void addMobs(@NotNull JustEnoughResources.CustomMobTableBuilder builder) {
        if (Charm.hasFeature(Spectre.class)) {
            builder.add(EntitySpectre.LOOT_TABLE, EntitySpectre.class);
        }
    }

    @Override
    public void configureMob(@NotNull ResourceLocation resource, @NotNull EntityLivingBase entity, @Nullable LootTableManager manager, @NotNull IMobRegistry mobRegistry) {
        if (entity instanceof EntitySpectre) {
            mobRegistry.register(entity, JerLightHelper.getLightLevelBelow(Spectre.despawnLight), 5, resource);
        }
    }

    @Override
    public void overrideExistingMobDrops(@NotNull MobEntry mobEntry) {
        if (mobEntry.getEntity() instanceof EntityWitch) {
            ItemStack item;
            if (Charm.hasFeature(WitchesDropDecay.class)) {
                item = new ItemStack((Item)Items.field_151068_bn);
                PotionType decay = DecayPotion.type;
                PotionUtils.func_185188_a((ItemStack)item, (PotionType)decay);
                mobEntry.addDrop(new LootDrop(item, 0, 1, (float)WitchesDropDecay.dropChance, 0, new Conditional[]{Conditional.affectedByLooting}));
            }
            if (Charm.hasFeature(WitchesDropLuck.class)) {
                item = new ItemStack((Item)Items.field_151068_bn);
                PotionType luck = (PotionType)PotionType.field_185176_a.func_82594_a((Object)new ResourceLocation("luck"));
                PotionUtils.func_185188_a((ItemStack)item, (PotionType)luck);
                mobEntry.addDrop(new LootDrop(item, 0, 1, (float)WitchesDropLuck.dropChance, 0, new Conditional[]{Conditional.affectedByLooting}));
            }
        }
    }

    @Override
    public void addDungeonLoot(@NotNull IDungeonRegistry dungeonRegistry, @NotNull World world) {
        List tables;
        if (Charm.hasFeature(VillageDecorations.class)) {
            if (VillageDecorations.storage) {
                String butcher = "chests/charm_butcher";
                String carpenter = "chests/charm_carpenter";
                String fisherman = "chests/charm_fisherman";
                String librarian = "chests/charm_librarian";
                String priest = "chests/charm_priest";
                String shepherd = "chests/charm_shepherd";
                String smith = "chests/charm_smith";
                dungeonRegistry.registerCategory("chests/charm_butcher", "mia.jer.dungeon.charm_butcher");
                dungeonRegistry.registerCategory("chests/charm_carpenter", "mia.jer.dungeon.charm_carpenter");
                dungeonRegistry.registerCategory("chests/charm_fisherman", "mia.jer.dungeon.charm_fisherman");
                dungeonRegistry.registerCategory("chests/charm_librarian", "mia.jer.dungeon.charm_librarian");
                dungeonRegistry.registerCategory("chests/charm_priest", "mia.jer.dungeon.charm_priest");
                dungeonRegistry.registerCategory("chests/charm_shepherd", "mia.jer.dungeon.charm_shepherd");
                dungeonRegistry.registerCategory("chests/charm_smith", "mia.jer.dungeon.charm_smith");
                dungeonRegistry.registerChest("chests/charm_butcher", CharmLootTables.VILLAGE_BUTCHER);
                dungeonRegistry.registerChest("chests/charm_carpenter", CharmLootTables.VILLAGE_CARPENTER);
                dungeonRegistry.registerChest("chests/charm_fisherman", CharmLootTables.VILLAGE_FISHERMAN);
                if (Charm.hasFeature(BookshelfChest.class)) {
                    for (ResourceLocation loot : LootHelper.getLootTables((LootHelper.RARITY)LootHelper.RARITY.COMMON, (LootHelper.TYPE)LootHelper.TYPE.BOOK)) {
                        dungeonRegistry.registerChest("chests/charm_librarian", loot);
                    }
                }
                dungeonRegistry.registerChest("chests/charm_librarian", CharmLootTables.VILLAGE_LIBRARIAN);
                dungeonRegistry.registerChest("chests/charm_librarian", LootTableList.field_186426_h);
                dungeonRegistry.registerChest("chests/charm_librarian", LootTableList.field_191192_o);
                dungeonRegistry.registerChest("chests/charm_priest", CharmLootTables.VILLAGE_PRIEST);
                dungeonRegistry.registerChest("chests/charm_priest", LootTableList.field_186427_i);
                dungeonRegistry.registerChest("chests/charm_shepherd", CharmLootTables.VILLAGE_SHEPHERD);
                dungeonRegistry.registerChest("chests/charm_smith", CharmLootTables.VILLAGE_SMITH);
                dungeonRegistry.registerChest("chests/charm_smith", LootTableList.field_186424_f);
            }
            if (VillageDecorations.barrelsChance > 0.0 && (Charm.hasFeature(Barrel.class) || FutureMcBlocks.barrel != null && Charm.hasFeature(Composter.class))) {
                String farmer = "chests/charm_farmer";
                dungeonRegistry.registerCategory("chests/charm_farmer", "mia.jer.dungeon.charm_farmer");
                dungeonRegistry.registerChest("chests/charm_farmer", CharmLootTables.VILLAGE_FARMER);
            }
        }
        if (Charm.hasFeature(SwampHutDecorations.class) && !(tables = LootHelper.getLootTables((LootHelper.RARITY)LootHelper.RARITY.COMMON, (LootHelper.TYPE)LootHelper.TYPE.POTION)).isEmpty()) {
            String swampHut = "chests/charm_swamp_hut";
            dungeonRegistry.registerCategory("chests/charm_swamp_hut", "mia.jer.dungeon.charm_swamp_hut");
            for (ResourceLocation table : tables) {
                dungeonRegistry.registerChest("chests/charm_swamp_hut", table);
            }
        }
        if (Charm.hasFeature(AbandonedCrates.class)) {
            String crates = "chests/charm_abandoned_crates";
            dungeonRegistry.registerCategory("chests/charm_abandoned_crates", "mia.jer.dungeon.charm_abandoned_crates");
            dungeonRegistry.registerChest("chests/charm_abandoned_crates", CharmLootTables.TREASURE_DANGEROUS);
            dungeonRegistry.registerChest("chests/charm_abandoned_crates", CharmLootTables.TREASURE_EXPLOSIVE);
            for (ResourceLocation loot : LootHelper.getLootTables((LootHelper.RARITY)LootHelper.RARITY.COMMON, (LootHelper.TYPE)LootHelper.TYPE.MISC)) {
                dungeonRegistry.registerChest("chests/charm_abandoned_crates", loot);
            }
            for (ResourceLocation loot : LootHelper.getLootTables((LootHelper.RARITY)LootHelper.RARITY.UNCOMMON, (LootHelper.TYPE)LootHelper.TYPE.MISC)) {
                dungeonRegistry.registerChest("chests/charm_abandoned_crates", loot);
            }
            for (ResourceLocation loot : LootHelper.getLootTables((LootHelper.RARITY)LootHelper.RARITY.VALUABLE, (LootHelper.TYPE)LootHelper.TYPE.MISC)) {
                dungeonRegistry.registerChest("chests/charm_abandoned_crates", loot);
            }
            for (ResourceLocation loot : LootHelper.getLootTables((LootHelper.RARITY)LootHelper.RARITY.RARE, (LootHelper.TYPE)LootHelper.TYPE.MISC)) {
                dungeonRegistry.registerChest("chests/charm_abandoned_crates", loot);
            }
        }
    }

    @Override
    @NotNull
    public ModIds getModId() {
        return ModIds.CHARM;
    }
}

