/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.biomesoplenty;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.common.block.BlockBOPDoor;
import com.github.sokyranthedragon.mia.block.decorative.SandstoneEntry;
import com.github.sokyranthedragon.mia.config.BiomesOPlentyConfiguration;
import com.github.sokyranthedragon.mia.config.GenericAdditionsConfig;
import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.core.MiaBlocks;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.base.IBaseMod;
import com.github.sokyranthedragon.mia.integrations.base.IModIntegration;
import com.github.sokyranthedragon.mia.integrations.biomesoplenty.BotaniaBopIntegration;
import com.github.sokyranthedragon.mia.integrations.biomesoplenty.ChiselBopIntegration;
import com.github.sokyranthedragon.mia.integrations.biomesoplenty.DungeonTacticsBopIntegration;
import com.github.sokyranthedragon.mia.integrations.biomesoplenty.ExtraUtilsBopIntegration;
import com.github.sokyranthedragon.mia.integrations.biomesoplenty.FutureMcBopIntegration;
import com.github.sokyranthedragon.mia.integrations.biomesoplenty.HatcheryBopIntegration;
import com.github.sokyranthedragon.mia.integrations.biomesoplenty.IndustrialForegoingBopIntegration;
import com.github.sokyranthedragon.mia.integrations.biomesoplenty.ThermalExpansionBopIntegration;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

public class BiomesOPlenty
implements IBaseMod {
    @Override
    public void register(BiConsumer<ModIds, IModIntegration> modIntegration) {
        if (BiomesOPlentyConfiguration.enableDungeonTacticsIntegration && ModIds.DUNGEON_TACTICS.isLoaded) {
            modIntegration.accept(ModIds.DUNGEON_TACTICS, new DungeonTacticsBopIntegration());
        }
        if (BiomesOPlentyConfiguration.enableFutureMcIntegration && ModIds.FUTURE_MC.isLoaded) {
            modIntegration.accept(ModIds.FUTURE_MC, new FutureMcBopIntegration());
        }
        if (ModIds.HATCHERY.isLoaded) {
            modIntegration.accept(ModIds.HATCHERY, new HatcheryBopIntegration(BiomesOPlentyConfiguration.enableHatcheryIntegration));
        }
        if (BiomesOPlentyConfiguration.enableTeIntegration && ModIds.THERMAL_EXPANSION.isLoaded) {
            modIntegration.accept(ModIds.THERMAL_EXPANSION, new ThermalExpansionBopIntegration());
        }
        if (BiomesOPlentyConfiguration.enableXu2Integration && ModIds.EXTRA_UTILITIES.isLoaded) {
            modIntegration.accept(ModIds.EXTRA_UTILITIES, new ExtraUtilsBopIntegration());
        }
        if (BiomesOPlentyConfiguration.enableBotaniaIntegration && ModIds.BOTANIA.isLoaded) {
            modIntegration.accept(ModIds.BOTANIA, new BotaniaBopIntegration());
        }
        if (BiomesOPlentyConfiguration.enableChiselIntegration && ModIds.CHISEL.isLoaded) {
            modIntegration.accept(ModIds.CHISEL, new ChiselBopIntegration());
        }
        if (BiomesOPlentyConfiguration.enableIFIntegration && ModIds.INDUSTRIAL_FOREGOING.isLoaded) {
            modIntegration.accept(ModIds.INDUSTRIAL_FOREGOING, new IndustrialForegoingBopIntegration());
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (BiomesOPlentyConfiguration.bopAdditionsEnabled) {
            SandstoneEntry.registerRecipes(MiaBlocks.whiteSandstone, BOPBlocks.white_sandstone);
            if (!MiaConfig.disableOreDict) {
                OreDictionary.registerOre((String)"listAllberry", (Item)BOPItems.berries);
                OreDictionary.registerOre((String)"listAllfruit", (Item)BOPItems.berries);
                OreDictionary.registerOre((String)"cropRice", (ItemStack)new ItemStack(BOPBlocks.plant_1, 1, 3));
                OreDictionary.registerOre((String)"cropBamboo", (ItemStack)new ItemStack(BOPBlocks.bamboo));
                OreDictionary.registerOre((String)"honeycomb", (ItemStack)new ItemStack(BOPItems.honeycomb));
                OreDictionary.registerOre((String)"foodHoneydrop", (ItemStack)new ItemStack(BOPItems.filled_honeycomb));
                OreDictionary.registerOre((String)"dropHoney", (ItemStack)new ItemStack(BOPItems.filled_honeycomb));
                OreDictionary.registerOre((String)"listAllsugar", (ItemStack)new ItemStack(BOPItems.filled_honeycomb));
                for (Block block : new Block[]{BOPBlocks.sacred_oak_door, BOPBlocks.cherry_door, BOPBlocks.umbran_door, BOPBlocks.fir_door, BOPBlocks.ethereal_door, BOPBlocks.magic_door, BOPBlocks.mangrove_door, BOPBlocks.palm_door, BOPBlocks.redwood_door, BOPBlocks.willow_door, BOPBlocks.pine_door, BOPBlocks.hellbark_door, BOPBlocks.jacaranda_door, BOPBlocks.mahogany_door, BOPBlocks.ebony_door, BOPBlocks.eucalyptus_door}) {
                    if (!(block instanceof BlockBOPDoor) || ((BlockBOPDoor)block).getDoorItem() == null) continue;
                    OreDictionary.registerOre((String)"doorWood", (Item)((BlockBOPDoor)block).getDoorItem());
                }
            }
        }
    }

    @Override
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        if (!BiomesOPlentyConfiguration.bopAdditionsEnabled) {
            return;
        }
        if (GenericAdditionsConfig.moreSandstone.bopWhiteSandstoneEnabled) {
            MiaBlocks.whiteSandstone = SandstoneEntry.init(BOPBlocks.white_sandstone, "white", CreativeTabs.field_78030_b, MapColor.field_193561_M, GenericAdditionsConfig.moreSandstone.bopWhiteSandstoneQuarkWallsEnabled);
        }
    }

    @Override
    public void registerItems(RegistryEvent.Register<Item> event) {
        if (!BiomesOPlentyConfiguration.bopAdditionsEnabled) {
            return;
        }
        SandstoneEntry.registerItemblocks(MiaBlocks.whiteSandstone, (IForgeRegistry<Item>)event.getRegistry());
    }
}

