/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.handlers;

import com.github.sokyranthedragon.mia.gui.container.ContainerMusicPlayer;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;

public class MusicPlayerStackHandler
implements IItemHandlerModifiable,
INBTSerializable<NBTTagCompound> {
    protected NonNullList<ItemStack> stacks = NonNullList.func_191196_a();
    private int currentSongSlot = 0;
    public ContainerMusicPlayer container = null;
    public UUID itemUuid;
    public boolean repeat = false;
    public boolean autoplay = true;
    public boolean shuffle = false;

    public MusicPlayerStackHandler() {
        this.stacks.add((Object)ItemStack.field_190927_a);
        this.itemUuid = UUID.randomUUID();
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof ItemRecord && this.stacks.stream().noneMatch(i -> i.func_77969_a(stack));
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (slot < 0 || slot >= this.stacks.size()) {
            return;
        }
        if (((ItemStack)this.stacks.get(slot)).func_190926_b() && !stack.func_190926_b()) {
            this.stacks.add(slot, (Object)stack);
            if (this.container != null && this.container.getSlots() < this.stacks.size()) {
                this.container.insertNextSlot();
            }
        } else if (!((ItemStack)this.stacks.get(slot)).func_190926_b() && stack.func_190926_b()) {
            this.stacks.remove(slot);
        } else {
            this.stacks.set(slot, (Object)stack);
        }
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        if (!simulate) {
            if (slot < 0) {
                slot = 0;
            } else if (slot >= this.stacks.size()) {
                slot = this.stacks.size() - 1;
            }
            this.stacks.add(slot, (Object)stack);
            if (this.container != null && this.container.getSlots() < this.stacks.size()) {
                this.container.insertNextSlot();
            }
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0 || slot >= this.stacks.size()) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!simulate && slot >= 0) {
            this.stacks.remove(slot);
        }
        return existing;
    }

    public int getSlots() {
        for (int i = this.stacks.size() - 1; i >= 0; --i) {
            if (!((ItemStack)this.stacks.get(i)).func_190926_b()) continue;
            return i;
        }
        return 0;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot < 0) {
            return (ItemStack)this.stacks.get(this.currentSongSlot);
        }
        this.validateSlotIndex(slot);
        return (ItemStack)this.stacks.get(slot);
    }

    public void markDirty() {
        if (this.stacks.size() == 0 || !((ItemStack)this.stacks.get(this.stacks.size() - 1)).func_190926_b()) {
            this.stacks.add((Object)ItemStack.field_190927_a);
        }
        if (this.currentSongSlot >= this.stacks.size()) {
            this.currentSongSlot = this.stacks.size() - 2;
        }
        if (this.stacks.size() > 1) {
            for (int i = this.stacks.size() - 2; i >= 0; --i) {
                if (!((ItemStack)this.stacks.get(i)).func_190926_b()) continue;
                this.stacks.remove(i);
                if (this.currentSongSlot < 1) continue;
                --this.currentSongSlot;
            }
        }
        if (this.currentSongSlot < 0) {
            this.currentSongSlot = 0;
        }
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagList nbtTagList = new NBTTagList();
        for (ItemStack stack : this.stacks) {
            if (stack.func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            stack.func_77955_b(itemTag);
            nbtTagList.func_74742_a((NBTBase)itemTag);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Items", (NBTBase)nbtTagList);
        nbt.func_74768_a("CurrentSong", this.currentSongSlot);
        nbt.func_74757_a("Autoplay", this.autoplay);
        nbt.func_74757_a("Repeat", this.repeat);
        nbt.func_74757_a("Shuffle", this.shuffle);
        nbt.func_186854_a("Uuid", this.itemUuid);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.stacks = NonNullList.func_191196_a();
        NBTTagList tagList = nbt.func_150295_c("Items", 10);
        this.currentSongSlot = nbt.func_74762_e("CurrentSong");
        this.autoplay = nbt.func_74767_n("Autoplay");
        this.repeat = nbt.func_74767_n("Repeat");
        this.shuffle = nbt.func_74767_n("Shuffle");
        this.itemUuid = nbt.func_186857_a("Uuid");
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            this.stacks.add((Object)new ItemStack(tagList.func_150305_b(i)));
        }
        this.markDirty();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }

    public ItemStack getCurrentSong() {
        return (ItemStack)this.stacks.get(this.currentSongSlot);
    }

    public int getCurrentSongSlot() {
        return this.currentSongSlot;
    }

    public void setCurrentSongSlot(int slot) {
        int totalSlots = this.getSlots();
        this.currentSongSlot = slot > totalSlots - 1 ? 0 : (slot < 0 ? totalSlots - 1 : slot);
    }

    public void nextSong() {
        this.setCurrentSongSlot(this.currentSongSlot + 1);
    }

    public void previousSong() {
        this.setCurrentSongSlot(this.currentSongSlot - 1);
    }
}

