/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.gui.client;

import com.github.sokyranthedragon.mia.gui.client.buttons.GuiButtonImageDisableable;
import com.github.sokyranthedragon.mia.gui.client.buttons.GuiToggleButton;
import com.github.sokyranthedragon.mia.gui.container.ContainerMusicPlayer;
import com.github.sokyranthedragon.mia.inventory.MusicPlayerInventory;
import com.github.sokyranthedragon.mia.utilities.MusicUtils;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiMusicPlayer
extends GuiContainer {
    private static final ResourceLocation texture = new ResourceLocation("mia:textures/gui/container/music_player.png");
    private final MusicPlayerInventory inventory;
    private GuiButtonImage pageLeftButton;
    private GuiButtonImage pageRightButton;
    private GuiToggleButton musicToggleButton;
    private GuiButtonImageDisableable playNextButton;
    private GuiButtonImageDisableable playPreviousButton;
    private GuiToggleButton autoplayButton;
    private GuiToggleButton shuffleButton;
    private GuiToggleButton repeatButton;
    private int checkCounter = 20;

    public GuiMusicPlayer(InventoryPlayer playerInventory, MusicPlayerInventory inventory) {
        super((Container)new ContainerMusicPlayer(playerInventory, inventory));
        this.inventory = inventory;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        if (this.autoplayButton.func_146115_a()) {
            if (this.autoplayButton.isAltVariant) {
                this.func_146279_a(I18n.func_135052_a((String)"mia.gui.music_player.tooltip.autoplay_alt", (Object[])new Object[0]), mouseX, mouseY);
            } else {
                this.func_146279_a(I18n.func_135052_a((String)"mia.gui.music_player.tooltip.autoplay", (Object[])new Object[0]), mouseX, mouseY);
            }
        } else if (this.shuffleButton.func_146115_a()) {
            if (this.shuffleButton.isAltVariant) {
                this.func_146283_a(Arrays.asList(I18n.func_135052_a((String)"mia.gui.music_player.tooltip.shuffle_alt", (Object[])new Object[0]), I18n.func_135052_a((String)"mia.gui.music_player.tooltip.autoplay_required", (Object[])new Object[0])), mouseX, mouseY);
            } else {
                this.func_146283_a(Arrays.asList(I18n.func_135052_a((String)"mia.gui.music_player.tooltip.shuffle", (Object[])new Object[0]), I18n.func_135052_a((String)"mia.gui.music_player.tooltip.autoplay_required", (Object[])new Object[0])), mouseX, mouseY);
            }
        } else if (this.repeatButton.func_146115_a()) {
            if (this.repeatButton.isAltVariant) {
                this.func_146283_a(Arrays.asList(I18n.func_135052_a((String)"mia.gui.music_player.tooltip.repeat_alt", (Object[])new Object[0]), I18n.func_135052_a((String)"mia.gui.music_player.tooltip.autoplay_required", (Object[])new Object[0])), mouseX, mouseY);
            } else {
                this.func_146283_a(Arrays.asList(I18n.func_135052_a((String)"mia.gui.music_player.tooltip.repeat", (Object[])new Object[0]), I18n.func_135052_a((String)"mia.gui.music_player.tooltip.autoplay_required", (Object[])new Object[0])), mouseX, mouseY);
            }
        } else if (this.musicToggleButton.func_146115_a() && !MusicUtils.isMusicOn()) {
            this.func_146279_a(I18n.func_135052_a((String)"mia.gui.music_player.tooltip.sound_off", (Object[])new Object[0]), mouseX, mouseY);
        }
    }

    protected void func_146976_a(float v, int i, int i1) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        int posX = (this.field_146294_l - this.field_146999_f) / 2;
        int posY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(posX, posY, 0, 0, this.field_146999_f, this.field_147000_g);
        int maxSlots = 7;
        if (this.inventory.openPage * 7 <= this.inventory.func_70302_i_() && (this.inventory.openPage + 1) * 7 > this.inventory.func_70302_i_()) {
            maxSlots = this.inventory.func_70302_i_() % 7 + 1;
        }
        for (int slot = 1; slot < maxSlots; ++slot) {
            this.func_73729_b(posX + 25 + slot * 18, posY + 53, 25, 53, 18, 18);
        }
    }

    public void func_73876_c() {
        this.updateButtons();
        super.func_73876_c();
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                if (this.inventory.openPage <= 0) break;
                --this.inventory.openPage;
                break;
            }
            case 1: {
                if ((this.inventory.openPage + 1) * 7 >= this.inventory.func_70302_i_() + 1) break;
                ++this.inventory.openPage;
                break;
            }
            case 2: {
                MusicUtils.toggleSong(this.inventory.inventory);
                this.checkCounter = 20;
                break;
            }
            case 3: {
                MusicUtils.playNext(this.inventory.inventory);
                break;
            }
            case 4: {
                MusicUtils.playPrevious(this.inventory.inventory);
                break;
            }
            case 5: {
                this.inventory.inventory.autoplay ^= true;
                break;
            }
            case 6: {
                this.inventory.inventory.shuffle ^= true;
                break;
            }
            case 7: {
                this.inventory.inventory.repeat ^= true;
            }
        }
        MusicUtils.updateMusicPlayerWithUuid((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.inventory.inventory);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.pageLeftButton = (GuiButtonImage)this.func_189646_b((GuiButton)new GuiButtonImage(0, 9 + this.field_147003_i, 53 + this.field_147009_r, 10, 18, 189, 0, 19, texture));
        this.pageRightButton = (GuiButtonImage)this.func_189646_b((GuiButton)new GuiButtonImage(1, 157 + this.field_147003_i, 53 + this.field_147009_r, 10, 18, 177, 0, 19, texture));
        this.musicToggleButton = (GuiToggleButton)this.func_189646_b(new GuiToggleButton(2, 111 + this.field_147003_i, 28 + this.field_147009_r, 20, 20, 0, 198, 19, 19, texture));
        this.playNextButton = (GuiButtonImageDisableable)this.func_189646_b(new GuiButtonImageDisableable(3, 131 + this.field_147003_i, 28 + this.field_147009_r, 20, 20, 38, 198, 19, texture));
        this.playPreviousButton = (GuiButtonImageDisableable)this.func_189646_b(new GuiButtonImageDisableable(4, 91 + this.field_147003_i, 28 + this.field_147009_r, 20, 20, 57, 198, 19, texture));
        this.autoplayButton = (GuiToggleButton)this.func_189646_b(new GuiToggleButton(5, 25 + this.field_147003_i, 28 + this.field_147009_r, 20, 20, 76, 198, 19, 19, texture));
        this.shuffleButton = (GuiToggleButton)this.func_189646_b(new GuiToggleButton(6, 45 + this.field_147003_i, 28 + this.field_147009_r, 20, 20, 152, 198, 19, 19, texture));
        this.repeatButton = (GuiToggleButton)this.func_189646_b(new GuiToggleButton(7, 65 + this.field_147003_i, 28 + this.field_147009_r, 20, 20, 114, 198, 19, 19, texture));
        this.updateButtons();
    }

    private void updateButtons() {
        boolean isEnabled;
        boolean leftVisible = this.inventory.openPage > 0;
        boolean rightVisible = (this.inventory.openPage + 1) * 7 < this.inventory.func_70302_i_() + 1;
        this.pageLeftButton.field_146124_l = leftVisible;
        this.pageLeftButton.field_146125_m = leftVisible;
        this.pageRightButton.field_146124_l = rightVisible;
        this.pageRightButton.field_146125_m = rightVisible;
        boolean bl = isEnabled = !this.inventory.func_191420_l() && MusicUtils.listener.startedPlaying(this.inventory.inventory.itemUuid);
        if (++this.checkCounter >= 20) {
            this.checkCounter = 0;
            PositionedSoundRecord sound = MusicUtils.currentlyPlayedSongs.get(this.inventory.inventory.itemUuid);
            this.musicToggleButton.isAltVariant = sound != null ? Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)sound) : false;
        }
        this.musicToggleButton.field_146124_l = isEnabled && MusicUtils.isMusicOn();
        this.playNextButton.field_146124_l = isEnabled && this.inventory.func_70302_i_() > 1;
        this.playPreviousButton.field_146124_l = isEnabled && this.inventory.func_70302_i_() > 1;
        this.autoplayButton.isAltVariant = this.inventory.inventory.autoplay;
        this.shuffleButton.isAltVariant = this.inventory.inventory.shuffle;
        this.repeatButton.isAltVariant = this.inventory.inventory.repeat;
    }
}

