/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.events;

import com.gildedgames.the_aether.items.ItemsAether;
import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.config.GenericAdditionsConfig;
import com.github.sokyranthedragon.mia.enchantments.EnchantmentKobold;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.network.MessageExtendedReachAttack;
import com.github.sokyranthedragon.mia.potions.BasePotion;
import com.github.sokyranthedragon.mia.potions.ModPotions;
import com.github.sokyranthedragon.mia.utilities.size.CollisionUtils;
import com.github.sokyranthedragon.mia.utilities.size.SizeUtils;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Size_ExtendedEvents {
    private static final Field arrowPotionTypeField = ObfuscationReflectionHelper.findField(EntityTippedArrow.class, (String)"field_184560_g");

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onMouse(MouseEvent event) {
        RayTraceResult ray;
        float size;
        EntityPlayerSP player;
        if (!SizeUtils.isSizeComponentEnabled) {
            return;
        }
        if (GenericAdditionsConfig.sizeModule.scaleReachDistance && event.getButton() == 0 && event.isButtonstate() && (player = Minecraft.func_71410_x().field_71439_g) != null && (size = SizeUtils.getEntitySize((EntityLivingBase)player)) > 1.0f && (ray = CollisionUtils.getMouseOverExtended(3.0f * size)) != null && ray.field_72308_g != null) {
            Mia.network.sendToServer((IMessage)new MessageExtendedReachAttack(ray.field_72308_g.func_145782_y()));
            player.func_184821_cY();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void useItemFinishEvent(LivingEntityUseItemEvent.Finish event) {
        boolean isMilkBucket;
        if (!SizeUtils.isSizeComponentEnabled || event.getEntityLiving() instanceof FakePlayer) {
            return;
        }
        boolean bl = isMilkBucket = event.getItem().func_77973_b() == Items.field_151117_aB;
        if (!isMilkBucket && ModIds.AETHER.isLoaded) {
            boolean bl2 = isMilkBucket = event.getItem().func_77973_b() == ItemsAether.skyroot_bucket && event.getItem().func_77960_j() == 4;
        }
        if (event.getEntityLiving() instanceof EntityPlayer && isMilkBucket && SizeUtils.getEntitySize(event.getEntityLiving()) != 1.0f) {
            event.getEntityLiving().func_184589_d(ModPotions.sizeStabilizationPotion);
            PotionEffect effect = new PotionEffect(ModPotions.sizeStabilizationPotion, Integer.MAX_VALUE);
            if (event.getEntityLiving().field_70170_p.field_72995_K) {
                effect.func_100012_b(true);
            }
            event.getEntityLiving().func_70690_d(effect);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        WorldServer[] worlds;
        if (!SizeUtils.isSizeComponentEnabled) {
            return;
        }
        for (WorldServer world : worlds = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
            if (world == null) continue;
            for (Entity entity : world.field_72996_f) {
                if (!(entity instanceof EntityLivingBase)) continue;
                if (entity instanceof EntityPlayer) {
                    if (EnchantmentKobold.checkKoboldEnchantment((EntityPlayer)entity)) continue;
                    SizeUtils.validateEntitySize((EntityLivingBase)entity);
                    continue;
                }
                SizeUtils.validateEntitySize((EntityLivingBase)entity);
            }
        }
    }

    @SubscribeEvent
    public static void onArrowImpact(ProjectileImpactEvent.Arrow event) {
        if (!SizeUtils.isSizeComponentEnabled) {
            return;
        }
        if (event.getArrow() instanceof EntityTippedArrow && event.getRayTraceResult().field_72308_g instanceof EntityLivingBase) {
            EntityTippedArrow arrow = (EntityTippedArrow)event.getArrow();
            try {
                PotionType potion = (PotionType)arrowPotionTypeField.get(arrow);
                PotionType newPotion = new PotionType((PotionEffect[])potion.func_185170_a().stream().map(e -> {
                    if (e.func_188419_a() instanceof BasePotion) {
                        return new PotionEffect(e.func_188419_a(), e.func_76459_b() * 4, e.func_76458_c(), e.func_82720_e(), e.func_188418_e());
                    }
                    return e;
                }).toArray(PotionEffect[]::new));
                arrowPotionTypeField.set(arrow, newPotion);
            }
            catch (IllegalAccessException e2) {
                Mia.LOGGER.error("Could not change tipped arrow value, ignoring");
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!SizeUtils.isSizeComponentEnabled) {
            return;
        }
        if (event.player != null && !EnchantmentKobold.checkKoboldEnchantment(event.player)) {
            SizeUtils.validateEntitySize((EntityLivingBase)event.player);
        }
    }
}

