/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.events;

import com.gendeathrow.hatchery.block.nestpen.NestPenTileEntity;
import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.config.ThaumcraftConfiguration;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.utilities.ExtraUtilitiesUtils;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.items.ItemGoldenLasso;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.common.config.ModConfig;

@Mod.EventBusSubscriber(modid="mia")
public class PlayerEvents {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getSide() == Side.CLIENT) {
            return;
        }
        TileEntity tile = event.getWorld().func_175625_s(event.getPos());
        if (ModIds.HATCHERY.isLoaded && tile instanceof NestPenTileEntity) {
            NestPenTileEntity pen = (NestPenTileEntity)tile;
            EntityPlayer player = event.getEntityPlayer();
            ItemStack item = player.func_184586_b(event.getHand());
            if (player.func_70093_af() && ExtraUtilitiesUtils.isItemLasso(item)) {
                try {
                    event.setCanceled(true);
                    event.setCancellationResult(EnumActionResult.PASS);
                }
                catch (UnsupportedOperationException e) {
                    Mia.LOGGER.warn("Could not cancel nesting pen right click event.");
                }
                if (event.isCanceled()) {
                    if (pen.storedEntity() == null) {
                        if (ExtraUtilitiesUtils.isItemLassoWithMob(item, "chickens:chickenschicken", "minecraft:chicken")) {
                            Mia.LOGGER.info("Trying to put chicken into the pen.");
                            NBTTagCompound nbt = item.func_77978_p();
                            World world = event.getWorld();
                            Entity chicken = EntityList.func_75615_a((NBTTagCompound)nbt.func_74775_l("Animal"), (World)world);
                            pen.trySetEntity(chicken);
                            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187665_Y, SoundCategory.NEUTRAL, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                            nbt.func_82580_o("Animal");
                            nbt.func_82580_o("Animal_Metadata");
                            nbt.func_82580_o("No_Place");
                            item.func_135074_t();
                            player.field_71071_by.func_70296_d();
                        }
                    } else if (ExtraUtilitiesUtils.isItemLassoWithoutMob(item)) {
                        EntityAgeable chicken = (EntityAgeable)pen.tryGetRemoveEntity();
                        ((ItemGoldenLasso)XU2Entries.goldenLasso.value).addTargetToLasso(item, (EntityLivingBase)chicken);
                        player.field_71071_by.func_70296_d();
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!ModIds.THAUMCRAFT.isLoaded && !ThaumcraftConfiguration.thaumcraftAdditionsEnabled) {
            return;
        }
        PlayerEvents.handleWussResearch(event.player);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (!ModIds.THAUMCRAFT.isLoaded || !ThaumcraftConfiguration.thaumcraftAdditionsEnabled) {
            return;
        }
        if (event.getModID().equals(ModIds.THAUMCRAFT.modId)) {
            WorldServer[] worlds;
            for (WorldServer world : worlds = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                if (world == null) continue;
                for (EntityPlayer player : world.field_73010_i) {
                    PlayerEvents.handleWussResearch(player);
                }
            }
        }
    }

    private static void handleWussResearch(EntityPlayer player) {
        if (!ModIds.THAUMCRAFT.isLoaded || player instanceof FakePlayer) {
            return;
        }
        IPlayerKnowledge knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)player);
        if (ModConfig.CONFIG_MISC.wussMode) {
            if (!knowledge.isResearchKnown("!WussMode")) {
                knowledge.addResearch("!WussMode");
            }
        } else if (knowledge.isResearchKnown("!WussMode")) {
            knowledge.removeResearch("!WussMode");
        }
    }
}

