/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.events;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.gildedgames.the_aether.api.AetherAPI;
import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.capabilities.MusicPlayerCapabilityProvider;
import com.github.sokyranthedragon.mia.client.input.MiaKeyBindings;
import com.github.sokyranthedragon.mia.core.MiaItems;
import com.github.sokyranthedragon.mia.handlers.MusicPlayerStackHandler;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.network.MessageSyncMusicPlayer;
import com.github.sokyranthedragon.mia.utilities.InventoryUtils;
import com.github.sokyranthedragon.mia.utilities.MusicUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.ImmutableTriple;

@Mod.EventBusSubscriber(modid="mia")
public class ClientEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public static void keyInput(TickEvent.ClientTickEvent event) {
        int i;
        MusicPlayerStackHandler capability;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74316_C.func_151470_d() && (capability = (MusicPlayerStackHandler)player.func_184614_ca().getCapability(MusicPlayerCapabilityProvider.ITEM_HANDLER_CAPABILITY, null)) != null) {
            MusicUtils.stopSong(capability);
        }
        boolean openGuiPressed = MiaKeyBindings.openGui.func_151468_f();
        boolean musicTogglePressed = MiaKeyBindings.musicToggle.func_151468_f();
        boolean nextSongPressed = MiaKeyBindings.nextSong.func_151468_f();
        boolean previousSongPressed = MiaKeyBindings.previousSong.func_151468_f();
        if (MiaItems.musicPlayer != null && (openGuiPressed || musicTogglePressed || nextSongPressed || previousSongPressed)) {
            ImmutableTriple<ItemStack, Integer, Integer> itemInInventory = InventoryUtils.findItemInInventory((EntityPlayer)player, MiaItems.musicPlayer);
            MusicPlayerStackHandler capability2 = (MusicPlayerStackHandler)((ItemStack)itemInInventory.left).getCapability(MusicPlayerCapabilityProvider.ITEM_HANDLER_CAPABILITY, null);
            if (!((ItemStack)itemInInventory.left).func_190926_b() && capability2 != null) {
                if (openGuiPressed) {
                    player.openGui((Object)Mia.instance, 3, player.field_70170_p, ((Integer)itemInInventory.middle).intValue(), ((Integer)itemInInventory.right).intValue(), 0);
                }
                if (musicTogglePressed) {
                    MusicUtils.toggleSong(capability2);
                    Mia.network.sendToServer((IMessage)new MessageSyncMusicPlayer((Integer)itemInInventory.middle, (Integer)itemInInventory.right, capability2, false));
                } else if (nextSongPressed) {
                    MusicUtils.playNext(capability2);
                    Mia.network.sendToServer((IMessage)new MessageSyncMusicPlayer((Integer)itemInInventory.middle, (Integer)itemInInventory.right, capability2, false));
                } else if (previousSongPressed) {
                    MusicUtils.playPrevious(capability2);
                    Mia.network.sendToServer((IMessage)new MessageSyncMusicPlayer((Integer)itemInInventory.middle, (Integer)itemInInventory.right, capability2, false));
                }
            }
        }
        if (player.field_70173_aa % 20 == 0) {
            return;
        }
        MusicUtils.listener.updateTimers();
        HashSet<UUID> uuidList = new HashSet<UUID>();
        if (ModIds.BAUBLES.isLoaded) {
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (i = 0; i < baubles.getSlots(); ++i) {
                ClientEvents.handleMusicPlayerVerification(baubles.getStackInSlot(i), uuidList, 3, i);
            }
        }
        if (ModIds.AETHER.isLoaded) {
            NonNullList accessories = AetherAPI.getInstance().get((EntityPlayer)player).getAccessoryInventory().getAccessories();
            for (i = 0; i < accessories.size(); ++i) {
                ClientEvents.handleMusicPlayerVerification((ItemStack)accessories.get(i), uuidList, 5, i);
            }
        }
        for (int i2 = 0; i2 < player.field_71071_by.field_70462_a.size(); ++i2) {
            ClientEvents.handleMusicPlayerVerification((ItemStack)player.field_71071_by.field_70462_a.get(i2), uuidList, 2, i2);
        }
        ClientEvents.handleMusicPlayerVerification(player.func_184592_cb(), uuidList, 1, 0);
        ClientEvents.handleMusicPlayerVerification(player.field_71071_by.func_70445_o(), uuidList, 4, 0);
        MusicUtils.currentlyPlayedSongs = MusicUtils.currentlyPlayedSongs.entrySet().stream().filter(e -> {
            if (!uuidList.contains(e.getKey())) {
                Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)e.getValue());
                return false;
            }
            return true;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @SideOnly(value=Side.CLIENT)
    private static void handleMusicPlayerVerification(ItemStack item, Set<UUID> uuidList, int type, int slot) {
        PositionedSoundRecord currentSong;
        if (item == null || item.func_190926_b()) {
            return;
        }
        MusicPlayerStackHandler capability = (MusicPlayerStackHandler)item.getCapability(MusicPlayerCapabilityProvider.ITEM_HANDLER_CAPABILITY, null);
        if (capability == null) {
            return;
        }
        if (uuidList.contains(capability.itemUuid)) {
            do {
                capability.itemUuid = UUID.randomUUID();
            } while (uuidList.contains(capability.itemUuid));
            Mia.network.sendToServer((IMessage)new MessageSyncMusicPlayer(type, slot, capability, true));
        } else if (MusicUtils.listener.startedPlaying(capability.itemUuid) && (currentSong = MusicUtils.currentlyPlayedSongs.get(capability.itemUuid)) != null && !Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)currentSong)) {
            if (capability.autoplay) {
                if (capability.repeat) {
                    MusicUtils.toggleSong(capability);
                } else if (capability.shuffle) {
                    MusicUtils.randomNext(capability);
                } else {
                    MusicUtils.playNext(capability);
                }
                Mia.network.sendToServer((IMessage)new MessageSyncMusicPlayer(type, slot, capability, false));
            } else {
                MusicUtils.stopSong(capability);
            }
        }
        uuidList.add(capability.itemUuid);
    }
}

