/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.enchantments;

import com.github.sokyranthedragon.mia.enchantments.ModEnchantments;
import com.github.sokyranthedragon.mia.utilities.size.SizeUtils;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;

public class EnchantmentKobold
extends Enchantment {
    public static Set<UUID> koboldPlayers = Sets.newHashSet();

    protected EnchantmentKobold() {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.ARMOR_CHEST, new EntityEquipmentSlot[]{EntityEquipmentSlot.CHEST});
    }

    public int func_77325_b() {
        return 1;
    }

    public int func_77321_a(int level) {
        return 35;
    }

    public int func_77317_b(int level) {
        return 100;
    }

    public boolean func_92089_a(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemElytra || super.func_92089_a(stack);
    }

    public static float getSizeModifier(EntityPlayer player, float size) {
        ItemStack armor = (ItemStack)player.field_71071_by.field_70460_b.get(EntityEquipmentSlot.CHEST.func_188454_b());
        int level = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.KOBOLD, (ItemStack)armor);
        if (level == 0) {
            return size;
        }
        return Math.min(size + (1.0f - size), 1.0f);
    }

    public static boolean checkKoboldEnchantment(EntityPlayer player) {
        ItemStack chest = (ItemStack)player.field_71071_by.field_70460_b.get(EntityEquipmentSlot.CHEST.func_188454_b());
        if (chest.func_77948_v()) {
            if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.KOBOLD, (ItemStack)chest) > 0 && !koboldPlayers.contains(player.func_146103_bH().getId())) {
                koboldPlayers.add(player.func_146103_bH().getId());
                SizeUtils.validateEntitySize((EntityLivingBase)player);
                return true;
            }
        } else if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.KOBOLD, (ItemStack)chest) == 0 && koboldPlayers.contains(player.func_146103_bH().getId())) {
            koboldPlayers.remove(player.func_146103_bH().getId());
            SizeUtils.validateEntitySize((EntityLivingBase)player);
            return true;
        }
        return false;
    }
}

