/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.dispenserbehavior;

import com.github.sokyranthedragon.mia.Mia;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DispenserLootBag
implements IBehaviorDispenseItem {
    @Nullable
    protected static DispenserLootBag INSTANCE = null;
    protected Collection<IDispenserListener> listeners = new HashSet<IDispenserListener>();

    public static DispenserLootBag getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DispenserLootBag();
        }
        return INSTANCE;
    }

    public void addListener(IDispenserListener listener, Item ... items) {
        assert (INSTANCE != null);
        this.listeners.add(listener);
        for (Item item : items) {
            assert (item != null && item != Items.field_190931_a);
            BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)INSTANCE);
        }
    }

    public void addListener(IDispenserListener listener, Block ... items) {
        assert (INSTANCE != null);
        this.listeners.add(listener);
        for (Block block : items) {
            assert (block != null && block != Blocks.field_150350_a && Item.func_150898_a((Block)block) != Items.field_190931_a);
            BlockDispenser.field_149943_a.func_82595_a((Object)Item.func_150898_a((Block)block), (Object)INSTANCE);
        }
    }

    public void addListener(IDispenserListener listener, ItemStack ... items) {
        assert (INSTANCE != null);
        if (this.listeners.contains(listener)) {
            Mia.LOGGER.warn("Tried to register the same listener dispenser loot bag listener twice, this shouldn't have happened!");
        } else {
            this.listeners.add(listener);
            for (ItemStack item : items) {
                assert (item != null);
                if (item.func_190926_b()) continue;
                BlockDispenser.field_149943_a.func_82595_a((Object)item.func_77973_b(), (Object)INSTANCE);
            }
        }
    }

    public ItemStack func_82482_a(IBlockSource source, ItemStack stack) {
        for (IDispenserListener listener : this.listeners) {
            if (listener.dispense(source, stack)) break;
        }
        return stack;
    }

    @FunctionalInterface
    public static interface IDispenserListener {
        public boolean dispense(IBlockSource var1, ItemStack var2);
    }
}

