/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="mia", name="mia/base")
@Config.LangKey(value="mia.config.base.title")
@Mod.EventBusSubscriber(modid="mia")
public class MiaConfig {
    @Config.Name(value="Enable music player")
    @Config.Comment(value={"Set to false to completely disable the music player item"})
    @Config.LangKey(value="mia.config.base.music_player")
    @Config.RequiresMcRestart
    public static boolean musicPlayerEnabled = true;
    @Config.Name(value="Music player volume")
    @Config.Comment(value={"Volume of the songs played by music player"})
    @Config.LangKey(value="mia.config.base.music_player_volume")
    @Config.RangeInt(min=0, max=100)
    @Config.SlidingOption
    public static int musicPlayerVolume = 30;
    @Config.Name(value="Replaces all raw meat drops with cooked ones")
    @Config.Comment(value={"Replaces raw meat dropped by mobs on fire with their cooked version (if possible)", "This is done to match modded mobs with vanilla behavior, as not all modded mobs do this"})
    @Config.LangKey(value="mia.config.base.add_cooked_drops")
    public static boolean addCookedDrops = true;
    @Config.Name(value="Disable all recipes")
    @Config.Comment(value={"Completely disables any new recipes added by this mod"})
    @Config.LangKey(value="mia.config.base.disable_recipes")
    @Config.RequiresMcRestart
    public static boolean disableAllRecipes = false;
    @Config.Name(value="Disable ore dictionary registration")
    @Config.Comment(value={"Completely removes any ore dictionary entries added for other modded items"})
    @Config.LangKey(value="mia.config.base.disable_ore_dict")
    public static boolean disableOreDict = false;
    @Config.Name(value="Enable creative tab")
    @Config.Comment(value={"If this option is disabled then any MIA items and blocks will be added to creative tabs of related mods"})
    @Config.LangKey(value="mia.config.base.mia_creative_tab")
    public static boolean miaCreativeTab = true;
    @Config.Name(value="Show error toasts")
    @Config.Comment(value={"If enabled all non-crashing MIA related errors will be notified by a toast message"})
    @Config.LangKey(value="mia.config.base.mia_error_toasts")
    public static boolean showErrorToasts = true;

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("mia")) {
            ConfigManager.sync((String)"mia", (Config.Type)Config.Type.INSTANCE);
        }
    }
}

