/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="mia", name="mia/base_additions")
@Config.LangKey(value="mia.config.base_additions.title")
@Mod.EventBusSubscriber(modid="mia")
public class GenericAdditionsConfig {
    @Config.Name(value="Enable more sandstone")
    @Config.Comment(value={"Set to false to completely disable any new sandstone types from being added"})
    @Config.LangKey(value="mia.config.base_additions.more_sandstone")
    @Config.RequiresMcRestart
    public static boolean enableMoreSandstone = true;
    @Config.Name(value="Enable EVTP")
    @Config.Comment(value={"If set to false then any blocks added by EVTP will be disabled"})
    @Config.LangKey(value="mia.config.base_additions.evtp.enabled")
    @Config.RequiresMcRestart
    public static boolean enableEvtp = true;
    @Config.Name(value="Enable size module")
    @Config.Comment(value={"If set to false then any size change related content will be disabled (requires ArtemisLib to be installed)"})
    @Config.LangKey(value="mia.config.base_additions.size_component.enabled")
    @Config.RequiresMcRestart
    public static boolean enableSizeComponent = false;
    @Config.Name(value="More Sandstone")
    @Config.Comment(value={"Shared More Sandstone settings"})
    @Config.LangKey(value="mia.config.base_additions.more_sandstone_shared")
    public static MoreSandstone moreSandstone = new MoreSandstone();
    @Config.Name(value="EVTP")
    @Config.Comment(value={"EVTP settings"})
    @Config.LangKey(value="mia.config.base_additions.evtp")
    public static EVTP evtp = new EVTP();
    @Config.Name(value="Size module")
    @Config.Comment(value={"Configuration related to size changing related components"})
    @Config.LangKey(value="mia.config.base_additions.size_component")
    public static SizeModule sizeModule = new SizeModule();

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("mia")) {
            ConfigManager.sync((String)"mia", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class SizeModule {
        @Config.Name(value="Minimum player size")
        @Config.Comment(value={"Changes the lowest allowed player size"})
        @Config.LangKey(value="mia.config.base_additions.size_component.min_player_size")
        @Config.RangeDouble(min=0.125, max=1.0)
        public float minPlayerSize = 0.125f;
        @Config.Name(value="Maximum player size")
        @Config.Comment(value={"Changes the highest allowed player size"})
        @Config.LangKey(value="mia.config.base_additions.size_component.max_player_size")
        @Config.RangeDouble(min=1.0, max=10.0)
        public float maxPlayerSize = 10.0f;
        @Config.Name(value="Can mob size change")
        @Config.Comment(value={"Setting this to true allows the player to change the size of non-player mobs."})
        @Config.LangKey(value="mia.config.base_additions.size_component.mob_size")
        public boolean canScaleMobs = true;
        @Config.Name(value="Minimum mob size")
        @Config.Comment(value={"Changes the lowest allowed mob size"})
        @Config.LangKey(value="mia.config.base_additions.size_component.min_mob_size")
        @Config.RangeDouble(min=0.125, max=1.0)
        public float minMobSize = 0.125f;
        @Config.Name(value="Maximum mob size")
        @Config.Comment(value={"Changes the highest allowed mob size"})
        @Config.LangKey(value="mia.config.base_additions.size_component.max_mob_size")
        @Config.RangeDouble(min=1.0, max=10.0)
        public float maxMobSize = 10.0f;
        @Config.Name(value="Scale movement speed")
        @Config.Comment(value={"Scales movement speed based on size"})
        @Config.LangKey(value="mia.config.base_additions.size_component.scale_speed")
        public boolean scaleMovementSpeed = true;
        @Config.Name(value="Scale strength")
        @Config.Comment(value={"Scales strength based on size"})
        @Config.LangKey(value="mia.config.base_additions.size_component.scale_strength")
        public boolean scaleStrength = true;
        @Config.Name(value="Scale max health")
        @Config.Comment(value={"Scales max health based on size"})
        @Config.LangKey(value="mia.config.base_additions.size_component.scale_max_health")
        public boolean scaleMaxHealth = true;
        @Config.Name(value="Scale current health when growing")
        @Config.Comment(value={"Scales current health when max health is increased when growing"})
        @Config.LangKey(value="mia.config.base_additions.size_component.scale_current_health")
        public boolean scaleCurrentHealthWhenGrowing = true;
        @Config.Name(value="Scale reach distance")
        @Config.Comment(value={"Scales reach distance based on size"})
        @Config.LangKey(value="mia.config.base_additions.size_component.scale_reach")
        public boolean scaleReachDistance = true;
        @Config.Name(value="Scale swimming speed")
        @Config.Comment(value={"Scales swimming speed based on size"})
        @Config.LangKey(value="mia.config.base_additions.size_component.scale_swim_speed")
        public boolean scaleSwimSpeed = true;
        @Config.Name(value="Health multiplier")
        @Config.Comment(value={"If max health scaling is enabled, this determines how much the health is affected by size"})
        @Config.LangKey(value="mia.config.base_additions.size_component.health_multiplier")
        @Config.RangeDouble(min=1.401298464324817E-45, max=3.4028234663852886E38)
        public float healthMultiplier = 1.0f;
        @Config.Name(value="Fix small entity rendering")
        @Config.Comment(value={"While entities are small size (below 0.4) they start looking weird, which is fixed by this setting. Could cause issues with other mods. Disabling this could very slightly help performance."})
        @Config.LangKey(value="mia.config.base_additions.size_component.fix_rendering")
        public boolean fixRendering = true;
        @Config.Name(value="Fix player rendering in inventory")
        @Config.Comment(value={"While the inventory is open, the player size is scaled to match unchanged player size. Could cause issues with other mods. Disabling this could slightly help performance."})
        @Config.LangKey(value="mia.config.base_additions.size_component.fix_rendering_inventory")
        public boolean fixInventoryRendering = true;
        @Config.Name(value="Entities banned from size change")
        @Config.Comment(value={"Any entity inside of this list will not be able to change size in any way."})
        @Config.LangKey(value="mia.config.base_additions.size_component.banned_entities_size")
        public String[] bannedEntitiesSize = new String[]{"botania:doppleganger", "extrabotany:gaiaIII", "extrabotany:voidherrscher"};
        @Config.Name(value="Can entities crush smaller entities from themselves")
        @Config.Comment(value={"If there's big enough difference between two entities sizes, the bigger one will damage to the smaller one"})
        @Config.LangKey(value="mia.config.base_additions.size_component.giants_crush_entities")
        public boolean giantsCrushEntities = false;
        public boolean onlyHostileMobsCanCrush = true;
        @Config.Name(value="Can bigger players crush smaller players")
        @Config.Comment(value={"If there's big enough difference between two player sizes, and the option for entities crushing smaller ones is enabled, the bigger players will damage the smaller ones"})
        @Config.LangKey(value="mia.config.base_additions.size_component.players_crush_players")
        public boolean canPlayersCrushOtherPlayers = true;
        @Config.Name(value="Entities being banned from crushing smaller entities or being crushed by them")
        @Config.Comment(value={"If the option for entities to crush smaller ones is enabled, this list will be used to determine which entities are banned from crushing other or being crushed"})
        @Config.LangKey(value="mia.config.base_additions.size_component.banned_entities_crushing")
        public String[] bannedEntitiesCrushing = new String[0];
        @Config.Name(value="Do roses hurt small players")
        @Config.Comment(value={"If this is set to true, small players will take damage if walking through roses"})
        @Config.LangKey(value="mia.config.base_additions.size_component.roses_hurt_player")
        public boolean doRosesHurtSmallPlayer = true;
        @Config.Name(value="Do bushes slow down small players")
        @Config.Comment(value={"If this is set to true, small players will be slowed down if walking through plants"})
        @Config.LangKey(value="mia.config.base_additions.size_component.plants_slow_player")
        public boolean doPlantsSlowSmallPlayer = true;
        @Config.Name(value="Can small players climb some blocks")
        @Config.Comment(value={"If this is set to true, small players can climb some blocks without having to use any special means"})
        @Config.LangKey(value="mia.config.base_additions.size_component.climb_some_blocks")
        public boolean canClimbSomeBlocks = true;
        @Config.Name(value="Can small players climb while holding slime balls/slime blocks")
        @Config.Comment(value={"If this value is set to true, small players can climb blocks while holding either a slime ball, or a slime block"})
        @Config.LangKey(value="mia.config.base_additions.size_component.climb_with_slime")
        public boolean canClimbWithSlime = true;
        @Config.Name(value="Can small players climb while holding paper")
        @Config.Comment(value={"If this value is set to true, small players can glide while holding paper"})
        @Config.LangKey(value="mia.config.base_additions.size_component.glide_with_paper")
        public boolean canGlideWithPaper = true;
        @Config.Name(value="Do small blocks give lift while gliding")
        @Config.Comment(value={"If this value is true and while player is gliding with paper over hot blocks, it will increase player's flight height"})
        @Config.LangKey(value="mia.config.base_additions.size_component.hot_blocks_lift")
        public boolean hotBlocksGiveLift = true;
        @Config.Name(value="Thaumcraft integration")
        @Config.Comment(value={"Set to true to add size change foci to Thaumcraft"})
        @Config.LangKey(value="mia.config.base_additions.size_component.thaumcraft_integration")
        @Config.RequiresMcRestart
        public boolean thaumcraftIntegration = true;

        private SizeModule() {
        }
    }

    public static class EVTP {
        @Config.Name(value="Enable Armored Glass")
        @Config.Comment(value={"Determines if Armored Glass is going to be enabled"})
        @Config.LangKey(value="mia.config.base_additions.evtp.armored_glass_enabled")
        @Config.RequiresMcRestart
        public boolean armoredGlassEnabled = true;
        @Config.Name(value="Enable packed paper block")
        @Config.Comment(value={"Determines if Packed Paper is going to be enabled"})
        @Config.LangKey(value="mia.config.base_additions.evtp.packed_paper_enabled")
        @Config.RequiresMcRestart
        public boolean packedPaperEnabled = true;
        @Config.Name(value="Enable golden torch")
        @Config.Comment(value={"Determines if Golden Torch is going to be enabled"})
        @Config.LangKey(value="mia.config.base_additions.evtp.golden_torch_enabled")
        @Config.RequiresMcRestart
        public boolean goldenTorchEnabled = true;
        @Config.Name(value="Enable dead flowers")
        @Config.Comment(value={"Determines if Dead Flower is going to be enabled"})
        @Config.LangKey(value="mia.config.base_additions.evtp.dead_flower_enabled")
        @Config.RequiresMcRestart
        public boolean deadFlowerEnabled = true;
        @Config.Name(value="Dead flower spawn chance")
        @Config.Comment(value={"Determines percentage chance to generate a dead flower", "A value of 0 is 0%, a value of 100 is 100%", "The chance itself is also affected by biome temperature (higher temperature means higher chance, unless the chance is 0)"})
        @Config.LangKey(value="mia.config.base_additions.evtp.dead_flower_chance")
        @Config.RangeDouble(min=0.0, max=100.0)
        public double deadFlowerSpawnChance = 1.5;
        @Config.Name(value="Enable stone doors")
        @Config.Comment(value={"Determines if Stone Doors are going to be enabled"})
        @Config.LangKey(value="mia.config.base_additions.evtp.stone_doors_enabled")
        @Config.RequiresMcRestart
        public boolean stoneDoorsEnabled = true;
        @Config.Name(value="Enable redstone lantern")
        @Config.Comment(value={"Determines if Redstone Lantern is going to be enabled"})
        @Config.LangKey(value="mia.config.base_additions.evtp.redstone_lantern_enabled")
        @Config.RequiresMcRestart
        public boolean redstoneLanternEnabled = true;

        private EVTP() {
        }
    }

    public static class MoreSandstone {
        @Config.Name(value="Enable more sandstone Quark blocks")
        @Config.Comment(value={"Set to false to disable Quark's more sandstone block"})
        @Config.LangKey(value="mia.config.base_additions.more_sandstone.quark")
        @Config.RequiresMcRestart
        public boolean moreSandstoneQuarkEnabled = true;
        @Config.Name(value="Enable more sandstone FutureMC walls")
        @Config.Comment(value={"Set to false to disable FutureMC sandstone walls"})
        @Config.LangKey(value="mia.config.base_additions.more_sandstone.futuremc")
        @Config.RequiresMcRestart
        public boolean sandstoneWallsFutureMcEnabled = true;
        @Config.Name(value="Force more sandstone")
        @Config.Comment(value={"If set to true then Quark's more sandstone will be enabled even if they're disabled in Quark"})
        @Config.LangKey(value="mia.config.base_additions.more_sandstone.forced")
        @Config.RequiresMcRestart
        public boolean forceMoreSandstone = false;
        @Config.Name(value="Force more sandstone stairs and slabs")
        @Config.Comment(value={"If set to true then Quark's more sandstone stairs and slabs will be enabled even if they're disabled in Quark"})
        @Config.LangKey(value="mia.config.base_additions.more_sandstone.forced_stairs_slabs")
        @Config.RequiresMcRestart
        public boolean forceMoreSandstoneStairsAndSlabs = false;
        @Config.Name(value="Force more sandstone Quark walls")
        @Config.Comment(value={"If set to true then Quark's more sandstone walls will be enabled even if they're disabled in Quark"})
        @Config.LangKey(value="mia.config.base_additions.more_sandstone.forced_quark_walls")
        @Config.RequiresMcRestart
        public boolean forceMoreSandstoneQuarkWalls = false;
        @Config.Name(value="Enable white sandstone")
        @Config.Comment(value={"Set to false to disable White Sandstone from receiving any new blocks"})
        @Config.LangKey(value="mia.config.base_additions.more_sandstone.bop_white_sandstone")
        @Config.RequiresMcRestart
        public boolean bopWhiteSandstoneEnabled = true;
        @Config.Name(value="Enable white sandstone Quark walls")
        @Config.Comment(value={"Set to false to disable Quark's White Sandstone walls"})
        @Config.LangKey(value="mia.config.base_additions.more_sandstone.bop_white_sandstone_quark_walls")
        @Config.RequiresMcRestart
        public boolean bopWhiteSandstoneQuarkWallsEnabled = true;

        private MoreSandstone() {
        }
    }
}

