/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.block.decorative;

import com.github.sokyranthedragon.mia.block.IAutoRegisterBlock;
import com.github.sokyranthedragon.mia.block.IMetaBlock;
import com.github.sokyranthedragon.mia.block.base.BlockBase;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockRedstoneLantern
extends BlockBase
implements IAutoRegisterBlock,
IMetaBlock {
    public static final PropertyBool MANUAL_STATE = PropertyBool.func_177716_a((String)"manual_state");
    public static final PropertyBool REDSTONE_STATE = PropertyBool.func_177716_a((String)"redstone_state");
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockRedstoneLantern() {
        super(Material.field_151576_e, "redstone_lantern", CreativeTabs.field_78028_d);
        this.func_149715_a(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)REDSTONE_STATE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)MANUAL_STATE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MANUAL_STATE, REDSTONE_STATE, FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MANUAL_STATE, (Comparable)Boolean.valueOf((meta & 8) != 0)).func_177226_a((IProperty)REDSTONE_STATE, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)MANUAL_STATE)).booleanValue()) {
            meta |= 8;
        }
        if (((Boolean)state.func_177229_b((IProperty)REDSTONE_STATE)).booleanValue()) {
            meta |= 4;
        }
        return meta;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                world.func_180501_a(pos, state.func_177231_a((IProperty)FACING), 2);
            } else {
                world.func_180501_a(pos, state.func_177231_a((IProperty)MANUAL_STATE), 2);
                float pitch = (Boolean)state.func_177229_b((IProperty)MANUAL_STATE) != false ? 0.6f : 0.5f;
                world.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, pitch);
            }
        }
        return true;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.updateBlockPowerState(world, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (worldIn.func_175640_z(pos)) {
            this.updateBlockPowerState(worldIn, pos, state);
        } else {
            worldIn.func_175684_a(pos, (Block)this, 4);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.updateBlockPowerState(worldIn, pos, state);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean manualState;
        boolean redstoneState = (Boolean)state.func_177229_b((IProperty)REDSTONE_STATE);
        if (redstoneState ^ (manualState = ((Boolean)state.func_177229_b((IProperty)MANUAL_STATE)).booleanValue())) {
            return state.func_185906_d();
        }
        return 0;
    }

    protected void updateBlockPowerState(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            boolean redstoneState = (Boolean)state.func_177229_b((IProperty)REDSTONE_STATE);
            boolean powered = world.func_175640_z(pos);
            if (powered ^ redstoneState) {
                world.func_180501_a(pos, state.func_177231_a((IProperty)REDSTONE_STATE), 2);
            }
        }
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, 0);
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack((Block)this, 1, 0);
    }

    @Override
    public int getMaxMeta() {
        return 0;
    }

    @Override
    public String getNameFromMeta(int i) {
        return "";
    }

    @Override
    @Nullable
    public String getVariantName() {
        return null;
    }

    @Override
    @Nullable
    public String getDefaultVariantValue() {
        return "facing=north,manual_state=false,redstone_state=false";
    }
}

