/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.phosphor.mod.world.lighting;

import me.jellysquid.mods.phosphor.api.IChunkLighting;
import me.jellysquid.mods.phosphor.api.IChunkLightingData;
import me.jellysquid.mods.phosphor.api.ILightingEngine;
import me.jellysquid.mods.phosphor.api.ILightingEngineProvider;
import me.jellysquid.mods.phosphor.mod.PhosphorMod;
import me.jellysquid.mods.phosphor.mod.world.lighting.LightingEngineHelpers;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class LightingHooks {
    private static final EnumSkyBlock[] ENUM_SKY_BLOCK_VALUES = EnumSkyBlock.values();
    private static final EnumFacing.AxisDirection[] ENUM_AXIS_DIRECTION_VALUES = EnumFacing.AxisDirection.values();
    private static final int FLAG_COUNT = 32;
    public static final String neighborLightChecksKey = "NeighborLightChecks";

    public static void relightSkylightColumn(World world, Chunk chunk, int x, int z, int height1, int height2) {
        int yMin = Math.min(height1, height2);
        int yMax = Math.max(height1, height2) - 1;
        ExtendedBlockStorage[] sections = chunk.func_76587_i();
        int xBase = (chunk.field_76635_g << 4) + x;
        int zBase = (chunk.field_76647_h << 4) + z;
        LightingHooks.scheduleRelightChecksForColumn(world, EnumSkyBlock.SKY, xBase, zBase, yMin, yMax);
        if (sections[yMin >> 4] == Chunk.field_186036_a && yMin > 0) {
            world.func_180500_c(EnumSkyBlock.SKY, new BlockPos(xBase, yMin - 1, zBase));
        }
        short emptySections = 0;
        for (int sec = yMax >> 4; sec >= yMin >> 4; --sec) {
            if (sections[sec] != Chunk.field_186036_a) continue;
            emptySections = (short)(emptySections | 1 << sec);
        }
        if (emptySections != 0) {
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                int zOffset;
                boolean neighborColumnExists;
                int xOffset = dir.func_82601_c();
                boolean bl = neighborColumnExists = ((x + xOffset | z + (zOffset = dir.func_82599_e())) & 0x10) == 0 || world.func_72863_F().func_186026_b(chunk.field_76635_g + xOffset, chunk.field_76647_h + zOffset) != null;
                if (neighborColumnExists) {
                    for (int sec = yMax >> 4; sec >= yMin >> 4; --sec) {
                        if ((emptySections & 1 << sec) == 0) continue;
                        LightingHooks.scheduleRelightChecksForColumn(world, EnumSkyBlock.SKY, xBase + xOffset, zBase + zOffset, sec << 4, (sec << 4) + 15);
                    }
                    continue;
                }
                LightingHooks.flagChunkBoundaryForUpdate(chunk, emptySections, EnumSkyBlock.SKY, dir, LightingHooks.getAxisDirection(dir, x, z), EnumBoundaryFacing.OUT);
            }
        }
    }

    public static void scheduleRelightChecksForArea(World world, EnumSkyBlock lightType, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                LightingHooks.scheduleRelightChecksForColumn(world, lightType, x, z, yMin, yMax);
            }
        }
    }

    private static void scheduleRelightChecksForColumn(World world, EnumSkyBlock lightType, int x, int z, int yMin, int yMax) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int y = yMin; y <= yMax; ++y) {
            world.func_180500_c(lightType, (BlockPos)pos.func_181079_c(x, y, z));
        }
    }

    public static void flagSecBoundaryForUpdate(Chunk chunk, BlockPos pos, EnumSkyBlock lightType, EnumFacing dir, EnumBoundaryFacing boundaryFacing) {
        LightingHooks.flagChunkBoundaryForUpdate(chunk, (short)(1 << (pos.func_177956_o() >> 4)), lightType, dir, LightingHooks.getAxisDirection(dir, pos.func_177958_n(), pos.func_177952_p()), boundaryFacing);
    }

    public static void flagChunkBoundaryForUpdate(Chunk chunk, short sectionMask, EnumSkyBlock lightType, EnumFacing dir, EnumFacing.AxisDirection axisDirection, EnumBoundaryFacing boundaryFacing) {
        LightingHooks.initNeighborLightChecks(chunk);
        short[] sArray = ((IChunkLightingData)chunk).getNeighborLightChecks();
        int n = LightingHooks.getFlagIndex(lightType, dir, axisDirection, boundaryFacing);
        sArray[n] = (short)(sArray[n] | sectionMask);
        chunk.func_76630_e();
    }

    public static int getFlagIndex(EnumSkyBlock lightType, int xOffset, int zOffset, EnumFacing.AxisDirection axisDirection, EnumBoundaryFacing boundaryFacing) {
        return (lightType == EnumSkyBlock.BLOCK ? 0 : 16) | xOffset + 1 << 2 | zOffset + 1 << 1 | axisDirection.func_179524_a() + 1 | boundaryFacing.ordinal();
    }

    public static int getFlagIndex(EnumSkyBlock lightType, EnumFacing dir, EnumFacing.AxisDirection axisDirection, EnumBoundaryFacing boundaryFacing) {
        return LightingHooks.getFlagIndex(lightType, dir.func_82601_c(), dir.func_82599_e(), axisDirection, boundaryFacing);
    }

    private static EnumFacing.AxisDirection getAxisDirection(EnumFacing dir, int x, int z) {
        return ((dir.func_176740_k() == EnumFacing.Axis.X ? z : x) & 0xF) < 8 ? EnumFacing.AxisDirection.NEGATIVE : EnumFacing.AxisDirection.POSITIVE;
    }

    public static void scheduleRelightChecksForChunkBoundaries(World world, Chunk chunk) {
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            int xOffset = dir.func_82601_c();
            int zOffset = dir.func_82599_e();
            Chunk nChunk = world.func_72863_F().func_186026_b(chunk.field_76635_g + xOffset, chunk.field_76647_h + zOffset);
            if (nChunk == null) continue;
            for (EnumSkyBlock lightType : ENUM_SKY_BLOCK_VALUES) {
                for (EnumFacing.AxisDirection axisDir : ENUM_AXIS_DIRECTION_VALUES) {
                    LightingHooks.mergeFlags(lightType, chunk, nChunk, dir, axisDir);
                    LightingHooks.mergeFlags(lightType, nChunk, chunk, dir.func_176734_d(), axisDir);
                    LightingHooks.scheduleRelightChecksForBoundary(world, chunk, nChunk, null, lightType, xOffset, zOffset, axisDir);
                    LightingHooks.scheduleRelightChecksForBoundary(world, nChunk, chunk, null, lightType, -xOffset, -zOffset, axisDir);
                    LightingHooks.scheduleRelightChecksForBoundary(world, nChunk, null, chunk, lightType, zOffset != 0 ? axisDir.func_179524_a() : 0, xOffset != 0 ? axisDir.func_179524_a() : 0, dir.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? EnumFacing.AxisDirection.NEGATIVE : EnumFacing.AxisDirection.POSITIVE);
                }
            }
        }
    }

    private static void mergeFlags(EnumSkyBlock lightType, Chunk inChunk, Chunk outChunk, EnumFacing dir, EnumFacing.AxisDirection axisDir) {
        IChunkLightingData outChunkLightingData = (IChunkLightingData)outChunk;
        if (outChunkLightingData.getNeighborLightChecks() == null) {
            return;
        }
        IChunkLightingData inChunkLightingData = (IChunkLightingData)inChunk;
        LightingHooks.initNeighborLightChecks(inChunk);
        int inIndex = LightingHooks.getFlagIndex(lightType, dir, axisDir, EnumBoundaryFacing.IN);
        int outIndex = LightingHooks.getFlagIndex(lightType, dir.func_176734_d(), axisDir, EnumBoundaryFacing.OUT);
        short[] sArray = inChunkLightingData.getNeighborLightChecks();
        int n = inIndex;
        sArray[n] = (short)(sArray[n] | outChunkLightingData.getNeighborLightChecks()[outIndex]);
    }

    private static void scheduleRelightChecksForBoundary(World world, Chunk chunk, Chunk nChunk, Chunk sChunk, EnumSkyBlock lightType, int xOffset, int zOffset, EnumFacing.AxisDirection axisDir) {
        IChunkLightingData chunkLightingData = (IChunkLightingData)chunk;
        if (chunkLightingData.getNeighborLightChecks() == null) {
            return;
        }
        int flagIndex = LightingHooks.getFlagIndex(lightType, xOffset, zOffset, axisDir, EnumBoundaryFacing.IN);
        short flags = chunkLightingData.getNeighborLightChecks()[flagIndex];
        if (flags == 0) {
            return;
        }
        if (nChunk == null && (nChunk = world.func_72863_F().func_186026_b(chunk.field_76635_g + xOffset, chunk.field_76647_h + zOffset)) == null) {
            return;
        }
        if (sChunk == null && (sChunk = world.func_72863_F().func_186026_b(chunk.field_76635_g + (zOffset != 0 ? axisDir.func_179524_a() : 0), chunk.field_76647_h + (xOffset != 0 ? axisDir.func_179524_a() : 0))) == null) {
            return;
        }
        int reverseIndex = LightingHooks.getFlagIndex(lightType, -xOffset, -zOffset, axisDir, EnumBoundaryFacing.OUT);
        chunkLightingData.getNeighborLightChecks()[flagIndex] = 0;
        IChunkLightingData nChunkLightingData = (IChunkLightingData)nChunk;
        if (nChunkLightingData.getNeighborLightChecks() != null) {
            nChunkLightingData.getNeighborLightChecks()[reverseIndex] = 0;
        }
        chunk.func_76630_e();
        nChunk.func_76630_e();
        int xMin = chunk.field_76635_g << 4;
        int zMin = chunk.field_76647_h << 4;
        if ((xOffset | zOffset) > 0) {
            xMin += 15 * xOffset;
            zMin += 15 * zOffset;
        }
        if (axisDir == EnumFacing.AxisDirection.POSITIVE) {
            xMin += 8 * (zOffset & 1);
            zMin += 8 * (xOffset & 1);
        }
        int xMax = xMin + 7 * (zOffset & 1);
        int zMax = zMin + 7 * (xOffset & 1);
        for (int y = 0; y < 16; ++y) {
            if ((flags & 1 << y) == 0) continue;
            LightingHooks.scheduleRelightChecksForArea(world, lightType, xMin, y << 4, zMin, xMax, (y << 4) + 15, zMax);
        }
    }

    public static void initNeighborLightChecks(Chunk chunk) {
        IChunkLightingData lightingData = (IChunkLightingData)chunk;
        if (lightingData.getNeighborLightChecks() == null) {
            lightingData.setNeighborLightChecks(new short[32]);
        }
    }

    public static void writeNeighborLightChecksToNBT(Chunk chunk, NBTTagCompound nbt) {
        short[] neighborLightChecks = ((IChunkLightingData)chunk).getNeighborLightChecks();
        if (neighborLightChecks == null) {
            return;
        }
        boolean empty = true;
        NBTTagList list = new NBTTagList();
        for (short flags : neighborLightChecks) {
            list.func_74742_a((NBTBase)new NBTTagShort(flags));
            if (flags == 0) continue;
            empty = false;
        }
        if (!empty) {
            nbt.func_74782_a(neighborLightChecksKey, (NBTBase)list);
        }
    }

    public static void readNeighborLightChecksFromNBT(Chunk chunk, NBTTagCompound nbt) {
        if (nbt.func_150297_b(neighborLightChecksKey, 9)) {
            NBTTagList list = nbt.func_150295_c(neighborLightChecksKey, 2);
            if (list.func_74745_c() == 32) {
                LightingHooks.initNeighborLightChecks(chunk);
                short[] neighborLightChecks = ((IChunkLightingData)chunk).getNeighborLightChecks();
                for (int i = 0; i < 32; ++i) {
                    neighborLightChecks[i] = ((NBTTagShort)list.func_179238_g(i)).func_150289_e();
                }
            } else {
                PhosphorMod.LOGGER.warn("Chunk field {} had invalid length, ignoring it (chunk coordinates: {} {})", (Object)neighborLightChecksKey, (Object)chunk.field_76635_g, (Object)chunk.field_76647_h);
            }
        }
    }

    public static void initChunkLighting(Chunk chunk, World world) {
        int xBase = chunk.field_76635_g << 4;
        int zBase = chunk.field_76647_h << 4;
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185339_c((int)xBase, (int)0, (int)zBase);
        if (world.func_175706_a(pos.func_177982_a(-16, 0, -16), pos.func_177982_a(31, 255, 31), false)) {
            ExtendedBlockStorage[] extendedBlockStorage = chunk.func_76587_i();
            for (int j = 0; j < extendedBlockStorage.length; ++j) {
                ExtendedBlockStorage storage = extendedBlockStorage[j];
                if (storage == Chunk.field_186036_a) continue;
                int yBase = j * 16;
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        for (int x = 0; x < 16; ++x) {
                            IBlockState state = storage.func_186049_g().func_186016_a(x, y, z);
                            int light = LightingEngineHelpers.getLightValueForState(state, (IBlockAccess)world, (BlockPos)pos);
                            if (light <= 0) continue;
                            pos.func_181079_c(xBase + x, yBase + y, zBase + z);
                            world.func_180500_c(EnumSkyBlock.BLOCK, (BlockPos)pos);
                        }
                    }
                }
            }
            if (world.field_73011_w.func_191066_m()) {
                ((IChunkLightingData)chunk).setSkylightUpdatedPublic();
            }
            ((IChunkLightingData)chunk).setLightInitialized(true);
        }
        pos.func_185344_t();
    }

    public static void checkChunkLighting(Chunk chunk, World world) {
        if (!((IChunkLightingData)chunk).isLightInitialized()) {
            LightingHooks.initChunkLighting(chunk, world);
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                Chunk nChunk;
                if (x == 0 && z == 0 || (nChunk = world.func_72863_F().func_186026_b(chunk.field_76635_g + x, chunk.field_76647_h + z)) != null && ((IChunkLightingData)nChunk).isLightInitialized()) continue;
                return;
            }
        }
        chunk.func_177421_e(true);
    }

    public static void initSkylightForSection(World world, Chunk chunk, ExtendedBlockStorage section) {
        if (world.field_73011_w.func_191066_m()) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (chunk.func_76611_b(x, z) > section.func_76662_d()) continue;
                    for (int y = 0; y < 16; ++y) {
                        section.func_76657_c(x, y, z, EnumSkyBlock.SKY.field_77198_c);
                    }
                }
            }
        }
    }

    private static short[] getNeighborLightChecks(Chunk chunk) {
        return ((IChunkLightingData)chunk).getNeighborLightChecks();
    }

    private static void setNeighborLightChecks(Chunk chunk, short[] table) {
        ((IChunkLightingData)chunk).setNeighborLightChecks(table);
    }

    public static int getCachedLightFor(Chunk chunk, EnumSkyBlock type, BlockPos pos) {
        return ((IChunkLighting)chunk).getCachedLightFor(type, pos);
    }

    public static ILightingEngine getLightingEngine(World world) {
        return ((ILightingEngineProvider)world).getLightingEngine();
    }

    public static enum EnumBoundaryFacing {
        IN,
        OUT;


        public EnumBoundaryFacing getOpposite() {
            return this == IN ? OUT : IN;
        }
    }
}

