/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.phosphor.mixins.lighting.common;

import me.jellysquid.mods.phosphor.api.IChunkLighting;
import me.jellysquid.mods.phosphor.api.IChunkLightingData;
import me.jellysquid.mods.phosphor.api.ILightingEngine;
import me.jellysquid.mods.phosphor.api.ILightingEngineProvider;
import me.jellysquid.mods.phosphor.mod.world.WorldChunkSlice;
import me.jellysquid.mods.phosphor.mod.world.lighting.LightingHooks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Chunk.class})
public abstract class MixinChunk
implements IChunkLighting,
IChunkLightingData,
ILightingEngineProvider {
    private static final EnumFacing[] HORIZONTAL = EnumFacing.Plane.HORIZONTAL.func_179516_a();
    @Shadow
    @Final
    private ExtendedBlockStorage[] field_76652_q;
    @Shadow
    private boolean field_76643_l;
    @Shadow
    @Final
    private int[] field_76634_f;
    @Shadow
    private int field_82912_p;
    @Shadow
    @Final
    private int[] field_76638_b;
    @Shadow
    @Final
    private World field_76637_e;
    @Shadow
    private boolean field_76646_k;
    @Final
    @Shadow
    private boolean[] field_76639_c;
    @Final
    @Shadow
    public int field_76635_g;
    @Final
    @Shadow
    public int field_76647_h;
    @Shadow
    private boolean field_76650_s;
    private short[] neighborLightChecks;
    private boolean isLightInitialized;
    private ILightingEngine lightingEngine;

    @Shadow
    public abstract TileEntity func_177424_a(BlockPos var1, Chunk.EnumCreateEntityType var2);

    @Shadow
    public abstract IBlockState func_177435_g(BlockPos var1);

    @Shadow
    protected abstract int func_150808_b(int var1, int var2, int var3);

    @Shadow
    public abstract boolean func_177444_d(BlockPos var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstructed(CallbackInfo ci) {
        this.lightingEngine = ((ILightingEngineProvider)this.field_76637_e).getLightingEngine();
    }

    @Inject(method={"getLightSubtracted"}, at={@At(value="HEAD")})
    private void onGetLightSubtracted(BlockPos pos, int amount, CallbackInfoReturnable<Integer> cir) {
        this.lightingEngine.processLightUpdates();
    }

    @Inject(method={"onLoad"}, at={@At(value="RETURN")})
    private void onLoad(CallbackInfo ci) {
        LightingHooks.scheduleRelightChecksForChunkBoundaries(this.field_76637_e, (Chunk)this);
    }

    @Redirect(method={"setLightFor"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;generateSkylightMap()V"), expect=0)
    private void setLightForRedirectGenerateSkylightMap(Chunk chunk, EnumSkyBlock type, BlockPos pos, int value) {
        LightingHooks.initSkylightForSection(this.field_76637_e, (Chunk)this, this.field_76652_q[pos.func_177956_o() >> 4]);
    }

    @Overwrite
    private void func_76615_h(int x, int y, int z) {
        int i;
        int j = i = this.field_76634_f[z << 4 | x] & 0xFF;
        if (y > i) {
            j = y;
        }
        while (j > 0 && this.func_150808_b(x, j - 1, z) == 0) {
            --j;
        }
        if (j != i) {
            int l1;
            this.field_76634_f[z << 4 | x] = j;
            if (this.field_76637_e.field_73011_w.func_191066_m()) {
                LightingHooks.relightSkylightColumn(this.field_76637_e, (Chunk)this, x, z, i, j);
            }
            if ((l1 = this.field_76634_f[z << 4 | x]) < this.field_82912_p) {
                this.field_82912_p = l1;
            }
        }
    }

    @Overwrite
    public int func_177413_a(EnumSkyBlock type, BlockPos pos) {
        this.lightingEngine.processLightUpdatesForType(type);
        return this.getCachedLightFor(type, pos);
    }

    @Overwrite
    public void func_150809_p() {
        this.field_76646_k = true;
        LightingHooks.checkChunkLighting((Chunk)this, this.field_76637_e);
    }

    @Overwrite
    private void func_150803_c(boolean onlyOne) {
        this.field_76637_e.field_72984_F.func_76320_a("recheckGaps");
        WorldChunkSlice slice = new WorldChunkSlice(this.field_76637_e, this.field_76635_g, this.field_76647_h);
        if (this.field_76637_e.func_175697_a(new BlockPos(this.field_76635_g * 16 + 8, 0, this.field_76647_h * 16 + 8), 16)) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (!this.recheckGapsForColumn(slice, x, z) || !onlyOne) continue;
                    this.field_76637_e.field_72984_F.func_76319_b();
                    return;
                }
            }
            this.field_76650_s = false;
        }
        this.field_76637_e.field_72984_F.func_76319_b();
    }

    private boolean recheckGapsForColumn(WorldChunkSlice slice, int x, int z) {
        int i = x + z * 16;
        if (this.field_76639_c[i]) {
            this.field_76639_c[i] = false;
            int height = this.func_76611_b(x, z);
            int x1 = this.field_76635_g * 16 + x;
            int z1 = this.field_76647_h * 16 + z;
            int max = this.recheckGapsGetLowestHeight(slice, x1, z1);
            this.recheckGapsSkylightNeighborHeight(slice, x1, z1, height, max);
            return true;
        }
        return false;
    }

    private int recheckGapsGetLowestHeight(WorldChunkSlice slice, int x, int z) {
        int max = Integer.MAX_VALUE;
        for (EnumFacing facing : HORIZONTAL) {
            int k;
            int j = x + facing.func_82601_c();
            Chunk chunk = slice.getChunkFromWorldCoords(j, k = z + facing.func_82599_e());
            if (chunk == null) continue;
            max = Math.min(max, slice.getChunkFromWorldCoords(j, k).func_177442_v());
        }
        return max;
    }

    private void recheckGapsSkylightNeighborHeight(WorldChunkSlice slice, int x, int z, int height, int max) {
        this.checkSkylightNeighborHeight(slice, x, z, max);
        for (EnumFacing facing : HORIZONTAL) {
            int j = x + facing.func_82601_c();
            int k = z + facing.func_82599_e();
            this.checkSkylightNeighborHeight(slice, j, k, height);
        }
    }

    private void checkSkylightNeighborHeight(WorldChunkSlice slice, int x, int z, int maxValue) {
        if (slice.getChunkFromWorldCoords(x, z) == null) {
            return;
        }
        int i = slice.getChunkFromWorldCoords(x, z).func_76611_b(x & 0xF, z & 0xF);
        if (i > maxValue) {
            this.updateSkylightNeighborHeight(slice, x, z, maxValue, i + 1);
        } else if (i < maxValue) {
            this.updateSkylightNeighborHeight(slice, x, z, i, maxValue + 1);
        }
    }

    private void updateSkylightNeighborHeight(WorldChunkSlice slice, int x, int z, int startY, int endY) {
        if (endY > startY) {
            if (!slice.isLoaded(x, z, 16)) {
                return;
            }
            for (int i = startY; i < endY; ++i) {
                this.field_76637_e.func_180500_c(EnumSkyBlock.SKY, new BlockPos(x, i, z));
            }
            this.field_76643_l = true;
        }
    }

    @Shadow
    public abstract int func_76611_b(int var1, int var2);

    @Override
    public short[] getNeighborLightChecks() {
        return this.neighborLightChecks;
    }

    @Override
    public void setNeighborLightChecks(short[] data) {
        this.neighborLightChecks = data;
    }

    @Override
    public ILightingEngine getLightingEngine() {
        return this.lightingEngine;
    }

    @Override
    public boolean isLightInitialized() {
        return this.isLightInitialized;
    }

    @Override
    public void setLightInitialized(boolean lightInitialized) {
        this.isLightInitialized = lightInitialized;
    }

    @Shadow
    protected abstract void func_177441_y();

    @Override
    public void setSkylightUpdatedPublic() {
        this.func_177441_y();
    }

    @Override
    public int getCachedLightFor(EnumSkyBlock type, BlockPos pos) {
        int i = pos.func_177958_n() & 0xF;
        int j = pos.func_177956_o();
        int k = pos.func_177952_p() & 0xF;
        ExtendedBlockStorage extendedblockstorage = this.field_76652_q[j >> 4];
        if (extendedblockstorage == Chunk.field_186036_a) {
            if (this.func_177444_d(pos)) {
                return type.field_77198_c;
            }
            return 0;
        }
        if (type == EnumSkyBlock.SKY) {
            if (!this.field_76637_e.field_73011_w.func_191066_m()) {
                return 0;
            }
            return extendedblockstorage.func_76670_c(i, j & 0xF, k);
        }
        if (type == EnumSkyBlock.BLOCK) {
            return extendedblockstorage.func_76674_d(i, j & 0xF, k);
        }
        return type.field_77198_c;
    }
}

