/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import yalter.mousetweaks.MTConfig;
import yalter.mousetweaks.SimpleMouseState;
import yalter.mousetweaks.api.IMTModGuiContainer;
import yalter.mousetweaks.api.IMTModGuiContainer2;
import yalter.mousetweaks.api.IMTModGuiContainer2Ex;
import yalter.mousetweaks.handlers.GuiContainerCreativeHandler;
import yalter.mousetweaks.handlers.GuiContainerHandler;
import yalter.mousetweaks.handlers.IMTModGuiContainer2ExHandler;
import yalter.mousetweaks.handlers.IMTModGuiContainer2Handler;
import yalter.mousetweaks.handlers.IMTModGuiContainerHandler;
import yalter.mousetweaks.impl.IGuiScreenHandler;
import yalter.mousetweaks.impl.IMouseState;
import yalter.mousetweaks.impl.MouseButton;
import yalter.mousetweaks.reflect.Reflection;
import yalter.mousetweaks.util.MTLog;

public class Main {
    private static IMouseState mouseState = new SimpleMouseState();
    private static GuiScreen oldGuiScreen = null;
    private static Slot oldSelectedSlot = null;
    private static Slot firstRightClickedSlot = null;
    private static boolean oldRMBDown = false;
    private static boolean disableForThisContainer = false;
    private static boolean disableWheelForThisContainer = false;
    private static IGuiScreenHandler handler = null;
    private static boolean initialized = false;

    public static boolean initialize() {
        if (initialized) {
            return true;
        }
        initialized = true;
        Reflection.reflectGuiContainer();
        MTLog.logger.fatal("Mouse Tweaks has been initialized.");
        return true;
    }

    public static void onUpdateInGame() {
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (currentScreen == null) {
            oldGuiScreen = null;
            oldSelectedSlot = null;
            firstRightClickedSlot = null;
            disableForThisContainer = false;
            disableWheelForThisContainer = false;
            handler = null;
        } else {
            Main.onUpdateInGui(currentScreen);
        }
        oldRMBDown = mouseState.isButtonPressed(MouseButton.RIGHT);
    }

    public static void onMouseInput() {
        mouseState.update();
    }

    private static void onUpdateInGui(GuiScreen currentScreen) {
        ItemStack stackOnMouse;
        ItemStack targetStack;
        if (oldGuiScreen != currentScreen) {
            oldGuiScreen = currentScreen;
            MTLog.logger.debug("You have just opened " + currentScreen.getClass().getSimpleName() + ".");
            handler = Main.findHandler(currentScreen);
            mouseState.clear();
            if (handler == null) {
                disableForThisContainer = true;
                MTLog.logger.debug("No valid handler found; MT is disabled.");
                return;
            }
            disableForThisContainer = handler.isMouseTweaksDisabled();
            disableWheelForThisContainer = handler.isWheelTweakDisabled();
            MTLog.logger.debug("Handler: " + handler.getClass().getSimpleName() + "; MT is " + (disableForThisContainer ? "disabled" : "enabled") + "; wheel tweak is " + (disableWheelForThisContainer ? "disabled" : "enabled") + ".");
        }
        if (!(MTConfig.rmbTweak || MTConfig.lmbTweakWithItem || MTConfig.lmbTweakWithoutItem || MTConfig.wheelTweak)) {
            return;
        }
        if (disableForThisContainer) {
            return;
        }
        Slot selectedSlot = handler.getSlotUnderMouse();
        if (mouseState.isButtonPressed(MouseButton.RIGHT)) {
            if (!oldRMBDown) {
                firstRightClickedSlot = selectedSlot;
            }
            if (MTConfig.rmbTweak && handler.disableRMBDraggingFunctionality() && firstRightClickedSlot != null && (firstRightClickedSlot != selectedSlot || oldSelectedSlot == selectedSlot) && !handler.isIgnored(firstRightClickedSlot) && !handler.isCraftingOutput(firstRightClickedSlot)) {
                targetStack = firstRightClickedSlot.func_75211_c();
                stackOnMouse = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
                if (!stackOnMouse.func_190926_b() && Main.areStacksCompatible(stackOnMouse, targetStack) && firstRightClickedSlot.func_75214_a(stackOnMouse)) {
                    handler.clickSlot(firstRightClickedSlot, MouseButton.RIGHT, false);
                }
            }
        } else {
            firstRightClickedSlot = null;
        }
        if (oldSelectedSlot != selectedSlot) {
            boolean shiftIsDown;
            oldSelectedSlot = selectedSlot;
            if (selectedSlot == null) {
                return;
            }
            if (firstRightClickedSlot == selectedSlot) {
                firstRightClickedSlot = null;
            }
            MTLog.logger.debug("You have selected a new slot, it's slot number is " + selectedSlot.field_75222_d);
            targetStack = selectedSlot.func_75211_c().func_77946_l();
            stackOnMouse = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o().func_77946_l();
            boolean bl = shiftIsDown = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            if (mouseState.isButtonPressed(MouseButton.RIGHT)) {
                if (MTConfig.rmbTweak && !handler.isIgnored(selectedSlot) && !handler.isCraftingOutput(selectedSlot) && !stackOnMouse.func_190926_b() && Main.areStacksCompatible(stackOnMouse, targetStack) && selectedSlot.func_75214_a(stackOnMouse)) {
                    handler.clickSlot(selectedSlot, MouseButton.RIGHT, false);
                }
            } else if (mouseState.isButtonPressed(MouseButton.LEFT)) {
                if (!stackOnMouse.func_190926_b()) {
                    if (MTConfig.lmbTweakWithItem && !handler.isIgnored(selectedSlot) && !targetStack.func_190926_b() && Main.areStacksCompatible(stackOnMouse, targetStack)) {
                        if (shiftIsDown) {
                            handler.clickSlot(selectedSlot, MouseButton.LEFT, true);
                        } else if (stackOnMouse.func_190916_E() + targetStack.func_190916_E() <= stackOnMouse.func_77976_d()) {
                            handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                            if (!handler.isCraftingOutput(selectedSlot)) {
                                handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                            }
                        }
                    }
                } else if (MTConfig.lmbTweakWithoutItem && !targetStack.func_190926_b() && shiftIsDown && !handler.isIgnored(selectedSlot)) {
                    handler.clickSlot(selectedSlot, MouseButton.LEFT, true);
                }
            }
        }
        Main.handleWheel(selectedSlot);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void handleWheel(Slot selectedSlot) {
        boolean pushItems;
        if (!MTConfig.wheelTweak) return;
        if (disableWheelForThisContainer) {
            return;
        }
        int wheel = mouseState.consumeScrollAmount();
        int numItemsToMove = Math.abs(wheel);
        if (numItemsToMove == 0) return;
        if (selectedSlot == null) return;
        if (handler.isIgnored(selectedSlot)) {
            return;
        }
        ItemStack stackOnMouse = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o().func_77946_l();
        ItemStack originalStack = selectedSlot.func_75211_c().func_77946_l();
        boolean isCraftingOutput = handler.isCraftingOutput(selectedSlot);
        if (originalStack.func_190926_b()) return;
        if (!stackOnMouse.func_190926_b() && isCraftingOutput != Main.areStacksCompatible(originalStack, stackOnMouse)) {
            return;
        }
        List<Slot> slots = handler.getSlots();
        boolean bl = pushItems = wheel < 0;
        if (MTConfig.wheelScrollDirection.isPositionAware() && Main.otherInventoryIsAbove(selectedSlot, slots)) {
            boolean bl2 = pushItems = !pushItems;
        }
        if (MTConfig.wheelScrollDirection.isInverted()) {
            boolean bl3 = pushItems = !pushItems;
        }
        if (isCraftingOutput) {
            if (!pushItems) return;
            if (originalStack.func_190926_b()) {
                return;
            }
            Slot applicableSlot = Main.findWheelApplicableSlot(slots, selectedSlot, pushItems);
            int i = 0;
            while (true) {
                if (i >= numItemsToMove) {
                    if (applicableSlot == null) return;
                    if (!stackOnMouse.func_190926_b()) return;
                    handler.clickSlot(applicableSlot, MouseButton.LEFT, false);
                    return;
                }
                handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                ++i;
            }
        }
        do {
            int i;
            ItemStack stackFrom;
            ItemStack stackTo;
            Slot slotFrom;
            Slot slotTo;
            Slot applicableSlot;
            if ((applicableSlot = Main.findWheelApplicableSlot(slots, selectedSlot, pushItems)) == null) {
                return;
            }
            if (pushItems) {
                slotTo = applicableSlot;
                slotFrom = selectedSlot;
                stackTo = slotTo.func_75211_c().func_77946_l();
                stackFrom = slotFrom.func_75211_c().func_77946_l();
                numItemsToMove = Math.min(numItemsToMove, stackFrom.func_190916_E());
                if (!stackTo.func_190926_b() && stackTo.func_77976_d() - stackTo.func_190916_E() <= numItemsToMove) {
                    handler.clickSlot(slotFrom, MouseButton.LEFT, false);
                    handler.clickSlot(slotTo, MouseButton.LEFT, false);
                    handler.clickSlot(slotFrom, MouseButton.LEFT, false);
                    numItemsToMove -= stackTo.func_77976_d() - stackTo.func_190916_E();
                    continue;
                }
                handler.clickSlot(slotFrom, MouseButton.LEFT, false);
                if (stackFrom.func_190916_E() <= numItemsToMove) {
                    handler.clickSlot(slotTo, MouseButton.LEFT, false);
                } else {
                    for (i = 0; i < numItemsToMove; ++i) {
                        handler.clickSlot(slotTo, MouseButton.RIGHT, false);
                    }
                }
                handler.clickSlot(slotFrom, MouseButton.LEFT, false);
                return;
            }
            slotTo = selectedSlot;
            slotFrom = applicableSlot;
            stackTo = slotTo.func_75211_c().func_77946_l();
            stackFrom = slotFrom.func_75211_c().func_77946_l();
            if (stackTo.func_190916_E() == stackTo.func_77976_d()) {
                return;
            }
            if (stackTo.func_77976_d() - stackTo.func_190916_E() <= numItemsToMove) {
                handler.clickSlot(slotFrom, MouseButton.LEFT, false);
                handler.clickSlot(slotTo, MouseButton.LEFT, false);
                if (handler.isCraftingOutput(slotFrom)) continue;
                handler.clickSlot(slotFrom, MouseButton.LEFT, false);
                continue;
            }
            handler.clickSlot(slotFrom, MouseButton.LEFT, false);
            if (handler.isCraftingOutput(slotFrom)) {
                handler.clickSlot(slotTo, MouseButton.LEFT, false);
                --numItemsToMove;
            } else if (stackFrom.func_190916_E() <= numItemsToMove) {
                handler.clickSlot(slotTo, MouseButton.LEFT, false);
                numItemsToMove -= stackFrom.func_190916_E();
            } else {
                for (i = 0; i < numItemsToMove; ++i) {
                    handler.clickSlot(slotTo, MouseButton.RIGHT, false);
                }
                numItemsToMove = 0;
            }
            if (handler.isCraftingOutput(slotFrom)) continue;
            handler.clickSlot(slotFrom, MouseButton.LEFT, false);
        } while (numItemsToMove > 0);
    }

    private static boolean otherInventoryIsAbove(Slot selectedSlot, List<Slot> slots) {
        boolean selectedIsInPlayerInventory = selectedSlot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by;
        for (Slot slot : slots) {
            if (slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by == selectedIsInPlayerInventory || slot.field_75221_f >= selectedSlot.field_75221_f) continue;
            return true;
        }
        return false;
    }

    private static IGuiScreenHandler findHandler(GuiScreen currentScreen) {
        if (currentScreen instanceof IMTModGuiContainer2Ex) {
            return new IMTModGuiContainer2ExHandler((IMTModGuiContainer2Ex)currentScreen);
        }
        if (currentScreen instanceof IMTModGuiContainer2) {
            return new IMTModGuiContainer2Handler((IMTModGuiContainer2)currentScreen);
        }
        if (currentScreen instanceof IMTModGuiContainer) {
            return new IMTModGuiContainerHandler((IMTModGuiContainer)currentScreen);
        }
        if (currentScreen instanceof GuiContainerCreative) {
            return new GuiContainerCreativeHandler((GuiContainerCreative)currentScreen);
        }
        if (currentScreen instanceof GuiContainer) {
            return new GuiContainerHandler((GuiContainer)currentScreen);
        }
        return null;
    }

    private static boolean areStacksCompatible(ItemStack a, ItemStack b) {
        return a.func_190926_b() || b.func_190926_b() || a.func_77969_a(b) && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    private static Slot findWheelApplicableSlot(List<Slot> slots, Slot selectedSlot, boolean pushItems) {
        int direction;
        int endIndex;
        int startIndex;
        if (pushItems || MTConfig.wheelSearchOrder == MTConfig.WheelSearchOrder.FIRST_TO_LAST) {
            startIndex = 0;
            endIndex = slots.size();
            direction = 1;
        } else {
            startIndex = slots.size() - 1;
            endIndex = -1;
            direction = -1;
        }
        ItemStack originalStack = selectedSlot.func_75211_c();
        boolean findInPlayerInventory = selectedSlot.field_75224_c != Minecraft.func_71410_x().field_71439_g.field_71071_by;
        Slot rv = null;
        Slot firstAllowedEncounter = null;
        for (int i = startIndex; i != endIndex; i += direction) {
            Slot slot = slots.get(i);
            if (handler.isIgnored(slot) || (findInPlayerInventory ? slot.field_75224_c != Minecraft.func_71410_x().field_71439_g.field_71071_by : slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by)) continue;
            ItemStack stack = slot.func_75211_c();
            int priority = handler.isSlotPrioritized(slot, originalStack);
            if (stack.func_190926_b()) {
                if (rv != null || !pushItems || !slot.func_75214_a(originalStack) || handler.isCraftingOutput(slot)) continue;
                switch (priority) {
                    case -1: 
                    case 1: {
                        rv = slot;
                        break;
                    }
                    case 0: {
                        if (firstAllowedEncounter != null) break;
                        firstAllowedEncounter = slot;
                    }
                }
                continue;
            }
            if (!Main.areStacksCompatible(originalStack, stack)) continue;
            if (pushItems) {
                if (handler.isCraftingOutput(slot) || stack.func_190916_E() >= stack.func_77976_d()) continue;
                switch (priority) {
                    case -1: 
                    case 1: {
                        return slot;
                    }
                    case 0: {
                        firstAllowedEncounter = slot;
                    }
                }
                continue;
            }
            return slot;
        }
        if (rv == null && firstAllowedEncounter != null) {
            return firstAllowedEncounter;
        }
        return rv;
    }
}

