/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.world.schematic;

import com.google.common.collect.Maps;
import elec332.core.api.structure.ISchematic;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;

public class Schematic
implements ISchematic {
    protected final NBTTagList tileDataList;
    private short width;
    private short height;
    private short length;
    private short horizon;
    protected byte[] data;
    protected Block[] blocks;
    private Map<BlockPos, NBTTagCompound> tiles;

    protected Schematic(NBTTagList tileEntities, short width, short height, short length, short horizon, byte[] data, Block[] blocks) {
        this.tileDataList = tileEntities;
        this.width = width;
        this.height = height;
        this.length = length;
        this.horizon = horizon;
        this.data = data;
        this.blocks = blocks;
        this.tiles = Maps.newHashMap();
        this.reloadTileMap();
    }

    private void reloadTileMap() {
        this.tiles.clear();
        for (int i = 0; i < this.tileDataList.func_74745_c(); ++i) {
            NBTTagCompound tag = this.tileDataList.func_150305_b(i).func_74737_b();
            BlockPos pos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
            this.tiles.put(pos, tag);
        }
    }

    @Override
    public Block getBlock(int x, int y, int z) {
        return this.blocks[this.getIndexFromCoordinates(x, y, z)];
    }

    @Override
    public NBTTagCompound getTileData(int x, int y, int z, int worldX, int worldY, int worldZ) {
        NBTTagCompound tag = this.getTileData(x, y, z);
        if (tag != null) {
            tag.func_74768_a("x", worldX);
            tag.func_74768_a("y", worldY);
            tag.func_74768_a("z", worldZ);
            return tag;
        }
        return null;
    }

    @Override
    public NBTTagCompound getTileData(int x, int y, int z) {
        NBTTagCompound tag = this.tiles.get(new BlockPos(x, y, z));
        if (tag != null) {
            return tag.func_74737_b();
        }
        return null;
    }

    @Override
    public byte getMetadata(int x, int y, int z) {
        return this.data[this.getIndexFromCoordinates(x, y, z)];
    }

    @Override
    public short getBlockLength() {
        return this.length;
    }

    @Override
    public short getBlockWidth() {
        return this.width;
    }

    @Override
    public short getBlockHeight() {
        return this.height;
    }

    @Override
    public short getHorizon() {
        return this.horizon;
    }

    private int getIndexFromCoordinates(int x, int y, int z) {
        return y * this.width * this.length + z * this.width + x;
    }
}

