/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.world;

import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import elec332.core.api.APIHandlerInject;
import elec332.core.api.IAPIHandler;
import elec332.core.api.annotations.StaticLoad;
import elec332.core.api.registry.ISingleObjectRegistry;
import elec332.core.api.world.FeatureGeneratorWrapper;
import elec332.core.api.world.IAdvancedChunkPopulator;
import elec332.core.api.world.IFeatureGenerator;
import elec332.core.api.world.IWorldGenHook;
import elec332.core.api.world.IWorldGenManager;
import elec332.core.util.FMLUtil;
import elec332.core.world.WorldHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@StaticLoad
enum WorldGenManager implements ISingleObjectRegistry<IWorldGenHook>,
IWorldGenManager
{
    INSTANCE;

    private final Function<Integer, SetMultimap<ChunkPos, IFeatureGenerator>> absentGen;
    private final Set<IWorldGenHook> set = Sets.newHashSet();
    private final Set<IWorldGenHook> set_ = Collections.unmodifiableSet(this.set);
    private final Map<Integer, SetMultimap<ChunkPos, IFeatureGenerator>> retroGenChunks;
    private static final String KEY = "eleccore:worldgenmanager";

    private WorldGenManager() {
        this.absentGen = input -> HashMultimap.create();
        this.retroGenChunks = Maps.newHashMap();
    }

    @SubscribeEvent
    public void populateChunk(PopulateChunkEvent.Post event) {
        for (IWorldGenHook wgh : this.set_) {
            wgh.populateChunk(event.getGenerator(), event.getWorld(), event.getRand(), event.getChunkX(), event.getChunkZ(), event.isHasVillageGenerated());
        }
    }

    @SubscribeEvent
    public void chunkLoadFromDisk(ChunkDataEvent.Load event) {
        Chunk chunk = event.getChunk();
        NBTTagCompound tag = event.getData().func_74775_l(KEY);
        for (IWorldGenHook wgh : this.set_) {
            wgh.chunkLoadedFromDisk(chunk, tag, this);
        }
    }

    @SubscribeEvent
    public void chunkSaveToDisk(ChunkDataEvent.Save event) {
        Chunk chunk = event.getChunk();
        NBTTagCompound tag = new NBTTagCompound();
        for (IWorldGenHook wgh : this.set_) {
            wgh.chunkSavedToDisk(chunk, tag, this);
        }
        event.getData().func_74782_a(KEY, (NBTBase)tag);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        ChunkPos pos;
        Set s;
        SetMultimap<ChunkPos, IFeatureGenerator> map = this.retroGenChunks.computeIfAbsent(WorldHelper.getDimID(event.world), this.absentGen);
        if (!map.isEmpty() && (s = map.removeAll((Object)(pos = (ChunkPos)map.keySet().iterator().next()))) != null && !s.isEmpty()) {
            long worldSeed = event.world.func_72905_C();
            Random random = new Random(worldSeed);
            long xSeed = random.nextLong() >> 3;
            long zSeed = random.nextLong() >> 3;
            long seed = xSeed * (long)pos.field_77276_a + zSeed * (long)pos.field_77275_b ^ worldSeed;
            for (IFeatureGenerator featureGenerator : s) {
                random.setSeed(seed);
                featureGenerator.generateFeature(random, pos.field_77276_a, pos.field_77275_b, event.world);
            }
        }
    }

    @Override
    public boolean register(IAdvancedChunkPopulator chunkPopulator) {
        if (!FMLUtil.isInModInitialisation()) {
            return false;
        }
        ModContainer mc = FMLUtil.getLoader().activeModContainer();
        if (mc == null) {
            throw new IllegalArgumentException();
        }
        return this.register(new ChunkPopulatorWrapper(chunkPopulator, mc.getModId()));
    }

    @Override
    public boolean register(IFeatureGenerator featureGenerator) {
        return FMLUtil.isInModInitialisation() && this.register(new FeatureGeneratorWrapper(featureGenerator));
    }

    @Override
    public void registerForRetroGen(@Nonnull World world, @Nonnull ChunkPos chunk, IFeatureGenerator ... featureGenerators) {
        if (featureGenerators == null || featureGenerators.length == 0) {
            return;
        }
        this.registerForRetroGen(world, chunk, Lists.newArrayList());
    }

    @Override
    public void registerForRetroGen(@Nonnull World world, @Nonnull ChunkPos chunk, Collection<IFeatureGenerator> featureGenerators) {
        if (featureGenerators == null || featureGenerators.size() == 0) {
            return;
        }
        this.retroGenChunks.computeIfAbsent(WorldHelper.getDimID(world), this.absentGen).putAll((Object)chunk, featureGenerators);
    }

    @Override
    public boolean register(IWorldGenHook wgh) {
        return FMLUtil.isInModInitialisation() && this.set.add(wgh);
    }

    @Override
    public Set<IWorldGenHook> getAllRegisteredObjects() {
        return this.set_;
    }

    @APIHandlerInject
    public void injectWorldGenManager(IAPIHandler apiHandler) {
        apiHandler.inject(INSTANCE, IWorldGenManager.class);
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    private class ChunkPopulatorWrapper
    implements IWorldGenHook,
    IFeatureGenerator {
        private final IAdvancedChunkPopulator chunkPopulator;
        private final String owner;
        private String lastKey;

        private ChunkPopulatorWrapper(IAdvancedChunkPopulator chunkPopulator, String owner) {
            this.chunkPopulator = chunkPopulator;
            this.owner = owner.toLowerCase();
        }

        @Override
        public String getName() {
            return this.chunkPopulator.getName();
        }

        @Override
        public void populateChunk(IChunkGenerator chunkGenerator, World world, Random rand, int chunkX, int chunkZ, boolean hasVillageGenerated) {
            this.chunkPopulator.populateChunk(chunkGenerator, world, rand, chunkX, chunkZ, hasVillageGenerated);
            this.lastKey = this.chunkPopulator.getGenKey();
        }

        @Override
        public void chunkLoadedFromDisk(Chunk chunk, NBTTagCompound data, IWorldGenManager worldGenManager) {
            NBTTagCompound tag = data.func_74775_l(this.owner);
            boolean b = tag.func_74764_b(this.chunkPopulator.getName());
            if (!(b && this.chunkPopulator.getGenKey().equals(tag.func_74779_i(this.chunkPopulator.getName())) || !this.chunkPopulator.shouldRegen(b))) {
                worldGenManager.registerForRetroGen(chunk.func_177412_p(), chunk.func_76632_l(), this);
            } else {
                this.lastKey = this.chunkPopulator.getGenKey();
            }
        }

        @Override
        public void chunkSavedToDisk(Chunk chunk, NBTTagCompound data, IWorldGenManager worldGenManager) {
            NBTTagCompound tag = data.func_74775_l(this.owner);
            if (!Strings.isNullOrEmpty((String)this.lastKey)) {
                tag.func_74778_a(this.chunkPopulator.getName(), this.lastKey);
            }
            data.func_74782_a(this.owner, (NBTBase)tag);
        }

        @Override
        public boolean generateFeature(Random random, int chunkX, int chunkZ, World world) {
            boolean ret = this.chunkPopulator.retroGen(random, chunkX, chunkZ, world);
            this.lastKey = this.chunkPopulator.getGenKey();
            return ret;
        }
    }
}

