/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import elec332.core.api.registry.ISingleObjectRegistry;
import elec332.core.api.registry.SimpleRegistries;
import java.util.List;
import java.util.Set;
import net.minecraft.command.ICommand;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

public class CommandHelper {
    private static final ISingleObjectRegistry<ICommand> serverCommandRegistry;
    private static final ISingleObjectRegistry<ICommand> clientCommandRegistry;
    private static final List<ICommand> commands;

    public static ISingleObjectRegistry<ICommand> getServerCommandRegistry() {
        return serverCommandRegistry;
    }

    public static ISingleObjectRegistry<ICommand> getClientCommandRegistry() {
        return clientCommandRegistry;
    }

    public static void registerCommands(FMLServerStartingEvent event) {
        for (ICommand command : commands) {
            event.registerServerCommand(command);
        }
    }

    static {
        commands = Lists.newArrayList();
        clientCommandRegistry = FMLCommonHandler.instance().getSide().isClient() ? new ISingleObjectRegistry<ICommand>(){

            @Override
            public boolean register(ICommand command) {
                ClientCommandHandler.instance.func_71560_a(command);
                return true;
            }

            @Override
            public Set<ICommand> getAllRegisteredObjects() {
                return Sets.newHashSet(ClientCommandHandler.instance.func_71555_a().values());
            }
        } : SimpleRegistries.emptySingleObjectRegistry();
        serverCommandRegistry = new ISingleObjectRegistry<ICommand>(){

            @Override
            public boolean register(ICommand command) {
                commands.add(command);
                return true;
            }

            @Override
            public Set<ICommand> getAllRegisteredObjects() {
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                return server == null ? ImmutableSet.of() : Sets.newHashSet(server.field_71321_q.func_71555_a().values());
            }
        };
    }
}

